/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.util;

import com.alibaba.fastjson.JSON;
import com.gitee.easyopen.message.Errors;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;

public class RequestUtil {
    private static final String CONTENT_TYPE_URLENCODED = "application/x-www-form-urlencoded";
    private static final String CONTENT_TYPE_JSON = "application/json";
    private static final String CONTENT_TYPE_TEXT = "text/plain";
    private static final String UTF8 = "UTF-8";
    private static final String GET = "get";
    private static final String UNKOWN = "unknown";
    private static final String LOCAL_IP = "127.0.0.1";
    private static final int IP_LEN = 15;

    public static String getText(HttpServletRequest request) throws Exception {
        return IOUtils.toString((InputStream)request.getInputStream(), (String)UTF8);
    }

    public static String getJson(HttpServletRequest request) throws Exception {
        String requestJson = null;
        String contectType = request.getContentType();
        if (contectType == null || "".equals(contectType.trim())) {
            throw Errors.NO_CONTECT_TYPE_SUPPORT.getException(contectType);
        }
        if ((contectType = contectType.toLowerCase()).contains(CONTENT_TYPE_JSON) || contectType.contains(CONTENT_TYPE_TEXT)) {
            requestJson = RequestUtil.getText(request);
        } else if (contectType.contains(CONTENT_TYPE_URLENCODED)) {
            Map<String, Object> params = RequestUtil.convertRequestParamsToMap(request);
            requestJson = JSON.toJSONString(params);
        } else {
            throw Errors.NO_CONTECT_TYPE_SUPPORT.getException(contectType);
        }
        return requestJson;
    }

    public static Map<String, Object> convertRequestParamsToMap(HttpServletRequest request) {
        Map paramMap = request.getParameterMap();
        if (paramMap == null || paramMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> retMap = new HashMap<String, Object>(paramMap.size());
        Set entrySet = paramMap.entrySet();
        for (Map.Entry entry : entrySet) {
            String name = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            if (values.length == 1) {
                retMap.put(name, values[0]);
                continue;
            }
            if (values.length > 1) {
                retMap.put(name, values);
                continue;
            }
            retMap.put(name, "");
        }
        return retMap;
    }

    public static String getClientIP(HttpServletRequest request) {
        String ipAddress = request.getHeader("x-forwarded-for");
        if (ipAddress == null || ipAddress.length() == 0 || UNKOWN.equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || UNKOWN.equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if ((ipAddress == null || ipAddress.length() == 0 || UNKOWN.equalsIgnoreCase(ipAddress)) && LOCAL_IP.equals(ipAddress = request.getRemoteAddr())) {
            try {
                InetAddress inet = InetAddress.getLocalHost();
                ipAddress = inet.getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (ipAddress != null && ipAddress.length() > 15 && ipAddress.indexOf(",") > 0) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
        }
        return ipAddress;
    }

    public static boolean isGetRequest(HttpServletRequest request) {
        return GET.equalsIgnoreCase(request.getMethod());
    }
}

