/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.util;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.NullLogChute;

public class VelocityUtil {
    private static String UTF8 = "UTF-8";
    private static String LOG_TAG;

    public static String generateToString(VelocityContext context, InputStream inputStream) {
        StringWriter writer = new StringWriter();
        VelocityUtil.generate(context, inputStream, (Writer)writer);
        return writer.toString();
    }

    public static String generateToString(VelocityContext context, String content) {
        StringWriter writer = new StringWriter();
        VelocityUtil.generate(context, new StringReader(content), (Writer)writer);
        return writer.toString();
    }

    public static void generate(VelocityContext context, InputStream inputStream, Writer writer) {
        try {
            VelocityUtil.generate(context, new InputStreamReader(inputStream, UTF8), writer);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public static void generate(VelocityContext context, Reader reader, Writer writer) {
        try {
            Velocity.evaluate((Context)context, (Writer)writer, (String)LOG_TAG, (Reader)reader);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    static {
        Velocity.setProperty((String)"runtime.log.logsystem", (Object)new NullLogChute());
        Velocity.init();
        LOG_TAG = VelocityUtil.class.getName();
    }
}

