/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.verify;

import com.gitee.easyopen.ApiContext;
import com.gitee.easyopen.ApiParam;
import com.gitee.easyopen.Encrypter;
import com.gitee.easyopen.verify.Verifier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class DefaultMd5Verifier
implements Verifier {
    @Override
    public boolean verify(ApiParam apiParam, String secret) {
        boolean isSame = false;
        String signCode = apiParam.fatchSignAndRemove();
        if (signCode != null) {
            try {
                String clientSign = this.buildSign((Map<String, ?>)((Object)apiParam), secret);
                isSame = signCode.equals(clientSign);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return isSame;
    }

    public String buildSign(Map<String, ?> paramsMap, String secret) throws IOException {
        Set<String> keySet = paramsMap.keySet();
        ArrayList<String> paramNames = new ArrayList<String>(keySet);
        Collections.sort(paramNames);
        StringBuilder paramNameValue = new StringBuilder();
        for (String paramName : paramNames) {
            paramNameValue.append(paramName).append(paramsMap.get(paramName));
        }
        String source = secret + paramNameValue.toString() + secret;
        return this.encrypt(source);
    }

    public String encrypt(String source) {
        Encrypter encrypter = ApiContext.getApiConfig().getEncrypter();
        return encrypter.md5(source).toUpperCase();
    }
}

