/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.v3sdk.common.crypt;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.qiyuesuo.v3sdk.common.utils.Base64Utils;
import net.qiyuesuo.v3sdk.exception.PrivateAppException;
import org.apache.commons.codec.binary.Hex;

public class Hmac {
    private static final String SHA_256 = "SHA-256";
    private static String DEFAULT_HMAC_ALGO = "HMACSHA256";

    public static String compute(String rawStr, String secret) {
        SecretKeySpec signKey = new SecretKeySpec(secret.getBytes(), DEFAULT_HMAC_ALGO);
        Mac mac = null;
        try {
            mac = Mac.getInstance(DEFAULT_HMAC_ALGO);
            mac.init(signKey);
            byte[] signatureBytes = mac.doFinal(rawStr.getBytes());
            String res = Hex.encodeHexString((byte[])signatureBytes);
            return Base64Utils.encode(signatureBytes);
        }
        catch (Exception e) {
            throw new PrivateAppException("compute signature error", e);
        }
    }

    public static Mac getMac(String secret) {
        SecretKeySpec signKey = new SecretKeySpec(secret.getBytes(), DEFAULT_HMAC_ALGO);
        Mac mac = null;
        try {
            mac = Mac.getInstance(DEFAULT_HMAC_ALGO);
            mac.init(signKey);
            return mac;
        }
        catch (Exception e) {
            throw new PrivateAppException("compute signature error", e);
        }
    }
}

