/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.v3sdk.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import net.qiyuesuo.v3sdk.common.utils.StringUtils;

public class TimeUtils {
    public static final String DEFAULT_PATTERN = "yyyy-MM-dd";
    public static final String STANDARD_PATTERN = "yyyy-MM-dd HH:mm:ss";

    public static String format(Date date) {
        return TimeUtils.format(date, DEFAULT_PATTERN);
    }

    public static Date parse(String dateStr) throws ParseException {
        if (StringUtils.isEmpty(dateStr)) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(STANDARD_PATTERN);
        return simpleDateFormat.parse(dateStr);
    }

    public static String format(Date date, String pattern) {
        date = date == null ? new Date() : date;
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        return dateFormat.format(date);
    }

    public static Date startOfWeek(Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.setFirstDayOfWeek(2);
        c.set(7, 2);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        return c.getTime();
    }

    public static Date endOfWeek(Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.setFirstDayOfWeek(2);
        c.set(7, 1);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        return c.getTime();
    }

    public static Date startOfMonth(Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        return c.getTime();
    }

    public static Date endOfMonth(Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, c.getActualMaximum(5));
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        return c.getTime();
    }

    public static Date startOfCurMonth() {
        return TimeUtils.startOfMonth(new Date());
    }

    public static Date endOfCurMonth() {
        return TimeUtils.endOfMonth(new Date());
    }

    public static Date startOfPreMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(TimeUtils.startOfCurMonth());
        calendar.add(2, -1);
        return calendar.getTime();
    }

    public static Date endOfPreMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(TimeUtils.endOfCurMonth());
        calendar.add(2, -1);
        return calendar.getTime();
    }

    public static Date startOfCurWeek() {
        return TimeUtils.startOfWeek(new Date());
    }

    public static Date endOfCurWeek() {
        return TimeUtils.endOfWeek(new Date());
    }

    public static Date startOfPreWeek() {
        Date curMon = TimeUtils.startOfCurWeek();
        Calendar c = Calendar.getInstance();
        c.setTime(curMon);
        c.add(7, -7);
        return c.getTime();
    }

    public static Date endOfPreWeek() {
        Date curSun = TimeUtils.endOfCurWeek();
        Calendar c = Calendar.getInstance();
        c.setTime(curSun);
        c.add(7, -7);
        return c.getTime();
    }

    public static Date endOf(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    public static Date startOf(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date startOfYesterday() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        return TimeUtils.startOf(calendar.getTime());
    }

    public static Date endOfYesterday() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        return TimeUtils.endOf(calendar.getTime());
    }

    public static Date after(Date date, int after) {
        if (date == null) {
            return null;
        }
        if (after <= 0) {
            return date;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, after);
        return calendar.getTime();
    }

    public static Date before(Date date, int before) {
        if (date == null) {
            return null;
        }
        if (before <= 0) {
            return date;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1 * before);
        return calendar.getTime();
    }

    public static Date startOfHour(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date endOfHour(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    public static int getMonthSpace(Date date1, Date date2) {
        int iMonth = 0;
        int flag = 0;
        try {
            Calendar objCalendarDate1 = Calendar.getInstance();
            objCalendarDate1.setTime(date1);
            Calendar objCalendarDate2 = Calendar.getInstance();
            objCalendarDate2.setTime(date2);
            if (objCalendarDate2.equals(objCalendarDate1)) {
                return 0;
            }
            if (objCalendarDate1.after(objCalendarDate2)) {
                Calendar temp = objCalendarDate1;
                objCalendarDate1 = objCalendarDate2;
                objCalendarDate2 = temp;
            }
            if (objCalendarDate2.get(5) < objCalendarDate1.get(5)) {
                flag = 1;
            }
            iMonth = objCalendarDate2.get(1) > objCalendarDate1.get(1) ? (objCalendarDate2.get(1) - objCalendarDate1.get(1)) * 12 + objCalendarDate2.get(2) - flag - objCalendarDate1.get(2) : objCalendarDate2.get(2) - objCalendarDate1.get(2) - flag;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return iMonth;
    }
}

