/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.v3sdk.http;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import net.qiyuesuo.v3sdk.common.utils.StringUtils;
import net.qiyuesuo.v3sdk.http.HttpHeader;
import net.qiyuesuo.v3sdk.http.HttpMethod;
import net.qiyuesuo.v3sdk.http.TrustAllTrustManager;

public class HttpConnection {
    private static boolean ignoreSSLCheck = false;
    private static HostnameVerifier hostnameVerifier = new TrustAllHostnameVerifier();

    public static HttpURLConnection getConnection(URL url, HttpMethod method, HttpHeader header) throws Exception {
        Map<String, String> customHeaders;
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection httpsConnection = (HttpsURLConnection)conn;
            httpsConnection.setHostnameVerifier(hostnameVerifier);
            if (ignoreSSLCheck) {
                SSLSocketFactory sslSocketFactory = TrustAllTrustManager.getSSLSocketFactory();
                httpsConnection.setSSLSocketFactory(sslSocketFactory);
            }
            conn = httpsConnection;
        }
        conn.setRequestMethod(method.name());
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Host", url.getHost());
        conn.setRequestProperty("Accept", "text/plain,application/json");
        conn.setRequestProperty("Accept-Encoding", "gzip,deflate");
        conn.setRequestProperty("User-Agent", "privateapp-java-client");
        conn.setRequestProperty("x-qys-accesstoken", header.getAccessToken());
        conn.setRequestProperty("x-qys-timestamp", Long.toString(header.getTimestamp()));
        conn.setRequestProperty("x-qys-signature", header.getSignature());
        conn.setRequestProperty("x-qys-nonce", header.getNonce());
        conn.setRequestProperty("x-qys-signature-version", header.getSignatureVersion());
        conn.setRequestProperty("x-qys-clienttoken", header.getClientToken());
        conn.setRequestProperty("x-qys-traceid", header.getTraceId());
        conn.setRequestProperty("x-qys-body", "");
        if (StringUtils.isNotBlank(header.getIdempotentToken())) {
            conn.setRequestProperty("x-qys-clienttoken", header.getIdempotentToken());
        }
        if ((customHeaders = header.getCustomHeaders()) != null && !customHeaders.isEmpty()) {
            for (Map.Entry<String, String> entry : customHeaders.entrySet()) {
                if (!StringUtils.isNotBlank(entry.getKey()) || !StringUtils.isNotBlank(entry.getValue())) continue;
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return conn;
    }

    public static void close(HttpURLConnection conn) {
        if (conn != null) {
            conn.disconnect();
        }
    }

    private static class TrustAllHostnameVerifier
    implements HostnameVerifier {
        private TrustAllHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

