/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryMember;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.AccessUtil;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class AccessFixer
extends SimplifiedVisitor
implements ConstantVisitor,
ClassVisitor,
MemberVisitor {
    private MyReferencedClassFinder referencedClassFinder = new MyReferencedClassFinder();
    private Clazz referencingClass;
    private Clazz referencedClass;

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        this.referencingClass = clazz;
        this.referencedClass = stringConstant.referencedClass;
        stringConstant.referencedClassAccept(this);
        stringConstant.referencedMemberAccept(this);
    }

    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        invokeDynamicConstant.bootstrapMethodHandleAccept(clazz, this);
    }

    public void visitMethodHandleConstant(Clazz clazz, MethodHandleConstant methodHandleConstant) {
        clazz.constantPoolEntryAccept(methodHandleConstant.u2referenceIndex, this);
    }

    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        this.referencingClass = clazz;
        clazz.constantPoolEntryAccept(refConstant.u2classIndex, this.referencedClassFinder);
        refConstant.referencedMemberAccept(this);
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        this.referencingClass = clazz;
        classConstant.referencedClassAccept(this);
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    public void visitProgramClass(ProgramClass programClass) {
        int requiredAccessLevel;
        int currentAccessFlags = programClass.getAccessFlags();
        int currentAccessLevel = AccessUtil.accessLevel(currentAccessFlags);
        Clazz referencingClass = this.referencingClass;
        int n = requiredAccessLevel = this.inSamePackage(programClass, referencingClass) ? 1 : 3;
        if (currentAccessLevel < requiredAccessLevel) {
            programClass.u2accessFlags = AccessUtil.replaceAccessFlags(currentAccessFlags, AccessUtil.accessFlags(requiredAccessLevel));
        }
    }

    public void visitLibraryMember(LibraryClass libraryClass, LibraryMember libraryMember) {
    }

    public void visitProgramMember(ProgramClass programClass, ProgramMember programMember) {
        int requiredAccessLevel;
        int currentAccessFlags = programMember.getAccessFlags();
        int currentAccessLevel = AccessUtil.accessLevel(currentAccessFlags);
        int n = programClass.equals(this.referencingClass) ? 0 : (this.inSamePackage(programClass, this.referencingClass) ? 1 : (requiredAccessLevel = this.referencedClass.extends_(this.referencingClass) && this.referencingClass.extends_(programClass) ? 2 : 3));
        if (currentAccessLevel < requiredAccessLevel) {
            programMember.u2accessFlags = AccessUtil.replaceAccessFlags(currentAccessFlags, AccessUtil.accessFlags(requiredAccessLevel));
        }
    }

    private boolean inSamePackage(ProgramClass class1, Clazz class2) {
        return ClassUtil.internalPackageName(class1.getName()).equals(ClassUtil.internalPackageName(class2.getName()));
    }

    private class MyReferencedClassFinder
    extends SimplifiedVisitor
    implements ConstantVisitor {
        private MyReferencedClassFinder() {
        }

        public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
            AccessFixer.this.referencedClass = classConstant.referencedClass;
        }
    }
}

