/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import proguard.obfuscate.MappingProcessor;

public class MappingReader {
    private final File mappingFile;

    public MappingReader(File mappingFile) {
        this.mappingFile = mappingFile;
    }

    public void pump(MappingProcessor mappingProcessor) throws IOException {
        LineNumberReader reader = new LineNumberReader(new BufferedReader(new FileReader(this.mappingFile)));
        try {
            String line;
            String className = null;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).endsWith(":")) {
                    className = this.processClassMapping(line, mappingProcessor);
                    continue;
                }
                if (className == null) continue;
                this.processClassMemberMapping(className, line, mappingProcessor);
            }
        }
        catch (IOException ex) {
            throw new IOException("Can't process mapping file (" + ex.getMessage() + ")");
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ex) {}
        }
    }

    private String processClassMapping(String line, MappingProcessor mappingProcessor) {
        String newClassName;
        int arrowIndex = line.indexOf("->");
        if (arrowIndex < 0) {
            return null;
        }
        int colonIndex = line.indexOf(58, arrowIndex + 2);
        if (colonIndex < 0) {
            return null;
        }
        String className = line.substring(0, arrowIndex).trim();
        boolean interested = mappingProcessor.processClassMapping(className, newClassName = line.substring(arrowIndex + 2, colonIndex).trim());
        return interested ? className : null;
    }

    private void processClassMemberMapping(String className, String line, MappingProcessor mappingProcessor) {
        int colonIndex1 = line.indexOf(58);
        int colonIndex2 = colonIndex1 < 0 ? -1 : line.indexOf(58, colonIndex1 + 1);
        int spaceIndex = line.indexOf(32, colonIndex2 + 2);
        int argumentIndex1 = line.indexOf(40, spaceIndex + 1);
        int argumentIndex2 = argumentIndex1 < 0 ? -1 : line.indexOf(41, argumentIndex1 + 1);
        int arrowIndex = line.indexOf("->", Math.max(spaceIndex, argumentIndex2) + 1);
        if (spaceIndex < 0 || arrowIndex < 0) {
            return;
        }
        String type = line.substring(colonIndex2 + 1, spaceIndex).trim();
        String name = line.substring(spaceIndex + 1, argumentIndex1 >= 0 ? argumentIndex1 : arrowIndex).trim();
        String newName = line.substring(arrowIndex + 2).trim();
        if (type.length() > 0 && name.length() > 0 && newName.length() > 0) {
            if (argumentIndex2 < 0) {
                mappingProcessor.processFieldMapping(className, type, name, newName);
            } else {
                int firstLineNumber = 0;
                int lastLineNumber = 0;
                if (colonIndex2 > 0) {
                    firstLineNumber = Integer.parseInt(line.substring(0, colonIndex1).trim());
                    lastLineNumber = Integer.parseInt(line.substring(colonIndex1 + 1, colonIndex2).trim());
                }
                String arguments = line.substring(argumentIndex1 + 1, argumentIndex2).trim();
                mappingProcessor.processMethodMapping(className, firstLineNumber, lastLineNumber, type, name, arguments, newName);
            }
        }
    }
}

