/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentOperator;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.java.ast.ASTBreakStatement;
import net.sourceforge.pmd.lang.java.ast.ASTCatchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBody;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalAndExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalOrExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTContinueStatement;
import net.sourceforge.pmd.lang.java.ast.ASTDoStatement;
import net.sourceforge.pmd.lang.java.ast.ASTEnumBody;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFinallyStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForInit;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForUpdate;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTLabeledStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPostfixExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPreDecrementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPreIncrementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTResourceSpecification;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTStatement;
import net.sourceforge.pmd.lang.java.ast.ASTStatementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchExpression;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabel;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabeledRule;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTThrowStatement;
import net.sourceforge.pmd.lang.java.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.ASTVariableInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.ast.ASTYieldStatement;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitorAdapter;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.rule.codestyle.ConfusingTernaryRule;
import net.sourceforge.pmd.lang.java.symboltable.ClassScope;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.Scope;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class UnusedAssignmentRule
extends AbstractJavaRule {
    private static final PropertyDescriptor<Boolean> CHECK_PREFIX_INCREMENT = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"checkUnusedPrefixIncrement").desc("Report expressions like ++i that may be replaced with (i + 1)")).defaultValue((Object)false)).build();
    private static final PropertyDescriptor<Boolean> REPORT_UNUSED_VARS = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"reportUnusedVariables").desc("Report variables that are only initialized, and never read at all. The rule UnusedVariable already cares for that, but you can enable it if needed")).defaultValue((Object)false)).build();

    public UnusedAssignmentRule() {
        this.definePropertyDescriptor(CHECK_PREFIX_INCREMENT);
        this.definePropertyDescriptor(REPORT_UNUSED_VARS);
        this.addRuleChainVisit(ASTCompilationUnit.class);
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        for (JavaNode child : node.children()) {
            if (!(child instanceof ASTTypeDeclaration)) continue;
            ASTAnyTypeDeclaration typeDecl = (ASTAnyTypeDeclaration)child.getChild(child.getNumChildren() - 1);
            GlobalAlgoState result = new GlobalAlgoState();
            typeDecl.jjtAccept(ReachingDefsVisitor.ONLY_LOCALS, new SpanInfo(result));
            this.reportFinished(result, (RuleContext)data);
        }
        return data;
    }

    private void reportFinished(GlobalAlgoState result, RuleContext ruleCtx) {
        if (result.usedAssignments.size() < result.allAssignments.size()) {
            Set<AssignmentEntry> unused = result.allAssignments;
            unused.removeAll(result.usedAssignments);
            for (AssignmentEntry entry : unused) {
                String reason;
                if (this.isIgnorablePrefixIncrement(entry.rhs)) continue;
                Set<AssignmentEntry> killers = result.killRecord.get(entry);
                if (killers == null || killers.isEmpty()) {
                    if (entry.var.isField() || this.suppressUnusedVariableRuleOverlap(entry)) continue;
                    reason = null;
                } else if (killers.size() == 1) {
                    AssignmentEntry k = killers.iterator().next();
                    if (k.rhs.equals(entry.rhs)) {
                        if (this.suppressUnusedVariableRuleOverlap(entry)) continue;
                        reason = entry.rhs instanceof ASTVariableDeclaratorId ? null : "reassigned every iteration";
                    } else {
                        reason = "overwritten on line " + k.rhs.getBeginLine();
                    }
                } else {
                    reason = UnusedAssignmentRule.joinLines("overwritten on lines ", killers);
                }
                if (reason == null && this.hasExplicitIgnorableName(entry.var.getName())) continue;
                this.addViolationWithMessage(ruleCtx, (Node)entry.rhs, UnusedAssignmentRule.makeMessage(entry, reason, entry.var.isField()));
            }
        }
    }

    private boolean hasExplicitIgnorableName(String name) {
        return name.startsWith("ignored") || "_".equals(name);
    }

    private boolean suppressUnusedVariableRuleOverlap(AssignmentEntry entry) {
        return (Boolean)this.getProperty(REPORT_UNUSED_VARS) == false && (entry.rhs instanceof ASTVariableInitializer || entry.rhs instanceof ASTVariableDeclaratorId);
    }

    private static String getKind(ASTVariableDeclaratorId id) {
        if (id.isField()) {
            return "field";
        }
        if (id.isResourceDeclaration()) {
            return "resource";
        }
        if (id.isExceptionBlockParameter()) {
            return "exception parameter";
        }
        if (id.getNthParent(3) instanceof ASTForStatement) {
            return "loop variable";
        }
        if (id.isFormalParameter()) {
            return "parameter";
        }
        return "variable";
    }

    private boolean isIgnorablePrefixIncrement(JavaNode assignment) {
        if (assignment instanceof ASTPreIncrementExpression || assignment instanceof ASTPreDecrementExpression) {
            return (Boolean)this.getProperty(CHECK_PREFIX_INCREMENT) == false && !(assignment.getParent() instanceof ASTStatementExpression);
        }
        return false;
    }

    private static String makeMessage(AssignmentEntry assignment, String reason, boolean isField) {
        String varName = assignment.var.getName();
        StringBuilder result = new StringBuilder(64);
        if (assignment.rhs instanceof ASTVariableInitializer) {
            result.append(isField ? "the field initializer for" : "the initializer for variable");
        } else if (assignment.rhs instanceof ASTVariableDeclaratorId) {
            if (reason != null) {
                result.append("the initial value of ");
            }
            result.append(UnusedAssignmentRule.getKind(assignment.var));
        } else {
            if (assignment.rhs instanceof ASTPreIncrementExpression || assignment.rhs instanceof ASTPreDecrementExpression || assignment.rhs instanceof ASTPostfixExpression) {
                result.append("the updated value of ");
            } else {
                result.append("the value assigned to ");
            }
            result.append(isField ? "field" : "variable");
        }
        result.append(" ''").append(varName).append("''");
        result.append(" is never used");
        if (reason != null) {
            result.append(" (").append(reason).append(")");
        }
        result.setCharAt(0, Character.toUpperCase(result.charAt(0)));
        return result.toString();
    }

    private static String joinLines(String prefix, Set<AssignmentEntry> killers) {
        StringBuilder sb = new StringBuilder(prefix);
        ArrayList<AssignmentEntry> sorted = new ArrayList<AssignmentEntry>(killers);
        Collections.sort(sorted, new Comparator<AssignmentEntry>(){

            @Override
            public int compare(AssignmentEntry o1, AssignmentEntry o2) {
                int lineRes = Integer.compare(o1.rhs.getBeginLine(), o2.rhs.getBeginLine());
                return lineRes != 0 ? lineRes : Integer.compare(o1.rhs.getBeginColumn(), o2.rhs.getBeginColumn());
            }
        });
        sb.append(sorted.get((int)0).rhs.getBeginLine());
        for (int i = 1; i < sorted.size() - 1; ++i) {
            sb.append(", ").append(sorted.get((int)i).rhs.getBeginLine());
        }
        sb.append(" and ").append(sorted.get((int)(sorted.size() - 1)).rhs.getBeginLine());
        return sb.toString();
    }

    static class AssignmentEntry {
        final ASTVariableDeclaratorId var;
        final JavaNode rhs;

        AssignmentEntry(ASTVariableDeclaratorId var, JavaNode rhs) {
            this.var = var;
            this.rhs = rhs;
        }

        public String toString() {
            return this.var.getName() + " := " + this.rhs;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AssignmentEntry that = (AssignmentEntry)o;
            return Objects.equals(this.rhs, that.rhs);
        }

        public int hashCode() {
            return this.rhs.hashCode();
        }
    }

    static class TargetStack {
        final Deque<SpanInfo> unnamedTargets = new ArrayDeque<SpanInfo>();
        final Map<String, SpanInfo> namedTargets = new HashMap<String, SpanInfo>();

        TargetStack() {
        }

        void push(SpanInfo state) {
            this.unnamedTargets.push(state);
        }

        SpanInfo pop() {
            return this.unnamedTargets.pop();
        }

        SpanInfo peek() {
            return this.unnamedTargets.getFirst();
        }

        SpanInfo doBreak(SpanInfo data, String label) {
            SpanInfo target = label == null ? this.unnamedTargets.getFirst() : this.namedTargets.get(label);
            if (target != null) {
                target.absorb(data);
            }
            return data.abruptCompletion(target);
        }
    }

    private static class SpanInfo {
        final SpanInfo parent;
        SpanInfo myFinally = null;
        List<SpanInfo> myCatches;
        final GlobalAlgoState global;
        final Map<ASTVariableDeclaratorId, VarLocalInfo> symtable;

        private SpanInfo(GlobalAlgoState global) {
            this(null, global, new HashMap<ASTVariableDeclaratorId, VarLocalInfo>());
        }

        private SpanInfo(SpanInfo parent, GlobalAlgoState global, Map<ASTVariableDeclaratorId, VarLocalInfo> symtable) {
            this.parent = parent;
            this.global = global;
            this.symtable = symtable;
            this.myCatches = Collections.emptyList();
        }

        boolean hasVar(ASTVariableDeclaratorId var) {
            return this.symtable.containsKey(var);
        }

        void assign(ASTVariableDeclaratorId var, JavaNode rhs) {
            AssignmentEntry entry = new AssignmentEntry(var, rhs);
            VarLocalInfo previous = this.symtable.put(var, new VarLocalInfo(Collections.singleton(entry)));
            if (previous != null) {
                for (AssignmentEntry killed : previous.reachingDefs) {
                    if (killed.rhs instanceof ASTVariableDeclaratorId && killed.rhs.getParent() instanceof ASTVariableDeclarator && killed.rhs != rhs) continue;
                    Set<AssignmentEntry> killers = this.global.killRecord.get(killed);
                    if (killers == null) {
                        killers = new HashSet<AssignmentEntry>(1);
                        this.global.killRecord.put(killed, killers);
                    }
                    killers.add(entry);
                }
            }
            this.global.allAssignments.add(entry);
        }

        void use(ASTVariableDeclaratorId var) {
            VarLocalInfo info = this.symtable.get(var);
            if (info != null) {
                this.global.usedAssignments.addAll(info.reachingDefs);
            }
        }

        void deleteVar(ASTVariableDeclaratorId var) {
            this.symtable.remove(var);
        }

        public void recordThisLeak(boolean thisIsLeaking, ClassScope enclosingClassScope) {
            if (thisIsLeaking && enclosingClassScope != null) {
                ReachingDefsVisitor.useAllSelfFields(null, this, enclosingClassScope);
            }
        }

        SpanInfo fork() {
            return this.doFork(this, this.copyTable());
        }

        SpanInfo forkEmpty() {
            return this.doFork(this, new HashMap<ASTVariableDeclaratorId, VarLocalInfo>());
        }

        SpanInfo forkEmptyNonLocal() {
            return this.doFork(null, new HashMap<ASTVariableDeclaratorId, VarLocalInfo>());
        }

        SpanInfo forkCapturingNonLocal() {
            return this.doFork(null, this.copyTable());
        }

        private Map<ASTVariableDeclaratorId, VarLocalInfo> copyTable() {
            HashMap<ASTVariableDeclaratorId, VarLocalInfo> copy = new HashMap<ASTVariableDeclaratorId, VarLocalInfo>(this.symtable.size());
            for (ASTVariableDeclaratorId var : this.symtable.keySet()) {
                copy.put(var, this.symtable.get(var).copy());
            }
            return copy;
        }

        private SpanInfo doFork(SpanInfo parent, Map<ASTVariableDeclaratorId, VarLocalInfo> reaching) {
            return new SpanInfo(parent, this.global, reaching);
        }

        SpanInfo abruptCompletion(SpanInfo target) {
            SpanInfo parent = this;
            while (parent != target && parent != null) {
                if (parent.myFinally != null) {
                    parent.myFinally.absorb(this);
                    return this;
                }
                parent = parent.parent;
            }
            this.symtable.clear();
            return this;
        }

        SpanInfo abruptCompletionByThrow(boolean byMethodCall) {
            SpanInfo parent = this;
            while (parent != null) {
                if (!parent.myCatches.isEmpty()) {
                    for (SpanInfo c : parent.myCatches) {
                        c.absorb(this);
                    }
                }
                if (parent.myFinally != null) {
                    parent.myFinally.absorb(this);
                    return this;
                }
                parent = parent.parent;
            }
            if (!byMethodCall) {
                this.symtable.clear();
            }
            return this;
        }

        SpanInfo withCatchBlocks(List<SpanInfo> catchStmts) {
            assert (this.myCatches.isEmpty() || catchStmts.isEmpty()) : "Cannot set catch blocks twice";
            this.myCatches = Collections.unmodifiableList(catchStmts);
            return this;
        }

        SpanInfo absorb(SpanInfo other) {
            if (other == this || other == null || other.symtable.isEmpty()) {
                return this;
            }
            HashSet<ASTVariableDeclaratorId> keysUnion = new HashSet<ASTVariableDeclaratorId>(this.symtable.keySet());
            keysUnion.addAll(other.symtable.keySet());
            for (ASTVariableDeclaratorId var : keysUnion) {
                VarLocalInfo otherInfo;
                VarLocalInfo thisInfo = this.symtable.get(var);
                if (thisInfo == (otherInfo = other.symtable.get(var))) continue;
                if (otherInfo != null && thisInfo != null) {
                    this.symtable.put(var, thisInfo.absorb(otherInfo));
                    continue;
                }
                if (otherInfo == null) continue;
                this.symtable.put(var, otherInfo.copy());
            }
            return this;
        }

        public String toString() {
            return this.symtable.toString();
        }
    }

    static class VarLocalInfo {
        Set<AssignmentEntry> reachingDefs;

        VarLocalInfo(Set<AssignmentEntry> reachingDefs) {
            this.reachingDefs = reachingDefs;
        }

        VarLocalInfo absorb(VarLocalInfo other) {
            if (other == this) {
                return this;
            }
            HashSet<AssignmentEntry> merged = new HashSet<AssignmentEntry>(this.reachingDefs.size() + other.reachingDefs.size());
            merged.addAll(this.reachingDefs);
            merged.addAll(other.reachingDefs);
            return new VarLocalInfo(merged);
        }

        public String toString() {
            return "VarLocalInfo{reachingDefs=" + this.reachingDefs + '}';
        }

        public VarLocalInfo copy() {
            return new VarLocalInfo(this.reachingDefs);
        }
    }

    private static class GlobalAlgoState {
        final Set<AssignmentEntry> allAssignments;
        final Set<AssignmentEntry> usedAssignments;
        final Map<AssignmentEntry, Set<AssignmentEntry>> killRecord;
        final TargetStack breakTargets = new TargetStack();
        final TargetStack continueTargets = new TargetStack();

        private GlobalAlgoState(Set<AssignmentEntry> allAssignments, Set<AssignmentEntry> usedAssignments, Map<AssignmentEntry, Set<AssignmentEntry>> killRecord) {
            this.allAssignments = allAssignments;
            this.usedAssignments = usedAssignments;
            this.killRecord = killRecord;
        }

        private GlobalAlgoState() {
            this(new HashSet<AssignmentEntry>(), new HashSet<AssignmentEntry>(), new HashMap<AssignmentEntry, Set<AssignmentEntry>>());
        }
    }

    private static class ReachingDefsVisitor
    extends JavaParserVisitorAdapter {
        static final ReachingDefsVisitor ONLY_LOCALS = new ReachingDefsVisitor(null);
        private final ClassScope enclosingClassScope;

        private ReachingDefsVisitor(ClassScope scope) {
            this.enclosingClassScope = scope;
        }

        @Override
        public Object visit(JavaNode node, Object data) {
            for (JavaNode javaNode : node.children()) {
                data = javaNode.jjtAccept(this, data);
            }
            return data;
        }

        @Override
        public Object visit(ASTBlock node, Object data) {
            SpanInfo state = (SpanInfo)data;
            HashSet<ASTVariableDeclaratorId> localsToKill = new HashSet<ASTVariableDeclaratorId>();
            for (JavaNode child : node.children()) {
                state = this.acceptOpt(child, state);
                if (!(child instanceof ASTBlockStatement) || !(child.getChild(0) instanceof ASTLocalVariableDeclaration)) continue;
                ASTLocalVariableDeclaration local = (ASTLocalVariableDeclaration)child.getChild(0);
                for (ASTVariableDeclaratorId id : local) {
                    localsToKill.add(id);
                }
            }
            for (ASTVariableDeclaratorId var : localsToKill) {
                state.deleteVar(var);
            }
            return state;
        }

        @Override
        public Object visit(ASTSwitchStatement node, Object data) {
            return this.processSwitch(node, (SpanInfo)data, node.getTestedExpression());
        }

        @Override
        public Object visit(ASTSwitchExpression node, Object data) {
            return this.processSwitch(node, (SpanInfo)data, (JavaNode)node.getChild(0));
        }

        private SpanInfo processSwitch(JavaNode switchLike, SpanInfo data, JavaNode testedExpr) {
            GlobalAlgoState global = data.global;
            SpanInfo before = this.acceptOpt(testedExpr, data);
            global.breakTargets.push(before.fork());
            SpanInfo current = before;
            for (int i = 1; i < switchLike.getNumChildren(); ++i) {
                JavaNode child = switchLike.getChild(i);
                if (child instanceof ASTSwitchLabel) {
                    current = before.fork().absorb(current);
                    continue;
                }
                if (child instanceof ASTSwitchLabeledRule) {
                    current = this.acceptOpt(child.getChild(1), before.fork());
                    current = global.breakTargets.doBreak(current, null);
                    continue;
                }
                current = this.acceptOpt(child, current);
            }
            before = global.breakTargets.pop();
            return before.absorb(current);
        }

        @Override
        public Object visit(ASTIfStatement node, Object data) {
            SpanInfo before = (SpanInfo)data;
            return this.makeConditional(before, node.getCondition(), node.getThenBranch(), node.getElseBranch());
        }

        @Override
        public Object visit(ASTConditionalExpression node, Object data) {
            SpanInfo before = (SpanInfo)data;
            return this.makeConditional(before, node.getCondition(), (JavaNode)node.getChild(1), (JavaNode)node.getChild(2));
        }

        SpanInfo makeConditional(SpanInfo before, JavaNode condition, JavaNode thenBranch, JavaNode elseBranch) {
            SpanInfo thenState = before.fork();
            SpanInfo elseState = elseBranch != null ? before.fork() : before;
            this.linkConditional(before, condition, thenState, elseState, true);
            thenState = this.acceptOpt(thenBranch, thenState);
            elseState = this.acceptOpt(elseBranch, elseState);
            return elseState.absorb(thenState);
        }

        private SpanInfo linkConditional(SpanInfo before, JavaNode condition, SpanInfo thenState, SpanInfo elseState, boolean isTopLevel) {
            if (condition == null) {
                return before;
            }
            if ((condition = ConfusingTernaryRule.unwrapParentheses(condition)) instanceof ASTConditionalOrExpression) {
                return this.visitShortcutOrExpr(condition, before, thenState, elseState);
            }
            if (condition instanceof ASTConditionalAndExpression) {
                return this.visitShortcutOrExpr(condition, before, elseState, thenState);
            }
            if (condition instanceof ASTExpression && condition.getNumChildren() == 1) {
                return this.linkConditional(before, condition.getChild(0), thenState, elseState, isTopLevel);
            }
            SpanInfo state = this.acceptOpt(condition, before);
            if (isTopLevel) {
                thenState.absorb(state);
                elseState.absorb(state);
            }
            return state;
        }

        SpanInfo visitShortcutOrExpr(JavaNode orExpr, SpanInfo before, SpanInfo thenState, SpanInfo elseState) {
            Iterator<? extends JavaNode> iterator = orExpr.children().iterator();
            SpanInfo cur = before;
            do {
                JavaNode cond = iterator.next();
                cur = this.linkConditional(cur, cond, thenState, elseState, false);
                thenState.absorb(cur);
            } while (iterator.hasNext());
            elseState.absorb(cur);
            return cur;
        }

        @Override
        public Object visit(ASTTryStatement node, Object data) {
            List<ASTCatchStatement> catchClauses;
            SpanInfo before = (SpanInfo)data;
            ASTFinallyStatement finallyClause = node.getFinallyClause();
            if (finallyClause != null) {
                before.myFinally = before.forkEmpty();
            }
            ArrayList<SpanInfo> catchSpans = (catchClauses = node.getCatchClauses()).isEmpty() ? Collections.emptyList() : new ArrayList<SpanInfo>();
            for (int i = 0; i < catchClauses.size(); ++i) {
                catchSpans.add(before.forkEmpty());
            }
            ASTResourceSpecification resources = (ASTResourceSpecification)node.getFirstChildOfType(ASTResourceSpecification.class);
            SpanInfo bodyState = before.fork();
            bodyState = bodyState.withCatchBlocks(catchSpans);
            bodyState = this.acceptOpt(resources, bodyState);
            bodyState = this.acceptOpt(node.getBody(), bodyState);
            bodyState = bodyState.withCatchBlocks(Collections.emptyList());
            SpanInfo exceptionalState = null;
            for (int i = 0; i < catchClauses.size(); ++i) {
                ASTCatchStatement catchClause = catchClauses.get(i);
                SpanInfo current = this.acceptOpt(catchClause, (SpanInfo)catchSpans.get(i));
                exceptionalState = current.absorb(exceptionalState);
            }
            SpanInfo finalState = bodyState.absorb(exceptionalState);
            if (finallyClause != null) {
                SpanInfo abruptFinally = before.myFinally.absorb(before);
                this.acceptOpt(finallyClause, abruptFinally);
                before.myFinally = null;
                abruptFinally.abruptCompletionByThrow(false);
                finalState = this.acceptOpt(finallyClause, finalState);
            }
            return finalState;
        }

        @Override
        public Object visit(ASTCatchStatement node, Object data) {
            SpanInfo result = (SpanInfo)this.visit((JavaNode)node, data);
            result.deleteVar(node.getExceptionId());
            return result;
        }

        @Override
        public Object visit(ASTLambdaExpression node, Object data) {
            SpanInfo before = (SpanInfo)data;
            JavaNode lambdaBody = (JavaNode)node.getChild(node.getNumChildren() - 1);
            this.acceptOpt(lambdaBody, before.forkCapturingNonLocal());
            return before;
        }

        @Override
        public Object visit(ASTWhileStatement node, Object data) {
            return this.handleLoop(node, (SpanInfo)data, null, node.getCondition(), null, node.getBody(), true, null);
        }

        @Override
        public Object visit(ASTDoStatement node, Object data) {
            return this.handleLoop(node, (SpanInfo)data, null, node.getCondition(), null, node.getBody(), false, null);
        }

        @Override
        public Object visit(ASTForStatement node, Object data) {
            ASTStatement body = node.getBody();
            if (node.isForeach()) {
                JavaNode init = (JavaNode)node.getChild(1);
                ASTVariableDeclaratorId foreachVar = ((ASTLocalVariableDeclaration)node.getChild(0)).iterator().next();
                return this.handleLoop(node, (SpanInfo)data, init, null, null, body, true, foreachVar);
            }
            ASTForInit init = (ASTForInit)node.getFirstChildOfType(ASTForInit.class);
            ASTExpression cond = node.getCondition();
            ASTForUpdate update = (ASTForUpdate)node.getFirstChildOfType(ASTForUpdate.class);
            return this.handleLoop(node, (SpanInfo)data, init, cond, update, body, true, null);
        }

        private SpanInfo handleLoop(JavaNode loop, SpanInfo before, JavaNode init, JavaNode cond, JavaNode update, JavaNode body, boolean checkFirstIter, ASTVariableDeclaratorId foreachVar) {
            GlobalAlgoState globalState = before.global;
            SpanInfo breakTarget = before.forkEmpty();
            SpanInfo continueTarget = before.forkEmpty();
            this.pushTargets(loop, breakTarget, continueTarget);
            before = this.acceptOpt(init, before);
            if (checkFirstIter && cond != null) {
                SpanInfo ifcondTrue = before.forkEmpty();
                this.linkConditional(before, cond, ifcondTrue, breakTarget, true);
                before = ifcondTrue;
            }
            if (foreachVar != null) {
                before.assign(foreachVar, foreachVar);
            }
            SpanInfo iter = this.acceptOpt(body, before.fork());
            if (foreachVar != null && iter.hasVar(foreachVar)) {
                iter.assign(foreachVar, foreachVar);
            } else {
                iter = this.acceptOpt(update, iter);
            }
            this.linkConditional(iter, cond, iter, breakTarget, true);
            iter = this.acceptOpt(body, iter);
            breakTarget = globalState.breakTargets.peek();
            continueTarget = globalState.continueTargets.peek();
            if (!continueTarget.symtable.isEmpty()) {
                this.linkConditional(continueTarget, cond, continueTarget, breakTarget, true);
                continueTarget = this.acceptOpt(body, continueTarget);
                continueTarget = this.acceptOpt(update, continueTarget);
            }
            SpanInfo result = this.popTargets(loop, breakTarget, continueTarget);
            result = result.absorb(iter);
            if (checkFirstIter) {
                result = result.absorb(before);
            }
            if (foreachVar != null) {
                result.deleteVar(foreachVar);
            }
            return result;
        }

        private void pushTargets(JavaNode loop, SpanInfo breakTarget, SpanInfo continueTarget) {
            GlobalAlgoState globalState = breakTarget.global;
            globalState.breakTargets.unnamedTargets.push(breakTarget);
            globalState.continueTargets.unnamedTargets.push(continueTarget);
            Node parent = loop.getNthParent(2);
            while (parent instanceof ASTLabeledStatement) {
                String label = parent.getImage();
                globalState.breakTargets.namedTargets.put(label, breakTarget);
                globalState.continueTargets.namedTargets.put(label, continueTarget);
                parent = parent.getNthParent(2);
            }
        }

        private SpanInfo popTargets(JavaNode loop, SpanInfo breakTarget, SpanInfo continueTarget) {
            GlobalAlgoState globalState = breakTarget.global;
            globalState.breakTargets.unnamedTargets.pop();
            globalState.continueTargets.unnamedTargets.pop();
            SpanInfo total = breakTarget.absorb(continueTarget);
            Node parent = loop.getNthParent(2);
            while (parent instanceof ASTLabeledStatement) {
                String label = parent.getImage();
                total = total.absorb(globalState.breakTargets.namedTargets.remove(label));
                total = total.absorb(globalState.continueTargets.namedTargets.remove(label));
                parent = parent.getNthParent(2);
            }
            return total;
        }

        private SpanInfo acceptOpt(JavaNode node, SpanInfo before) {
            return node == null ? before : (SpanInfo)node.jjtAccept(this, before);
        }

        @Override
        public Object visit(ASTContinueStatement node, Object data) {
            SpanInfo state = (SpanInfo)data;
            return state.global.continueTargets.doBreak(state, node.getImage());
        }

        @Override
        public Object visit(ASTBreakStatement node, Object data) {
            SpanInfo state = (SpanInfo)data;
            return state.global.breakTargets.doBreak(state, node.getImage());
        }

        @Override
        public Object visit(ASTYieldStatement node, Object data) {
            super.visit(node, data);
            SpanInfo state = (SpanInfo)data;
            return state.global.breakTargets.doBreak(state, null);
        }

        @Override
        public Object visit(ASTThrowStatement node, Object data) {
            super.visit(node, data);
            return ((SpanInfo)data).abruptCompletionByThrow(false);
        }

        @Override
        public Object visit(ASTReturnStatement node, Object data) {
            super.visit(node, data);
            return ((SpanInfo)data).abruptCompletion(null);
        }

        @Override
        public Object visit(ASTFormalParameter node, Object data) {
            if (!node.isExplicitReceiverParameter()) {
                ASTVariableDeclaratorId id = node.getVariableDeclaratorId();
                ((SpanInfo)data).assign(id, id);
            }
            return data;
        }

        @Override
        public Object visit(ASTVariableDeclarator node, Object data) {
            ASTVariableDeclaratorId var = node.getVariableId();
            ASTVariableInitializer rhs = node.getInitializer();
            if (rhs != null) {
                rhs.jjtAccept(this, data);
                ((SpanInfo)data).assign(var, rhs);
            } else {
                ((SpanInfo)data).assign(var, node.getVariableId());
            }
            return data;
        }

        @Override
        public Object visit(ASTExpression node, Object data) {
            return this.checkAssignment(node, data);
        }

        @Override
        public Object visit(ASTStatementExpression node, Object data) {
            return this.checkAssignment(node, data);
        }

        public Object checkAssignment(JavaNode node, Object data) {
            SpanInfo result = (SpanInfo)data;
            if (node.getNumChildren() == 3) {
                assert (node.getChild(1) instanceof ASTAssignmentOperator);
                JavaNode rhs = node.getChild(2);
                result = this.acceptOpt(rhs, result);
                ASTVariableDeclaratorId lhsVar = this.getVarFromExpression(node.getChild(0), true, result);
                if (lhsVar != null) {
                    if (node.getChild(1).getImage().length() >= 2) {
                        result.use(lhsVar);
                    }
                    result.assign(lhsVar, rhs);
                } else {
                    result = this.acceptOpt(node.getChild(0), result);
                }
                return result;
            }
            return this.visit(node, data);
        }

        @Override
        public Object visit(ASTPreDecrementExpression node, Object data) {
            return this.checkIncOrDecrement(node, (SpanInfo)data);
        }

        @Override
        public Object visit(ASTPreIncrementExpression node, Object data) {
            return this.checkIncOrDecrement(node, (SpanInfo)data);
        }

        @Override
        public Object visit(ASTPostfixExpression node, Object data) {
            return this.checkIncOrDecrement(node, (SpanInfo)data);
        }

        private SpanInfo checkIncOrDecrement(JavaNode unary, SpanInfo data) {
            ASTVariableDeclaratorId var = this.getVarFromExpression(unary.getChild(0), true, data);
            if (var != null) {
                data.use(var);
                data.assign(var, unary);
            }
            return data;
        }

        @Override
        public Object visit(ASTPrimaryExpression node, Object data) {
            SpanInfo state = (SpanInfo)this.visit((JavaNode)node, data);
            ASTVariableDeclaratorId var = this.getVarFromExpression(node, false, state);
            if (var != null) {
                state.use(var);
            }
            this.maybeThrowUncheckedExceptions(node, state);
            return state;
        }

        private void maybeThrowUncheckedExceptions(ASTPrimaryExpression e, SpanInfo state) {
            for (JavaNode child : e.children()) {
                if (!(child instanceof ASTPrimarySuffix && ((ASTPrimarySuffix)child).isArguments() || child instanceof ASTPrimarySuffix && child.getNumChildren() > 0 && child.getChild(0) instanceof ASTAllocationExpression) && (!(child instanceof ASTPrimaryPrefix) || child.getNumChildren() <= 0 || !(child.getChild(0) instanceof ASTAllocationExpression))) continue;
                state.abruptCompletionByThrow(true);
            }
        }

        private ASTVariableDeclaratorId getVarFromExpression(JavaNode primary, boolean inLhs, SpanInfo state) {
            if (primary instanceof ASTPrimaryExpression) {
                ASTPrimaryPrefix prefix = (ASTPrimaryPrefix)primary.getChild(0);
                if (prefix.usesThisModifier() && this.enclosingClassScope != null) {
                    int numChildren = primary.getNumChildren();
                    if (numChildren < 2 || numChildren > 2 && inLhs) {
                        if (numChildren == 3 || numChildren == 1) {
                            state.recordThisLeak(true, this.enclosingClassScope);
                        }
                        return null;
                    }
                    ASTPrimarySuffix suffix = (ASTPrimarySuffix)primary.getChild(1);
                    if (suffix.getImage() == null) {
                        return null;
                    }
                    if (primary.getNumChildren() > 2 && ((ASTPrimarySuffix)primary.getChild(2)).isArguments()) {
                        state.recordThisLeak(true, this.enclosingClassScope);
                        return null;
                    }
                    return this.findVar(primary.getScope(), true, suffix.getImage());
                }
                if (prefix.getNumChildren() > 0 && prefix.getChild(0) instanceof ASTName) {
                    String prefixImage = ((JavaNode)prefix.getChild(0)).getImage();
                    String varname = ReachingDefsVisitor.identOf(inLhs, prefixImage);
                    if (primary.getNumChildren() > 1) {
                        if (primary.getNumChildren() > 2 && inLhs) {
                            return null;
                        }
                        ASTPrimarySuffix suffix = (ASTPrimarySuffix)primary.getChild(1);
                        if (suffix.isArguments()) {
                            varname = ReachingDefsVisitor.methodLhsName(prefixImage);
                        } else if (suffix.isArrayDereference() && inLhs) {
                            return null;
                        }
                    }
                    return this.findVar(prefix.getScope(), false, varname);
                }
            }
            return null;
        }

        private static String identOf(boolean inLhs, String str) {
            int i = str.indexOf(46);
            if (i < 0) {
                return str;
            }
            if (inLhs) {
                return null;
            }
            return str.substring(0, i);
        }

        private static String methodLhsName(String name) {
            int i = name.indexOf(46);
            return i < 0 ? null : name.substring(0, i);
        }

        private ASTVariableDeclaratorId findVar(Scope scope, boolean isField, String name) {
            if (name == null) {
                return null;
            }
            if (isField) {
                return this.getFromSingleScope((Scope)this.enclosingClassScope, name);
            }
            while (scope != null) {
                ASTVariableDeclaratorId result = this.getFromSingleScope(scope, name);
                if (result != null) {
                    if (scope instanceof ClassScope && scope != this.enclosingClassScope) {
                        return null;
                    }
                    return result;
                }
                scope = scope.getParent();
            }
            return null;
        }

        private ASTVariableDeclaratorId getFromSingleScope(Scope scope, String name) {
            if (scope != null) {
                for (VariableNameDeclaration decl : scope.getDeclarations(VariableNameDeclaration.class).keySet()) {
                    if (!decl.getImage().equals(name)) continue;
                    return (ASTVariableDeclaratorId)decl.getNode();
                }
            }
            return null;
        }

        @Override
        public Object visit(ASTClassOrInterfaceBody node, Object data) {
            this.visitTypeBody(node, (SpanInfo)data);
            return data;
        }

        @Override
        public Object visit(ASTEnumBody node, Object data) {
            this.visitTypeBody(node, (SpanInfo)data);
            return data;
        }

        private void visitTypeBody(JavaNode typeBody, SpanInfo data) {
            List declarations = typeBody.findChildrenOfType(ASTAnyTypeBodyDeclaration.class);
            ReachingDefsVisitor.processInitializers(declarations, data, (ClassScope)typeBody.getScope());
            for (ASTAnyTypeBodyDeclaration decl : declarations) {
                JavaNode d = decl.getDeclarationNode();
                if (d instanceof ASTMethodDeclaration) {
                    ASTMethodDeclaration method = (ASTMethodDeclaration)d;
                    if (method.isAbstract() || method.isNative()) continue;
                    ONLY_LOCALS.acceptOpt(d, data.forkCapturingNonLocal());
                    continue;
                }
                if (!(d instanceof ASTAnyTypeDeclaration)) continue;
                JavaNode body = d.getChild(d.getNumChildren() - 1);
                this.visitTypeBody(body, data.forkEmptyNonLocal());
            }
        }

        private static void processInitializers(List<ASTAnyTypeBodyDeclaration> declarations, SpanInfo beforeLocal, ClassScope scope) {
            ReachingDefsVisitor visitor = new ReachingDefsVisitor(scope);
            SpanInfo ctorHeader = beforeLocal.forkCapturingNonLocal();
            SpanInfo staticInit = beforeLocal.forkEmptyNonLocal();
            ArrayList<ASTConstructorDeclaration> ctors = new ArrayList<ASTConstructorDeclaration>();
            for (ASTAnyTypeBodyDeclaration declaration : declarations) {
                boolean isStatic;
                JavaNode node = declaration.getDeclarationNode();
                if (node instanceof ASTFieldDeclaration) {
                    isStatic = ((ASTFieldDeclaration)node).isStatic();
                } else if (node instanceof ASTInitializer) {
                    isStatic = ((ASTInitializer)node).isStatic();
                } else {
                    if (!(node instanceof ASTConstructorDeclaration)) continue;
                    ctors.add((ASTConstructorDeclaration)node);
                    continue;
                }
                if (isStatic) {
                    staticInit = visitor.acceptOpt(node, staticInit);
                    continue;
                }
                ctorHeader = visitor.acceptOpt(node, ctorHeader);
            }
            SpanInfo ctorEndState = ctors.isEmpty() ? ctorHeader : null;
            for (ASTConstructorDeclaration ctor : ctors) {
                SpanInfo state = visitor.acceptOpt(ctor, ctorHeader.forkCapturingNonLocal());
                ctorEndState = ctorEndState == null ? state : ctorEndState.absorb(state);
            }
            ReachingDefsVisitor.useAllSelfFields(staticInit, ctorEndState, visitor.enclosingClassScope);
        }

        static void useAllSelfFields(SpanInfo staticState, SpanInfo instanceState, ClassScope classScope) {
            for (VariableNameDeclaration field : classScope.getVariableDeclarations().keySet()) {
                ASTVariableDeclaratorId var = field.getDeclaratorId();
                if (field.getAccessNodeParent().isStatic()) {
                    if (staticState == null) continue;
                    staticState.use(var);
                    continue;
                }
                instanceState.use(var);
            }
        }
    }
}

