/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentOperator;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFinallyStatement;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTNullLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTResourceSpecification;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTStatementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import org.jaxen.JaxenException;

public class CloseResourceRule
extends AbstractJavaRule {
    private static final String WRAPPING_TRY_WITH_RES_VAR_MESSAGE = "it is recommended to wrap resource in try-with-resource declaration directly";
    private static final String REASSIGN_BEFORE_CLOSED_MESSAGE = "'' is reassigned, but the original instance is not closed";
    private static final String CLOSE_IN_FINALLY_BLOCK_MESSAGE = "'' is not closed within a finally block, thus might not be closed at all in case of exceptions";
    private static final PropertyDescriptor<List<String>> CLOSE_TARGETS_DESCRIPTOR = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"closeTargets").desc("Methods which may close this resource")).emptyDefaultValue().delim(',').build();
    private static final PropertyDescriptor<List<String>> TYPES_DESCRIPTOR = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"types").desc("Affected types")).defaultValues((Object)"java.lang.AutoCloseable", (Object[])new String[]{"java.sql.Connection", "java.sql.Statement", "java.sql.ResultSet"}).delim(',').build();
    private static final PropertyDescriptor<Boolean> USE_CLOSE_AS_DEFAULT_TARGET = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"closeAsDefaultTarget").desc("Consider 'close' as a target by default")).defaultValue((Object)true)).build();
    private static final PropertyDescriptor<List<String>> ALLOWED_RESOURCE_TYPES = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"allowedResourceTypes").desc("Exact class names that do not need to be closed")).defaultValues((Object)"java.io.ByteArrayOutputStream", (Object[])new String[]{"java.io.ByteArrayInputStream", "java.io.StringWriter", "java.io.CharArrayWriter", "java.util.stream.Stream", "java.util.stream.IntStream", "java.util.stream.LongStream", "java.util.stream.DoubleStream"}).build();
    private static final PropertyDescriptor<Boolean> DETECT_CLOSE_NOT_IN_FINALLY = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"closeNotInFinally").desc("Detect if 'close' (or other closeTargets) is called outside of a finally-block")).defaultValue((Object)false)).build();
    private final Set<String> types = new HashSet<String>();
    private final Set<String> simpleTypes = new HashSet<String>();
    private final Set<String> closeTargets = new HashSet<String>();
    private final Set<String> reportedVarNames = new HashSet<String>();

    public CloseResourceRule() {
        this.definePropertyDescriptor(CLOSE_TARGETS_DESCRIPTOR);
        this.definePropertyDescriptor(TYPES_DESCRIPTOR);
        this.definePropertyDescriptor(USE_CLOSE_AS_DEFAULT_TARGET);
        this.definePropertyDescriptor(ALLOWED_RESOURCE_TYPES);
        this.definePropertyDescriptor(DETECT_CLOSE_NOT_IN_FINALLY);
    }

    public void start(RuleContext ctx) {
        this.closeTargets.clear();
        this.simpleTypes.clear();
        this.types.clear();
        if (this.getProperty(CLOSE_TARGETS_DESCRIPTOR) != null) {
            this.closeTargets.addAll((Collection)this.getProperty(CLOSE_TARGETS_DESCRIPTOR));
        }
        if (((Boolean)this.getProperty(USE_CLOSE_AS_DEFAULT_TARGET)).booleanValue()) {
            this.closeTargets.add("close");
        }
        if (this.getProperty(TYPES_DESCRIPTOR) != null) {
            this.types.addAll((Collection)this.getProperty(TYPES_DESCRIPTOR));
            for (String type : (List)this.getProperty(TYPES_DESCRIPTOR)) {
                this.simpleTypes.add(CloseResourceRule.toSimpleType(type));
            }
        }
    }

    private static String toSimpleType(String fullyQualifiedClassName) {
        int lastIndexOf = fullyQualifiedClassName.lastIndexOf(46);
        if (lastIndexOf > -1) {
            return fullyQualifiedClassName.substring(lastIndexOf + 1);
        }
        return fullyQualifiedClassName;
    }

    @Override
    public Object visit(ASTConstructorDeclaration node, Object data) {
        this.checkForResources(node, data);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        this.checkForResources(node, data);
        return super.visit(node, data);
    }

    private void checkForResources(ASTMethodOrConstructorDeclaration methodOrConstructor, Object data) {
        this.reportedVarNames.clear();
        Map<ASTVariableDeclarator, TypeNode> resVars = this.getResourceVariables(methodOrConstructor);
        for (Map.Entry<ASTVariableDeclarator, TypeNode> resVarEntry : resVars.entrySet()) {
            ASTVariableDeclarator resVar = resVarEntry.getKey();
            TypeNode resVarType = resVarEntry.getValue();
            if (this.isWrappingResourceSpecifiedInTry(resVar)) {
                this.reportedVarNames.add(resVar.getVariableId().getName());
                this.addViolationWithMessage(data, (Node)resVar, WRAPPING_TRY_WITH_RES_VAR_MESSAGE);
                continue;
            }
            if (this.shouldVarOfTypeBeClosedInMethod(resVar, resVarType, methodOrConstructor)) {
                this.reportedVarNames.add(resVar.getVariableId().getName());
                this.addCloseResourceViolation(resVar.getVariableId(), resVarType, data);
                continue;
            }
            ASTStatementExpression reassigningStatement = this.getFirstReassigningStatementBeforeBeingClosed(resVar, methodOrConstructor);
            if (reassigningStatement == null) continue;
            this.reportedVarNames.add(resVar.getVariableId().getName());
            this.addViolationWithMessage(data, (Node)reassigningStatement, this.reassignBeforeClosedMessageForVar(resVar.getName()));
        }
    }

    private Map<ASTVariableDeclarator, TypeNode> getResourceVariables(ASTMethodOrConstructorDeclaration method) {
        List vars = method.findDescendantsOfType(ASTVariableDeclarator.class);
        HashMap<ASTVariableDeclarator, TypeNode> resVars = new HashMap<ASTVariableDeclarator, TypeNode>();
        for (ASTVariableDeclarator var : vars) {
            TypeNode varType = this.getTypeOfVariable(var);
            if (varType == null || !this.isResourceTypeOrSubtype(varType)) continue;
            resVars.put(var, this.wrappedResourceTypeOrReturn(var, varType));
        }
        return resVars;
    }

    private TypeNode getTypeOfVariable(ASTVariableDeclarator var) {
        TypeNode runtimeType = this.getRuntimeTypeOfVariable(var);
        return runtimeType != null ? runtimeType : this.getDeclaredTypeOfVariable(var);
    }

    private TypeNode getDeclaredTypeOfVariable(ASTVariableDeclarator var) {
        ASTLocalVariableDeclaration localVar = (ASTLocalVariableDeclaration)var.getParent();
        return localVar.getTypeNode();
    }

    private TypeNode getRuntimeTypeOfVariable(ASTVariableDeclarator var) {
        ASTExpression initExpr = this.initializerExpressionOf(var);
        return this.isRuntimeType(initExpr) ? initExpr : null;
    }

    private boolean isRuntimeType(ASTExpression expr) {
        return expr != null && this.isNotMethodCall(expr) && expr.getType() != null;
    }

    private TypeNode wrappedResourceTypeOrReturn(ASTVariableDeclarator var, TypeNode defaultVal) {
        TypeNode wrappedResType = this.getWrappedResourceType(var);
        return wrappedResType != null ? wrappedResType : defaultVal;
    }

    private TypeNode getWrappedResourceType(ASTVariableDeclarator var) {
        ASTAllocationExpression resAlloc;
        ASTExpression initExpr = this.initializerExpressionOf(var);
        if (initExpr != null && (resAlloc = this.getLastResourceAllocation(initExpr)) != null) {
            ASTExpression firstArgRes = this.getFirstArgumentVariableIfResource(resAlloc);
            return firstArgRes != null ? firstArgRes : resAlloc;
        }
        return null;
    }

    private ASTExpression initializerExpressionOf(ASTVariableDeclarator var) {
        return var.hasInitializer() ? (ASTExpression)var.getInitializer().getFirstChildOfType(ASTExpression.class) : null;
    }

    private ASTAllocationExpression getLastResourceAllocation(ASTExpression expr) {
        int lastAllocIndex;
        List allocations = expr.findDescendantsOfType(ASTAllocationExpression.class);
        for (int allocIndex = lastAllocIndex = allocations.size() - 1; allocIndex >= 0; --allocIndex) {
            ASTAllocationExpression allocation = (ASTAllocationExpression)allocations.get(allocIndex);
            if (!this.isResourceTypeOrSubtype(allocation)) continue;
            return allocation;
        }
        return null;
    }

    private ASTExpression getFirstArgumentVariableIfResource(ASTAllocationExpression allocation) {
        ASTArgumentList argsList = (ASTArgumentList)allocation.getFirstDescendantOfType(ASTArgumentList.class);
        if (argsList != null) {
            ASTExpression firstArg = (ASTExpression)argsList.getFirstChildOfType(ASTExpression.class);
            return firstArg != null && this.isNotMethodCall(firstArg) && this.isResourceTypeOrSubtype(firstArg) ? firstArg : null;
        }
        return null;
    }

    private boolean isNotMethodCall(ASTExpression expr) {
        return !this.isMethodCall(expr);
    }

    private boolean isMethodCall(ASTExpression expression) {
        if (expression != null) {
            ASTPrimaryExpression primaryExpression = (ASTPrimaryExpression)expression.getFirstChildOfType(ASTPrimaryExpression.class);
            return primaryExpression != null && primaryExpression.getFirstChildOfType(ASTPrimarySuffix.class) != null;
        }
        return false;
    }

    private boolean isWrappingResourceSpecifiedInTry(ASTVariableDeclarator var) {
        String wrappedVarName = this.getWrappedVariableName(var);
        if (wrappedVarName != null) {
            List tryContainers = var.getParentsOfType(ASTTryStatement.class);
            for (ASTTryStatement tryContainer : tryContainers) {
                if (!this.isTryWithResourceSpecifyingVariable(tryContainer, wrappedVarName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean shouldVarOfTypeBeClosedInMethod(ASTVariableDeclarator var, TypeNode type, ASTMethodOrConstructorDeclaration method) {
        return this.isNotAllowedResourceType(type) && this.isNotWrappingResourceMethodParameter(var, method) && this.isResourceVariableUnclosed(var);
    }

    private boolean isNotAllowedResourceType(TypeNode varType) {
        return !this.isAllowedResourceType(varType);
    }

    private boolean isAllowedResourceType(TypeNode refType) {
        List allowedResourceTypes = (List)this.getProperty(ALLOWED_RESOURCE_TYPES);
        if (allowedResourceTypes != null) {
            for (String type : allowedResourceTypes) {
                if (!TypeTestUtil.isExactlyA(type, refType)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNotWrappingResourceMethodParameter(ASTVariableDeclarator var, ASTMethodOrConstructorDeclaration method) {
        return !this.isWrappingResourceMethodParameter(var, method);
    }

    private boolean isWrappingResourceMethodParameter(ASTVariableDeclarator var, ASTMethodOrConstructorDeclaration method) {
        ASTFormalParameters methodParams;
        String wrappedVarName = this.getWrappedVariableName(var);
        if (wrappedVarName != null && (methodParams = (ASTFormalParameters)method.getFirstDescendantOfType(ASTFormalParameters.class)) != null) {
            List ids = methodParams.findDescendantsOfType(ASTVariableDeclaratorId.class);
            for (ASTVariableDeclaratorId id : ids) {
                if (!id.hasImageEqualTo(wrappedVarName) || !this.isResourceTypeOrSubtype(id)) continue;
                return true;
            }
        }
        return false;
    }

    private String getWrappedVariableName(ASTVariableDeclarator var) {
        if (var.hasInitializer()) {
            ASTName varName = (ASTName)var.getInitializer().getFirstDescendantOfType(ASTName.class);
            return varName != null ? varName.getImage() : null;
        }
        return null;
    }

    private boolean isResourceTypeOrSubtype(TypeNode refType) {
        return refType.getType() != null ? this.isNodeInstanceOfResourceType(refType) : this.nodeHasReferenceToResourceType(refType);
    }

    private boolean isNodeInstanceOfResourceType(TypeNode refType) {
        for (String resType : this.types) {
            if (!TypeTestUtil.isA(resType, refType)) continue;
            return true;
        }
        return false;
    }

    private boolean nodeHasReferenceToResourceType(TypeNode refType) {
        ASTClassOrInterfaceType type = (ASTClassOrInterfaceType)refType.getFirstDescendantOfType(ASTClassOrInterfaceType.class);
        return type != null && this.isResourceTypeName(type.getImage()) && !type.isReferenceToClassSameCompilationUnit();
    }

    private boolean isResourceTypeName(String typeName) {
        String simpleTypeName = CloseResourceRule.toSimpleType(typeName);
        return this.types.contains(typeName) || this.simpleTypes.contains(simpleTypeName);
    }

    private boolean isResourceVariableUnclosed(ASTVariableDeclarator var) {
        return !this.isResourceVariableClosed(var);
    }

    private boolean isResourceVariableClosed(ASTVariableDeclarator var) {
        Node methodOfVar = this.getMethodOfNode((Node)var);
        return this.hasTryStatementClosingResourceVariable(methodOfVar, var) || this.isReturnedByMethod(var.getName(), methodOfVar);
    }

    private Node getMethodOfNode(Node node) {
        Node parent = node.getParent();
        while (this.isNotMethod(parent)) {
            parent = parent.getParent();
        }
        return parent;
    }

    private boolean isNotMethod(Node node) {
        return !(node instanceof ASTBlock) && !(node instanceof ASTConstructorDeclaration);
    }

    private boolean hasTryStatementClosingResourceVariable(Node node, ASTVariableDeclarator var) {
        List tryStatements = node.findDescendantsOfType(ASTTryStatement.class, true);
        for (ASTTryStatement tryStatement : tryStatements) {
            if (!this.tryStatementClosesResourceVariable(tryStatement, var)) continue;
            return true;
        }
        return false;
    }

    private boolean tryStatementClosesResourceVariable(ASTTryStatement tryStatement, ASTVariableDeclarator var) {
        if (tryStatement.getBeginLine() >= var.getBeginLine() && this.noneCriticalStatementsBetween(var, tryStatement)) {
            if (this.isTryWithResourceSpecifyingVariable(tryStatement, var.getName())) {
                return true;
            }
            if (this.hasFinallyClause(tryStatement)) {
                ASTBlock finallyBody = tryStatement.getFinallyClause().getBody();
                return this.blockClosesResourceVariable(finallyBody, var.getName());
            }
        }
        return false;
    }

    private boolean noneCriticalStatementsBetween(ASTVariableDeclarator var, ASTTryStatement tryStatement) {
        return !this.anyCriticalStatementBetween(var, tryStatement);
    }

    private boolean anyCriticalStatementBetween(ASTVariableDeclarator var, ASTTryStatement tryStatement) {
        ASTBlockStatement varBlockStatement = (ASTBlockStatement)var.getFirstParentOfType(ASTBlockStatement.class);
        ASTBlockStatement tryBlockStatement = (ASTBlockStatement)tryStatement.getFirstParentOfType(ASTBlockStatement.class);
        if (this.isNotNullInitialized(var) && this.areStatementsOfSameBlock(varBlockStatement, tryBlockStatement)) {
            for (ASTBlockStatement bsBetween : this.getBlockStatementsBetween(varBlockStatement, tryBlockStatement)) {
                if (!this.isCriticalStatement(bsBetween)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNotNullInitialized(ASTVariableDeclarator var) {
        return !this.hasNullInitializer(var);
    }

    private boolean hasNullInitializer(ASTVariableDeclarator var) {
        if (var.hasInitializer()) {
            ASTPrimaryPrefix primaryPrefix = (ASTPrimaryPrefix)var.getInitializer().getFirstDescendantOfType(ASTPrimaryPrefix.class);
            return primaryPrefix != null && primaryPrefix.hasDescendantOfType(ASTNullLiteral.class);
        }
        return false;
    }

    private boolean areStatementsOfSameBlock(ASTBlockStatement bs0, ASTBlockStatement bs1) {
        return bs0.getParent() == bs1.getParent();
    }

    private List<ASTBlockStatement> getBlockStatementsBetween(ASTBlockStatement top, ASTBlockStatement bottom) {
        List blockStatements = ((JavaNode)top.getParent()).findChildrenOfType(ASTBlockStatement.class);
        int topBSIndex = blockStatements.indexOf(top);
        int bottomBSIndex = blockStatements.indexOf(bottom);
        return blockStatements.subList(topBSIndex + 1, bottomBSIndex);
    }

    private boolean isCriticalStatement(ASTBlockStatement blockStatement) {
        boolean isVarDeclaration = blockStatement.hasDescendantOfType(ASTLocalVariableDeclaration.class);
        boolean isAssignmentOperator = blockStatement.hasDescendantOfType(ASTAssignmentOperator.class);
        return !isVarDeclaration && !isAssignmentOperator;
    }

    private boolean isTryWithResourceSpecifyingVariable(ASTTryStatement tryStatement, String varName) {
        return tryStatement.isTryWithResources() && this.isVariableSpecifiedInTryWithResource(varName, tryStatement);
    }

    private boolean isVariableSpecifiedInTryWithResource(String varName, ASTTryStatement tryWithResource) {
        List<JavaNode> specifiedResources = this.getResourcesSpecifiedInTryWith(tryWithResource);
        for (JavaNode res : specifiedResources) {
            if (!res.hasImageEqualTo(varName)) continue;
            return true;
        }
        return false;
    }

    private List<JavaNode> getResourcesSpecifiedInTryWith(ASTTryStatement tryWithResource) {
        ASTResourceSpecification resSpecification = (ASTResourceSpecification)tryWithResource.getFirstChildOfType(ASTResourceSpecification.class);
        List initializedVars = resSpecification.findDescendantsOfType(ASTVariableDeclaratorId.class);
        List specifiedVars = resSpecification.findDescendantsOfType(ASTName.class);
        return this.combineNodeLists(initializedVars, specifiedVars);
    }

    private List<JavaNode> combineNodeLists(List<? extends JavaNode> list0, List<? extends JavaNode> list1) {
        ArrayList<JavaNode> nodeList = new ArrayList<JavaNode>(list0);
        nodeList.addAll(list1);
        return nodeList;
    }

    private boolean hasFinallyClause(ASTTryStatement tryStatement) {
        return tryStatement.getFinallyClause() != null;
    }

    private boolean blockClosesResourceVariable(ASTBlock block, String variableToClose) {
        return this.hasNotConditionalCloseCallOnVariable(block, variableToClose) || this.hasMethodCallClosingResourceVariable(block, variableToClose);
    }

    private boolean hasNotConditionalCloseCallOnVariable(ASTBlock block, String variableToClose) {
        List operations = block.findDescendantsOfType(ASTName.class);
        for (ASTName operation : operations) {
            if (!this.isCloseCallOnVariable(operation, variableToClose) || !this.isNotConditional(block, (Node)operation, variableToClose)) continue;
            return true;
        }
        return false;
    }

    private boolean isCloseCallOnVariable(ASTName op, String variableToClose) {
        String closedVar = this.getVariableClosedByMethodCall(op);
        return variableToClose.equals(closedVar);
    }

    private boolean isNotConditional(ASTBlock enclosingBlock, Node node, String varName) {
        ASTIfStatement ifStatement = this.findIfStatement(enclosingBlock, node);
        if (ifStatement != null) {
            try {
                List nodes = ifStatement.findChildNodesWithXPath("Expression/EqualityExpression[@Image='!=']  [PrimaryExpression/PrimaryPrefix/Name[@Image='" + varName + "']]  [PrimaryExpression/PrimaryPrefix/Literal/NullLiteral]");
                return !nodes.isEmpty();
            }
            catch (JaxenException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    private ASTIfStatement findIfStatement(ASTBlock enclosingBlock, Node node) {
        ASTIfStatement ifStatement = (ASTIfStatement)node.getFirstParentOfType(ASTIfStatement.class);
        List allIfStatements = enclosingBlock.findDescendantsOfType(ASTIfStatement.class);
        if (ifStatement != null && allIfStatements.contains(ifStatement)) {
            return ifStatement;
        }
        return null;
    }

    private boolean hasMethodCallClosingResourceVariable(ASTBlock block, String variableToClose) {
        List expressions = block.findDescendantsOfType(ASTPrimaryExpression.class, true);
        for (ASTPrimaryExpression expression : expressions) {
            if (!this.isMethodCallClosingResourceVariable(expression, variableToClose)) continue;
            return true;
        }
        return false;
    }

    private boolean isMethodCallClosingResourceVariable(ASTPrimaryExpression expression, String variableToClose) {
        ASTPrimaryPrefix prefix = (ASTPrimaryPrefix)expression.getFirstDescendantOfType(ASTPrimaryPrefix.class);
        ASTPrimarySuffix suffix = (ASTPrimarySuffix)expression.getFirstDescendantOfType(ASTPrimarySuffix.class);
        if (prefix != null && suffix != null) {
            return (this.isCloseTargetMethodCall(prefix, suffix) || this.hasChainedCloseTargetMethodCall(expression)) && this.variableIsPassedToMethod(variableToClose, expression);
        }
        return false;
    }

    private boolean isCloseTargetMethodCall(ASTPrimaryPrefix prefix, ASTPrimarySuffix suffix) {
        String methodCall = this.getMethodCallStr(prefix, suffix);
        return methodCall != null && this.closeTargets.contains(methodCall);
    }

    private String getMethodCallStr(ASTPrimaryPrefix prefix, ASTPrimarySuffix suffix) {
        if (prefix.getImage() == null) {
            ASTName name = (ASTName)prefix.getFirstDescendantOfType(ASTName.class);
            return name != null ? name.getImage() : null;
        }
        if (suffix.getImage() != null) {
            return prefix.getImage() + "." + suffix.getImage();
        }
        return null;
    }

    private boolean hasChainedCloseTargetMethodCall(ASTPrimaryExpression expr) {
        List methodCalls = expr.findDescendantsOfType(ASTPrimarySuffix.class, true);
        for (ASTPrimarySuffix methodCall : methodCalls) {
            if (!this.closeTargets.contains(methodCall.getImage())) continue;
            return true;
        }
        return false;
    }

    private boolean variableIsPassedToMethod(String varName, ASTPrimaryExpression methodCall) {
        List methodCallArgs = methodCall.findDescendantsOfType(ASTName.class, true);
        for (ASTName methodCallArg : methodCallArgs) {
            if (!this.isMethodCallArgument(methodCallArg) || !methodCallArg.hasImageEqualTo(varName)) continue;
            return true;
        }
        return false;
    }

    private boolean isMethodCallArgument(ASTName varName) {
        return varName.getFirstParentOfType(ASTArgumentList.class) != null;
    }

    private boolean isReturnedByMethod(String varName, Node method) {
        List returns = method.findDescendantsOfType(ASTReturnStatement.class, true);
        for (ASTReturnStatement returnStatement : returns) {
            ASTName name = (ASTName)returnStatement.getFirstDescendantOfType(ASTName.class);
            if (name == null || !name.hasImageEqualTo(varName)) continue;
            return true;
        }
        return false;
    }

    private void addCloseResourceViolation(ASTVariableDeclaratorId id, TypeNode type, Object data) {
        String resTypeName = this.getResourceTypeName(id, type);
        this.addViolation(data, (Node)id, resTypeName);
    }

    private String getResourceTypeName(ASTVariableDeclaratorId varId, TypeNode type) {
        Class<?> typeClass = type.getType();
        if (typeClass == null) {
            ASTLocalVariableDeclaration localVarDecl = (ASTLocalVariableDeclaration)varId.getFirstParentOfType(ASTLocalVariableDeclaration.class);
            return localVarDecl != null && localVarDecl.getTypeNode() != null ? localVarDecl.getTypeNode().getTypeImage() : varId.getName();
        }
        return typeClass.getSimpleName();
    }

    @Override
    public Object visit(ASTPrimaryPrefix prefix, Object data) {
        String closedVar;
        if (!((Boolean)this.getProperty(DETECT_CLOSE_NOT_IN_FINALLY)).booleanValue()) {
            return super.visit(prefix, data);
        }
        ASTName methodCall = (ASTName)prefix.getFirstChildOfType(ASTName.class);
        if (methodCall != null && this.isNodeInstanceOfResourceType(methodCall) && (closedVar = this.getVariableClosedByMethodCall(methodCall)) != null && this.isNotInFinallyBlock(prefix) && !this.reportedVarNames.contains(closedVar)) {
            String violationMsg = this.closeInFinallyBlockMessageForVar(closedVar);
            this.addViolationWithMessage(data, (Node)prefix, violationMsg);
        }
        return super.visit(prefix, data);
    }

    private String getVariableClosedByMethodCall(ASTName methodCall) {
        String[] callParts = this.getMethodCallParts(methodCall);
        if (callParts != null) {
            String varName = callParts[0];
            String methodName = callParts[1];
            return this.closeTargets.contains(methodName) ? varName : null;
        }
        return null;
    }

    private String[] getMethodCallParts(ASTName methodCall) {
        String methodCallStr = methodCall.getImage();
        return methodCallStr != null && methodCallStr.contains(".") ? methodCallStr.split("\\.") : null;
    }

    private boolean isNotInFinallyBlock(ASTPrimaryPrefix prefix) {
        return prefix.getFirstParentOfType(ASTFinallyStatement.class) == null;
    }

    private String closeInFinallyBlockMessageForVar(String var) {
        return "''" + var + CLOSE_IN_FINALLY_BLOCK_MESSAGE;
    }

    private String reassignBeforeClosedMessageForVar(String var) {
        return "''" + var + REASSIGN_BEFORE_CLOSED_MESSAGE;
    }

    private ASTStatementExpression getFirstReassigningStatementBeforeBeingClosed(ASTVariableDeclarator variable, ASTMethodOrConstructorDeclaration methodOrConstructor) {
        List statements = methodOrConstructor.findDescendantsOfType(ASTStatementExpression.class);
        boolean variableClosed = false;
        boolean isInitialized = !this.hasNullInitializer(variable);
        ASTExpression initializingExpression = this.initializerExpressionOf(variable);
        for (ASTStatementExpression statement : statements) {
            if (this.isClosingVariableStatement(statement, variable)) {
                variableClosed = true;
            }
            if (!this.isAssignmentForVariable(statement, variable)) continue;
            if (isInitialized && !variableClosed && initializingExpression != null && !this.inSameIfBlock(statement, initializingExpression)) {
                return statement;
            }
            if (variableClosed) {
                variableClosed = false;
            }
            if (isInitialized) continue;
            isInitialized = true;
            initializingExpression = (ASTExpression)statement.getFirstDescendantOfType(ASTExpression.class);
        }
        return null;
    }

    private boolean inSameIfBlock(ASTStatementExpression statement1, ASTExpression statement2) {
        List parents1 = statement1.getParentsOfType(ASTIfStatement.class);
        List parents2 = statement2.getParentsOfType(ASTIfStatement.class);
        parents1.retainAll(parents2);
        return !parents1.isEmpty();
    }

    private boolean isClosingVariableStatement(ASTStatementExpression statement, ASTVariableDeclarator variable) {
        List expressions = statement.findDescendantsOfType(ASTPrimaryExpression.class);
        for (ASTPrimaryExpression expression : expressions) {
            if (!this.isMethodCallClosingResourceVariable(expression, variable.getName())) continue;
            return true;
        }
        List names = statement.findDescendantsOfType(ASTName.class);
        for (ASTName name : names) {
            if (!this.isCloseCallOnVariable(name, variable.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean isAssignmentForVariable(ASTStatementExpression statement, ASTVariableDeclarator variable) {
        if (statement == null || variable == null) {
            return false;
        }
        ASTName name = (ASTName)statement.getFirstDescendantOfType(ASTName.class);
        if (name == null) {
            return false;
        }
        NameDeclaration statementVariable = name.getNameDeclaration();
        if (statementVariable == null) {
            return false;
        }
        return statement.hasDescendantOfType(ASTAssignmentOperator.class) && statementVariable.equals(variable.getVariableId().getNameDeclaration());
    }
}

