/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.impl;

import java.util.Collection;
import java.util.List;
import org.activiti.api.process.model.ProcessInstance;
import org.activiti.api.process.model.builders.ProcessPayloadBuilder;
import org.activiti.api.process.model.payloads.DeleteProcessPayload;
import org.activiti.api.process.model.payloads.GetProcessDefinitionsPayload;
import org.activiti.api.process.model.payloads.GetProcessInstancesPayload;
import org.activiti.api.process.model.payloads.RemoveProcessVariablesPayload;
import org.activiti.api.process.model.payloads.ResumeProcessPayload;
import org.activiti.api.process.model.payloads.SetProcessVariablesPayload;
import org.activiti.api.process.model.payloads.SignalPayload;
import org.activiti.api.process.model.payloads.StartProcessPayload;
import org.activiti.api.process.model.payloads.SuspendProcessPayload;
import org.activiti.api.process.runtime.ProcessAdminRuntime;
import org.activiti.api.runtime.model.impl.ProcessInstanceImpl;
import org.activiti.api.runtime.shared.NotFoundException;
import org.activiti.api.runtime.shared.query.Page;
import org.activiti.api.runtime.shared.query.Pageable;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.activiti.engine.runtime.ProcessInstanceQuery;
import org.activiti.runtime.api.model.impl.APIProcessDefinitionConverter;
import org.activiti.runtime.api.model.impl.APIProcessInstanceConverter;
import org.activiti.runtime.api.query.impl.PageImpl;
import org.springframework.security.access.prepost.PreAuthorize;

@PreAuthorize(value="hasRole('ACTIVITI_ADMIN')")
public class ProcessAdminRuntimeImpl
implements ProcessAdminRuntime {
    private final RepositoryService repositoryService;
    private final APIProcessDefinitionConverter processDefinitionConverter;
    private final RuntimeService runtimeService;
    private final APIProcessInstanceConverter processInstanceConverter;

    public ProcessAdminRuntimeImpl(RepositoryService repositoryService, APIProcessDefinitionConverter processDefinitionConverter, RuntimeService runtimeService, APIProcessInstanceConverter processInstanceConverter) {
        this.repositoryService = repositoryService;
        this.processDefinitionConverter = processDefinitionConverter;
        this.runtimeService = runtimeService;
        this.processInstanceConverter = processInstanceConverter;
    }

    public org.activiti.api.process.model.ProcessDefinition processDefinition(String processDefinitionId) {
        List list = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionId).orderByProcessDefinitionVersion().asc()).list();
        ProcessDefinition processDefinition = !list.isEmpty() ? (ProcessDefinition)list.get(0) : this.repositoryService.getProcessDefinition(processDefinitionId);
        return this.processDefinitionConverter.from(processDefinition);
    }

    public Page<org.activiti.api.process.model.ProcessDefinition> processDefinitions(Pageable pageable) {
        return this.processDefinitions(pageable, ProcessPayloadBuilder.processDefinitions().build());
    }

    public Page<org.activiti.api.process.model.ProcessDefinition> processDefinitions(Pageable pageable, GetProcessDefinitionsPayload getProcessDefinitionsPayload) {
        if (getProcessDefinitionsPayload == null) {
            throw new IllegalStateException("payload cannot be null");
        }
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery();
        if (getProcessDefinitionsPayload.hasDefinitionKeys()) {
            processDefinitionQuery.processDefinitionKeys(getProcessDefinitionsPayload.getProcessDefinitionKeys());
        }
        return new PageImpl(this.processDefinitionConverter.from(processDefinitionQuery.list()), Math.toIntExact(processDefinitionQuery.count()));
    }

    public ProcessInstance start(StartProcessPayload startProcessPayload) {
        org.activiti.api.process.model.ProcessDefinition processDefinition = null;
        if (startProcessPayload.getProcessDefinitionId() != null) {
            processDefinition = this.processDefinition(startProcessPayload.getProcessDefinitionId());
        }
        if (processDefinition == null && startProcessPayload.getProcessDefinitionKey() != null) {
            processDefinition = this.processDefinition(startProcessPayload.getProcessDefinitionKey());
        }
        if (processDefinition == null) {
            throw new IllegalStateException("At least Process Definition Id or Key needs to be provided to start a process");
        }
        return this.processInstanceConverter.from(this.runtimeService.createProcessInstanceBuilder().processDefinitionId(startProcessPayload.getProcessDefinitionId()).processDefinitionKey(startProcessPayload.getProcessDefinitionKey()).businessKey(startProcessPayload.getBusinessKey()).variables(startProcessPayload.getVariables()).name(startProcessPayload.getProcessInstanceName()).start());
    }

    public Page<ProcessInstance> processInstances(Pageable pageable) {
        return this.processInstances(pageable, null);
    }

    public ProcessInstance processInstance(String processInstanceId) {
        org.activiti.engine.runtime.ProcessInstance internalProcessInstance = (org.activiti.engine.runtime.ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (internalProcessInstance == null) {
            throw new NotFoundException("Unable to find process instance for the given id:'" + processInstanceId + "'");
        }
        return this.processInstanceConverter.from(internalProcessInstance);
    }

    public Page<ProcessInstance> processInstances(Pageable pageable, GetProcessInstancesPayload getProcessInstancesPayload) {
        ProcessInstanceQuery internalQuery = this.runtimeService.createProcessInstanceQuery();
        if (getProcessInstancesPayload != null) {
            if (getProcessInstancesPayload.getProcessDefinitionKeys() != null && !getProcessInstancesPayload.getProcessDefinitionKeys().isEmpty()) {
                internalQuery.processDefinitionKeys(getProcessInstancesPayload.getProcessDefinitionKeys());
            }
            if (getProcessInstancesPayload.getBusinessKey() != null && !getProcessInstancesPayload.getBusinessKey().isEmpty()) {
                internalQuery.processInstanceBusinessKey(getProcessInstancesPayload.getBusinessKey());
            }
            if (getProcessInstancesPayload.isSuspendedOnly()) {
                internalQuery.suspended();
            }
            if (getProcessInstancesPayload.isActiveOnly()) {
                internalQuery.active();
            }
        }
        return new PageImpl(this.processInstanceConverter.from(internalQuery.listPage(pageable.getStartIndex(), pageable.getMaxItems())), Math.toIntExact(internalQuery.count()));
    }

    public ProcessInstance delete(DeleteProcessPayload deleteProcessPayload) {
        ProcessInstanceImpl processInstance = (ProcessInstanceImpl)this.processInstance(deleteProcessPayload.getProcessInstanceId());
        this.runtimeService.deleteProcessInstance(deleteProcessPayload.getProcessInstanceId(), deleteProcessPayload.getReason());
        if (processInstance != null) {
            processInstance.setStatus(ProcessInstance.ProcessInstanceStatus.DELETED);
            return processInstance;
        }
        return null;
    }

    public void signal(SignalPayload signalPayload) {
        this.runtimeService.signalEventReceived(signalPayload.getName(), signalPayload.getVariables());
    }

    public ProcessInstance suspend(SuspendProcessPayload suspendProcessPayload) {
        this.runtimeService.suspendProcessInstanceById(suspendProcessPayload.getProcessInstanceId());
        return this.processInstanceConverter.from((org.activiti.engine.runtime.ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(suspendProcessPayload.getProcessInstanceId()).singleResult());
    }

    public ProcessInstance resume(ResumeProcessPayload resumeProcessPayload) {
        this.runtimeService.activateProcessInstanceById(resumeProcessPayload.getProcessInstanceId());
        return this.processInstanceConverter.from((org.activiti.engine.runtime.ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(resumeProcessPayload.getProcessInstanceId()).singleResult());
    }

    public void setVariables(SetProcessVariablesPayload setProcessVariablesPayload) {
        this.runtimeService.setVariables(setProcessVariablesPayload.getProcessInstanceId(), setProcessVariablesPayload.getVariables());
    }

    public void removeVariables(RemoveProcessVariablesPayload removeProcessVariablesPayload) {
        this.runtimeService.removeVariables(removeProcessVariablesPayload.getProcessInstanceId(), (Collection)removeProcessVariablesPayload.getVariableNames());
    }
}

