/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.process;

import java.io.InputStream;
import java.util.Collections;
import javax.servlet.http.HttpServletResponse;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ProcessEngineConfiguration;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.image.ProcessDiagramGenerator;
import org.activiti.rest.service.api.runtime.process.BaseProcessInstanceResource;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProcessInstanceDiagramResource
extends BaseProcessInstanceResource {
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected ProcessEngineConfiguration processEngineConfiguration;

    @RequestMapping(value={"/runtime/process-instances/{processInstanceId}/diagram"}, method={RequestMethod.GET})
    @ResponseBody
    public byte[] getProcessInstanceDiagram(@PathVariable String processInstanceId, HttpServletResponse response) {
        ProcessInstance processInstance = this.getProcessInstanceFromRequest(processInstanceId);
        ProcessDefinitionEntity pde = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processInstance.getProcessDefinitionId());
        if (pde != null && pde.isGraphicalNotationDefined()) {
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(pde.getId());
            ProcessDiagramGenerator diagramGenerator = this.processEngineConfiguration.getProcessDiagramGenerator();
            InputStream resource = diagramGenerator.generateDiagram(bpmnModel, "png", this.runtimeService.getActiveActivityIds(processInstance.getId()), Collections.emptyList(), this.processEngineConfiguration.getActivityFontName(), this.processEngineConfiguration.getLabelFontName(), this.processEngineConfiguration.getClassLoader(), 1.0);
            try {
                byte[] responseBytes = IOUtils.toByteArray((InputStream)resource);
                response.setContentType("image/png");
                return responseBytes;
            }
            catch (Exception e) {
                response.setContentType("application/json");
                throw new ActivitiIllegalArgumentException("Error exporting diagram", (Throwable)e);
            }
        }
        response.setContentType("application/json");
        throw new ActivitiIllegalArgumentException("Process instance with id '" + processInstance.getId() + "' has no graphical notation defined.");
    }
}

