/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.repository;

import java.io.InputStream;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.rest.service.api.repository.BaseProcessDefinitionResource;
import org.apache.commons.io.IOUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProcessDefinitionImageResource
extends BaseProcessDefinitionResource {
    @RequestMapping(value={"/repository/process-definitions/{processDefinitionId}/image"}, method={RequestMethod.GET})
    public ResponseEntity<byte[]> getModelResource(@PathVariable String processDefinitionId) {
        ProcessDefinition processDefinition = this.getProcessDefinitionFromRequest(processDefinitionId);
        InputStream imageStream = this.repositoryService.getProcessDiagram(processDefinition.getId());
        if (imageStream != null) {
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.set("Content-Type", "image/png");
            try {
                return new ResponseEntity((Object)IOUtils.toByteArray((InputStream)imageStream), (MultiValueMap)responseHeaders, HttpStatus.OK);
            }
            catch (Exception e) {
                throw new ActivitiException("Error reading image stream", (Throwable)e);
            }
        }
        throw new ActivitiIllegalArgumentException("Process definition with id '" + processDefinition.getId() + "' has no image.");
    }
}

