/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.repository;

import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.rest.exception.ActivitiConflictException;
import org.activiti.rest.service.api.repository.BaseProcessDefinitionResource;
import org.activiti.rest.service.api.repository.ProcessDefinitionActionRequest;
import org.activiti.rest.service.api.repository.ProcessDefinitionResponse;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProcessDefinitionResource
extends BaseProcessDefinitionResource {
    @RequestMapping(value={"/repository/process-definitions/{processDefinitionId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public ProcessDefinitionResponse getProcessDefinition(@PathVariable String processDefinitionId, HttpServletRequest request) {
        ProcessDefinition processDefinition = this.getProcessDefinitionFromRequest(processDefinitionId);
        return this.restResponseFactory.createProcessDefinitionResponse(processDefinition);
    }

    @RequestMapping(value={"/repository/process-definitions/{processDefinitionId}"}, method={RequestMethod.PUT}, produces={"application/json"})
    public ProcessDefinitionResponse executeProcessDefinitionAction(@PathVariable String processDefinitionId, @RequestBody ProcessDefinitionActionRequest actionRequest, HttpServletRequest request) {
        if (actionRequest == null) {
            throw new ActivitiIllegalArgumentException("No action found in request body.");
        }
        ProcessDefinition processDefinition = this.getProcessDefinitionFromRequest(processDefinitionId);
        if (actionRequest.getCategory() != null) {
            this.repositoryService.setProcessDefinitionCategory(processDefinition.getId(), actionRequest.getCategory());
            ProcessDefinitionResponse response = this.restResponseFactory.createProcessDefinitionResponse(processDefinition);
            response.setCategory(actionRequest.getCategory());
            return response;
        }
        if (actionRequest.getAction() != null) {
            if ("suspend".equals(actionRequest.getAction())) {
                return this.suspendProcessDefinition(processDefinition, actionRequest.isIncludeProcessInstances(), actionRequest.getDate());
            }
            if ("activate".equals(actionRequest.getAction())) {
                return this.activateProcessDefinition(processDefinition, actionRequest.isIncludeProcessInstances(), actionRequest.getDate());
            }
        }
        throw new ActivitiIllegalArgumentException("Invalid action: '" + actionRequest.getAction() + "'.");
    }

    protected ProcessDefinitionResponse activateProcessDefinition(ProcessDefinition processDefinition, boolean suspendInstances, Date date) {
        if (!this.repositoryService.isProcessDefinitionSuspended(processDefinition.getId())) {
            throw new ActivitiConflictException("Process definition with id '" + processDefinition.getId() + " ' is already active");
        }
        this.repositoryService.activateProcessDefinitionById(processDefinition.getId(), suspendInstances, date);
        ProcessDefinitionResponse response = this.restResponseFactory.createProcessDefinitionResponse(processDefinition);
        response.setSuspended(false);
        return response;
    }

    protected ProcessDefinitionResponse suspendProcessDefinition(ProcessDefinition processDefinition, boolean suspendInstances, Date date) {
        if (this.repositoryService.isProcessDefinitionSuspended(processDefinition.getId())) {
            throw new ActivitiConflictException("Process definition with id '" + processDefinition.getId() + " ' is already suspended");
        }
        this.repositoryService.suspendProcessDefinitionById(processDefinition.getId(), suspendInstances, date);
        ProcessDefinitionResponse response = this.restResponseFactory.createProcessDefinitionResponse(processDefinition);
        response.setSuspended(true);
        return response;
    }
}

