/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.process;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.rest.exception.ActivitiConflictException;
import org.activiti.rest.service.api.runtime.process.BaseProcessInstanceResource;
import org.activiti.rest.service.api.runtime.process.ProcessInstanceActionRequest;
import org.activiti.rest.service.api.runtime.process.ProcessInstanceResponse;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProcessInstanceResource
extends BaseProcessInstanceResource {
    @RequestMapping(value={"/runtime/process-instances/{processInstanceId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public ProcessInstanceResponse getProcessInstance(@PathVariable String processInstanceId, HttpServletRequest request) {
        return this.restResponseFactory.createProcessInstanceResponse(this.getProcessInstanceFromRequest(processInstanceId));
    }

    @RequestMapping(value={"/runtime/process-instances/{processInstanceId}"}, method={RequestMethod.DELETE})
    public void deleteProcessInstance(@PathVariable String processInstanceId, @RequestParam(value="deleteReason", required=false) String deleteReason, HttpServletResponse response) {
        ProcessInstance processInstance = this.getProcessInstanceFromRequest(processInstanceId);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), deleteReason);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    @RequestMapping(value={"/runtime/process-instances/{processInstanceId}"}, method={RequestMethod.PUT}, produces={"application/json"})
    public ProcessInstanceResponse performProcessInstanceAction(@PathVariable String processInstanceId, @RequestBody ProcessInstanceActionRequest actionRequest, HttpServletRequest request) {
        ProcessInstance processInstance = this.getProcessInstanceFromRequest(processInstanceId);
        if ("activate".equals(actionRequest.getAction())) {
            return this.activateProcessInstance(processInstance);
        }
        if ("suspend".equals(actionRequest.getAction())) {
            return this.suspendProcessInstance(processInstance);
        }
        throw new ActivitiIllegalArgumentException("Invalid action: '" + actionRequest.getAction() + "'.");
    }

    protected ProcessInstanceResponse activateProcessInstance(ProcessInstance processInstance) {
        if (!processInstance.isSuspended()) {
            throw new ActivitiConflictException("Process instance with id '" + processInstance.getId() + "' is already active.");
        }
        this.runtimeService.activateProcessInstanceById(processInstance.getId());
        ProcessInstanceResponse response = this.restResponseFactory.createProcessInstanceResponse(processInstance);
        response.setSuspended(false);
        return response;
    }

    protected ProcessInstanceResponse suspendProcessInstance(ProcessInstance processInstance) {
        if (processInstance.isSuspended()) {
            throw new ActivitiConflictException("Process instance with id '" + processInstance.getId() + "' is already suspended.");
        }
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        ProcessInstanceResponse response = this.restResponseFactory.createProcessInstanceResponse(processInstance);
        response.setSuspended(true);
        return response;
    }
}

