/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.scripting.secure.behavior;

import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.ScriptTask;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.ScriptTaskParseHandler;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.scripting.secure.behavior.SecureJavascriptTaskActivityBehavior;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureJavascriptTaskParseHandler
extends ScriptTaskParseHandler {
    private static final Logger logger = LoggerFactory.getLogger(SecureJavascriptTaskParseHandler.class);
    public static final String LANGUAGE_JAVASCRIPT = "javascript";

    protected void executeParse(BpmnParse bpmnParse, ScriptTask scriptTask) {
        String language = scriptTask.getScriptFormat();
        if (LANGUAGE_JAVASCRIPT.equalsIgnoreCase(language)) {
            this.createSecureJavascriptTaskBehavior(bpmnParse, scriptTask, language);
        } else {
            super.executeParse(bpmnParse, scriptTask);
        }
    }

    private void createSecureJavascriptTaskBehavior(BpmnParse bpmnParse, ScriptTask scriptTask, String language) {
        if (StringUtils.isEmpty((CharSequence)scriptTask.getScript())) {
            logger.warn("No script provided for scriptTask " + scriptTask.getId());
        }
        ActivityImpl activity = this.createActivityOnCurrentScope(bpmnParse, (FlowElement)scriptTask, "scriptTask");
        activity.setAsync(scriptTask.isAsynchronous());
        activity.setExclusive(!scriptTask.isNotExclusive());
        activity.setActivityBehavior((ActivityBehavior)new SecureJavascriptTaskActivityBehavior(scriptTask.getId(), scriptTask.getScript(), language, scriptTask.getResultVariable(), scriptTask.isAutoStoreVariables()));
    }
}

