/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.scripting.secure.impl;

import org.activiti.scripting.secure.impl.SecureScriptClassShutter;
import org.activiti.scripting.secure.impl.SecureScriptContext;
import org.activiti.scripting.secure.impl.SecureScriptThreadMxBeanWrapper;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureScriptContextFactory
extends ContextFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecureScriptContextFactory.class);
    protected SecureScriptClassShutter classShutter;
    protected int observeInstructionCount = 10;
    protected long maxScriptExecutionTime = -1L;
    protected long maxMemoryUsed = -1L;
    protected int maxStackDepth = -1;
    protected int optimizationLevel = -1;
    protected SecureScriptThreadMxBeanWrapper threadMxBeanWrapper;

    protected Context makeContext() {
        SecureScriptContext context = new SecureScriptContext();
        context.getWrapFactory().setJavaPrimitiveWrap(false);
        context.setOptimizationLevel(this.optimizationLevel);
        if (this.classShutter != null) {
            context.setClassShutter(this.classShutter);
        }
        if (this.maxScriptExecutionTime > 0L || this.maxMemoryUsed > 0L) {
            context.setGenerateObserverCount(true);
            context.setInstructionObserverThreshold(this.observeInstructionCount);
        }
        if (this.maxMemoryUsed > 0L) {
            context.setThreadId(Thread.currentThread().getId());
        }
        if (this.maxStackDepth > 0) {
            context.setOptimizationLevel(-1);
            context.setMaximumInterpreterStackDepth(this.maxStackDepth);
        }
        return context;
    }

    protected void observeInstructionCount(Context cx, int instructionCount) {
        long currentTime;
        SecureScriptContext context = (SecureScriptContext)cx;
        if (this.maxScriptExecutionTime > 0L && (currentTime = System.currentTimeMillis()) - context.getStartTime() > this.maxScriptExecutionTime) {
            throw new Error("Maximum variableScope time of " + this.maxScriptExecutionTime + " ms exceeded");
        }
        if (this.maxMemoryUsed > 0L && this.threadMxBeanWrapper != null) {
            if (context.getStartMemory() <= 0L) {
                context.setStartMemory(this.threadMxBeanWrapper.getThreadAllocatedBytes(context.getThreadId()));
            } else {
                long currentAllocatedBytes = this.threadMxBeanWrapper.getThreadAllocatedBytes(context.getThreadId());
                if (currentAllocatedBytes - context.getStartMemory() >= this.maxMemoryUsed) {
                    throw new Error("Memory limit of " + this.maxMemoryUsed + " bytes reached");
                }
            }
        }
    }

    protected Object doTopCall(Callable callable, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        SecureScriptContext mcx = (SecureScriptContext)cx;
        mcx.setStartTime(System.currentTimeMillis());
        return super.doTopCall(callable, cx, scope, thisObj, args);
    }

    public int getOptimizationLevel() {
        return this.optimizationLevel;
    }

    public void setOptimizationLevel(int optimizationLevel) {
        this.optimizationLevel = optimizationLevel;
    }

    public SecureScriptClassShutter getClassShutter() {
        return this.classShutter;
    }

    public void setClassShutter(SecureScriptClassShutter classShutter) {
        this.classShutter = classShutter;
    }

    public int getObserveInstructionCount() {
        return this.observeInstructionCount;
    }

    public void setObserveInstructionCount(int observeInstructionCount) {
        this.observeInstructionCount = observeInstructionCount;
    }

    public long getMaxScriptExecutionTime() {
        return this.maxScriptExecutionTime;
    }

    public void setMaxScriptExecutionTime(long maxScriptExecutionTime) {
        this.maxScriptExecutionTime = maxScriptExecutionTime;
    }

    public long getMaxMemoryUsed() {
        return this.maxMemoryUsed;
    }

    public void setMaxMemoryUsed(long maxMemoryUsed) {
        this.maxMemoryUsed = maxMemoryUsed;
        if (maxMemoryUsed > 0L) {
            try {
                Class<?> clazz = Class.forName("com.sun.management.ThreadMXBean");
                if (clazz != null) {
                    this.threadMxBeanWrapper = new SecureScriptThreadMxBeanWrapper();
                }
            }
            catch (ClassNotFoundException cnfe) {
                LOGGER.warn("com.sun.management.ThreadMXBean was not found on the classpath. This means that the limiting the memory usage for a script will NOT work.");
            }
        }
    }

    public int getMaxStackDepth() {
        return this.maxStackDepth;
    }

    public void setMaxStackDepth(int maxStackDepth) {
        this.maxStackDepth = maxStackDepth;
    }
}

