/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.boot.actuate.endpoint;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.persistence.deploy.DefaultDeploymentCache;
import org.activiti.engine.impl.persistence.deploy.DeploymentCache;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="endpoints.activiti")
@Endpoint(id="activiti")
public class ProcessEngineEndpoint {
    private final ProcessEngine processEngine;

    public ProcessEngineEndpoint(ProcessEngine processEngine) {
        this.processEngine = processEngine;
    }

    @ReadOperation
    public Map<String, Object> invoke() {
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        metrics.put("processDefinitionCount", this.processEngine.getRepositoryService().createProcessDefinitionQuery().count());
        List processDefinitions = ((ProcessDefinitionQuery)this.processEngine.getRepositoryService().createProcessDefinitionQuery().orderByProcessDefinitionKey().asc()).list();
        ArrayList<CallSite> processDefinitionKeys = new ArrayList<CallSite>();
        for (Object processDefinition : processDefinitions) {
            processDefinitionKeys.add((CallSite)((Object)(processDefinition.getKey() + " (v" + processDefinition.getVersion() + ")")));
        }
        metrics.put("deployedProcessDefinitions", processDefinitionKeys);
        HashMap<CallSite, Long> processInstanceCountMap = new HashMap<CallSite, Long>();
        metrics.put("runningProcessInstanceCount", processInstanceCountMap);
        for (Object processDefinition : processDefinitions) {
            processInstanceCountMap.put((CallSite)((Object)(processDefinition.getKey() + " (v" + processDefinition.getVersion() + ")")), this.processEngine.getRuntimeService().createProcessInstanceQuery().processDefinitionId(processDefinition.getId()).count());
        }
        HashMap<CallSite, Long> completedProcessInstanceCountMap = new HashMap<CallSite, Long>();
        metrics.put("completedProcessInstanceCount", completedProcessInstanceCountMap);
        for (ProcessDefinition processDefinition : processDefinitions) {
            completedProcessInstanceCountMap.put((CallSite)((Object)(processDefinition.getKey() + " (v" + processDefinition.getVersion() + ")")), this.processEngine.getHistoryService().createHistoricProcessInstanceQuery().finished().processDefinitionId(processDefinition.getId()).count());
        }
        metrics.put("openTaskCount", this.processEngine.getTaskService().createTaskQuery().count());
        metrics.put("completedTaskCount", this.processEngine.getHistoryService().createHistoricTaskInstanceQuery().finished().count());
        metrics.put("completedTaskCountToday", this.processEngine.getHistoryService().createHistoricTaskInstanceQuery().finished().taskCompletedAfter(new Date(System.currentTimeMillis() - this.secondsForDays(1))).count());
        metrics.put("completedActivities", this.processEngine.getHistoryService().createHistoricActivityInstanceQuery().finished().count());
        DeploymentCache deploymentCache = ((ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration()).getProcessDefinitionCache();
        if (deploymentCache instanceof DefaultDeploymentCache) {
            metrics.put("cachedProcessDefinitionCount", ((DefaultDeploymentCache)deploymentCache).size());
        }
        return metrics;
    }

    private long secondsForDays(int days) {
        int hour = 3600000;
        int day = 24 * hour;
        return days * day;
    }
}

