/*
 * Decompiled with CFR 0.152.
 */
package love.cq.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import love.cq.domain.WoodInterface;

public class AnsjArrays {
    private static final int INSERTIONSORT_THRESHOLD = 7;

    public static int binarySearch(WoodInterface[] branches, char c) {
        int high = branches.length - 1;
        if (branches.length < 1) {
            return high;
        }
        int low = 0;
        while (low <= high) {
            int mid = low + high >>> 1;
            int cmp = branches[mid].compareTo(c);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static void main(String[] args) {
        int[] chars = new int[]{1, 2, 3, 4, 5, 6, 8, 7};
        chars = Arrays.copyOf(chars, 100);
        System.out.println(chars.length);
        for (int i = 0; i < chars.length; ++i) {
            System.out.println(chars[i]);
        }
    }

    public static void sort(WoodInterface[] a) {
        WoodInterface[] aux = (WoodInterface[])a.clone();
        AnsjArrays.mergeSort(aux, a, 0, a.length, 0);
    }

    public static void sort(WoodInterface[] a, int fromIndex, int toIndex) {
        AnsjArrays.rangeCheck(a.length, fromIndex, toIndex);
        WoodInterface[] aux = AnsjArrays.copyOfRange(a, fromIndex, toIndex);
        AnsjArrays.mergeSort(aux, a, fromIndex, toIndex, -fromIndex);
    }

    private static void rangeCheck(int arrayLen, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > arrayLen) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
    }

    private static void mergeSort(WoodInterface[] src, WoodInterface[] dest, int low, int high, int off) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && dest[j - 1].compareTo(dest[j].getC()) > 0; --j) {
                    AnsjArrays.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int destLow = low;
        int destHigh = high;
        int mid = (low += off) + (high += off) >>> 1;
        AnsjArrays.mergeSort(dest, src, low, mid, -off);
        AnsjArrays.mergeSort(dest, src, mid, high, -off);
        if (src[mid - 1].compareTo(src[mid].getC()) <= 0) {
            System.arraycopy(src, low, dest, destLow, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = destLow; i < destHigh; ++i) {
            dest[i] = q >= high || p < mid && src[p].compareTo(src[q].getC()) <= 0 ? src[p++] : src[q++];
        }
    }

    private static void swap(WoodInterface[] x, int a, int b) {
        WoodInterface t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    public static <T> T[] copyOfRange(T[] original, int from, int to) {
        return AnsjArrays.copyOfRange(original, from, to, original.getClass());
    }

    public static <T, U> T[] copyOfRange(U[] original, int from, int to, Class<? extends T[]> newType) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }
}

