/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.volume.Volume;
import org.apache.accumulo.core.volume.VolumeConfiguration;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.ServerUtil;
import org.apache.accumulo.server.fs.VolumeUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class ServerConstants {
    public static final String VERSION_DIR = "version";
    public static final String INSTANCE_ID_DIR = "instance_id";
    public static final int CRYPTO_CHANGES = 9;
    public static final int SHORTEN_RFILE_KEYS = 8;
    public static final int DATA_VERSION = 9;
    public static final Set<Integer> CAN_RUN = ImmutableSet.of((Object)8, (Object)9);
    public static final Set<Integer> NEEDS_UPGRADE = Sets.difference(CAN_RUN, (Set)ImmutableSet.of((Object)9));
    private static String[] baseUris = null;
    private static List<Pair<Path, Path>> replacementsList = null;
    public static final String TABLE_DIR = "tables";
    public static final String RECOVERY_DIR = "recovery";
    public static final String WAL_DIR = "wal";

    public static String[] getBaseUris(ServerContext context) {
        return ServerConstants.getBaseUris(context.getConfiguration(), context.getHadoopConf());
    }

    public static synchronized String[] getBaseUris(AccumuloConfiguration conf, Configuration hadoopConf) {
        if (baseUris == null) {
            baseUris = ServerConstants.checkBaseUris(conf, hadoopConf, VolumeConfiguration.getVolumeUris((AccumuloConfiguration)conf, (Configuration)hadoopConf), false);
        }
        return baseUris;
    }

    public static String[] checkBaseUris(AccumuloConfiguration conf, Configuration hadoopConf, String[] configuredBaseDirs, boolean ignore) {
        String firstDir = null;
        String firstIid = null;
        Integer firstVersion = null;
        ArrayList<String> baseDirsList = new ArrayList<String>();
        for (String baseDir : configuredBaseDirs) {
            int currentVersion;
            String currentIid;
            Path path = new Path(baseDir, INSTANCE_ID_DIR);
            try {
                currentIid = ZooUtil.getInstanceIDFromHdfs((Path)path, (AccumuloConfiguration)conf, (Configuration)hadoopConf);
                Path vpath = new Path(baseDir, VERSION_DIR);
                currentVersion = ServerUtil.getAccumuloPersistentVersion(vpath.getFileSystem(hadoopConf), vpath);
            }
            catch (Exception e) {
                if (ignore) continue;
                throw new IllegalArgumentException("Accumulo volume " + path + " not initialized", e);
            }
            if (firstIid == null) {
                firstIid = currentIid;
                firstDir = baseDir;
                firstVersion = currentVersion;
            } else {
                if (!currentIid.equals(firstIid)) {
                    throw new IllegalArgumentException("Configuration " + Property.INSTANCE_VOLUMES.getKey() + " contains paths that have different instance ids " + baseDir + " has " + currentIid + " and " + firstDir + " has " + firstIid);
                }
                if (currentVersion != firstVersion) {
                    throw new IllegalArgumentException("Configuration " + Property.INSTANCE_VOLUMES.getKey() + " contains paths that have different versions " + baseDir + " has " + currentVersion + " and " + firstDir + " has " + firstVersion);
                }
            }
            baseDirsList.add(baseDir);
        }
        if (baseDirsList.size() == 0) {
            throw new RuntimeException("None of the configured paths are initialized.");
        }
        return baseDirsList.toArray(new String[baseDirsList.size()]);
    }

    public static String[] getTablesDirs(ServerContext context) {
        return VolumeConfiguration.prefix((String[])ServerConstants.getBaseUris(context), (String)TABLE_DIR);
    }

    public static String[] getRecoveryDirs(ServerContext context) {
        return VolumeConfiguration.prefix((String[])ServerConstants.getBaseUris(context), (String)RECOVERY_DIR);
    }

    public static Path getInstanceIdLocation(Volume v) {
        return v.prefixChild(INSTANCE_ID_DIR);
    }

    public static Path getDataVersionLocation(Volume v) {
        return v.prefixChild(VERSION_DIR);
    }

    /*
     * WARNING - void declaration
     */
    public static synchronized List<Pair<Path, Path>> getVolumeReplacements(AccumuloConfiguration conf, Configuration hadoopConf) {
        if (replacementsList == null) {
            void var7_9;
            String replacements = conf.get(Property.INSTANCE_VOLUMES_REPLACEMENTS);
            if ((replacements = replacements.trim()).isEmpty()) {
                return Collections.emptyList();
            }
            String[] pairs = replacements.split(",");
            ArrayList<Pair<Path, Path>> ret = new ArrayList<Pair<Path, Path>>();
            String[] stringArray = pairs;
            int n = stringArray.length;
            boolean bl = false;
            while (var7_9 < n) {
                Path p2;
                Path p1;
                String pair = stringArray[var7_9];
                String[] uris = pair.split("\\s+");
                if (uris.length != 2) {
                    throw new IllegalArgumentException(Property.INSTANCE_VOLUMES_REPLACEMENTS.getKey() + " contains malformed pair " + pair);
                }
                try {
                    p1 = new Path(new URI(VolumeUtil.removeTrailingSlash(uris[0].trim())));
                    if (p1.toUri().getScheme() == null) {
                        throw new IllegalArgumentException(Property.INSTANCE_VOLUMES_REPLACEMENTS.getKey() + " contains " + uris[0] + " which is not fully qualified");
                    }
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(Property.INSTANCE_VOLUMES_REPLACEMENTS.getKey() + " contains " + uris[0] + " which has a syntax error", e);
                }
                try {
                    p2 = new Path(new URI(VolumeUtil.removeTrailingSlash(uris[1].trim())));
                    if (p2.toUri().getScheme() == null) {
                        throw new IllegalArgumentException(Property.INSTANCE_VOLUMES_REPLACEMENTS.getKey() + " contains " + uris[1] + " which is not fully qualified");
                    }
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(Property.INSTANCE_VOLUMES_REPLACEMENTS.getKey() + " contains " + uris[1] + " which has a syntax error", e);
                }
                ret.add((Pair<Path, Path>)new Pair((Object)p1, (Object)p2));
                ++var7_9;
            }
            HashSet<Path> baseDirs = new HashSet<Path>();
            for (String baseDir : ServerConstants.getBaseUris(conf, hadoopConf)) {
                baseDirs.add(new Path(baseDir));
            }
            for (Pair pair : ret) {
                if (baseDirs.contains(pair.getSecond())) continue;
                throw new IllegalArgumentException(Property.INSTANCE_VOLUMES_REPLACEMENTS.getKey() + " contains " + pair.getSecond() + " which is not a configured volume");
            }
            replacementsList = ret;
        }
        return replacementsList;
    }
}

