/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.security;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Map;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.clientImpl.Credentials;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.server.security.SecurityUtil;

public final class SystemCredentials
extends Credentials {
    private static final String SYSTEM_PRINCIPAL = "!SYSTEM";
    private final TCredentials AS_THRIFT;

    public SystemCredentials(String instanceID, String principal, AuthenticationToken token) {
        super(principal, token);
        this.AS_THRIFT = super.toThrift(instanceID);
    }

    public static SystemCredentials get(String instanceID, SiteConfiguration siteConfig) {
        String principal = SYSTEM_PRINCIPAL;
        if (siteConfig.getBoolean(Property.INSTANCE_RPC_SASL_ENABLED)) {
            principal = SecurityUtil.getServerPrincipal(siteConfig.get(Property.GENERAL_KERBEROS_PRINCIPAL));
        }
        return new SystemCredentials(instanceID, principal, (AuthenticationToken)SystemToken.get(instanceID, siteConfig));
    }

    public TCredentials toThrift(String instanceID) {
        if (!this.AS_THRIFT.getInstanceId().equals(instanceID)) {
            throw new IllegalArgumentException("Unexpected instance used for " + SystemCredentials.class.getSimpleName() + ": " + instanceID);
        }
        return this.AS_THRIFT;
    }

    public static final class SystemToken
    extends PasswordToken {
        private static final Integer INTERNAL_WIRE_VERSION = 4;

        public SystemToken() {
        }

        private SystemToken(byte[] systemPassword) {
            super(systemPassword);
        }

        private static SystemToken get(String instanceID, SiteConfiguration siteConfig) {
            MessageDigest md;
            byte[] instanceIdBytes = instanceID.getBytes(StandardCharsets.UTF_8);
            try {
                md = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Failed to compute configuration checksum", e);
            }
            md.update(INTERNAL_WIRE_VERSION.toString().getBytes(StandardCharsets.UTF_8));
            md.update(instanceIdBytes);
            for (Map.Entry entry : siteConfig) {
                if (!((String)entry.getKey()).startsWith(Property.INSTANCE_PREFIX.toString())) continue;
                md.update(((String)entry.getKey()).getBytes(StandardCharsets.UTF_8));
                md.update(((String)entry.getValue()).getBytes(StandardCharsets.UTF_8));
            }
            byte[] confChecksum = md.digest();
            int wireVersion = INTERNAL_WIRE_VERSION;
            ByteArrayOutputStream bytes = new ByteArrayOutputStream(12 + instanceIdBytes.length + confChecksum.length);
            DataOutputStream out = new DataOutputStream(bytes);
            try {
                out.write(wireVersion * -1);
                out.write(instanceIdBytes.length);
                out.write(instanceIdBytes);
                out.write(confChecksum.length);
                out.write(confChecksum);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return new SystemToken(Base64.getEncoder().encode(bytes.toByteArray()));
        }
    }
}

