/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.security.handler;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.security.handler.Authenticator;
import org.apache.accumulo.server.security.handler.Authorizor;
import org.apache.accumulo.server.security.handler.KerberosAuthenticator;
import org.apache.accumulo.server.security.handler.KerberosPermissionHandler;
import org.apache.accumulo.server.security.handler.PermissionHandler;
import org.apache.accumulo.server.security.handler.ZKAuthorizor;

public class KerberosAuthorizor
implements Authorizor {
    private final ZKAuthorizor zkAuthorizor = new ZKAuthorizor();

    @Override
    public void initialize(ServerContext context) {
        this.zkAuthorizor.initialize(context);
    }

    @Override
    public boolean validSecurityHandlers(Authenticator auth, PermissionHandler pm) {
        return auth instanceof KerberosAuthenticator && pm instanceof KerberosPermissionHandler;
    }

    @Override
    public void initializeSecurity(TCredentials credentials, String rootuser) throws AccumuloSecurityException {
        this.zkAuthorizor.initializeSecurity(credentials, Base64.getEncoder().encodeToString(rootuser.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public void changeAuthorizations(String user, Authorizations authorizations) throws AccumuloSecurityException {
        this.zkAuthorizor.changeAuthorizations(Base64.getEncoder().encodeToString(user.getBytes(StandardCharsets.UTF_8)), authorizations);
    }

    @Override
    public Authorizations getCachedUserAuthorizations(String user) {
        return this.zkAuthorizor.getCachedUserAuthorizations(Base64.getEncoder().encodeToString(user.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public boolean isValidAuthorizations(String user, List<ByteBuffer> list) {
        return this.zkAuthorizor.isValidAuthorizations(Base64.getEncoder().encodeToString(user.getBytes(StandardCharsets.UTF_8)), list);
    }

    @Override
    public void initUser(String user) throws AccumuloSecurityException {
        this.zkAuthorizor.initUser(Base64.getEncoder().encodeToString(user.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public void dropUser(String user) throws AccumuloSecurityException {
        user = Base64.getEncoder().encodeToString(user.getBytes(StandardCharsets.UTF_8));
        this.zkAuthorizor.dropUser(user);
    }
}

