/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.Tables;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.cli.ServerUtilOpts;
import org.apache.accumulo.server.master.LiveTServerSet;
import org.apache.accumulo.server.master.state.MetaDataTableScanner;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.master.state.TabletLocationState;
import org.apache.accumulo.server.master.state.TabletState;
import org.apache.accumulo.server.master.state.ZooTabletStateStore;
import org.apache.htrace.TraceScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindOfflineTablets {
    private static final Logger log = LoggerFactory.getLogger(FindOfflineTablets.class);

    public static void main(String[] args) throws Exception {
        ServerUtilOpts opts = new ServerUtilOpts();
        try (TraceScope clientSpan = opts.parseArgsAndTrace(FindOfflineTablets.class.getName(), args, new Object[0]);){
            ServerContext context = opts.getServerContext();
            FindOfflineTablets.findOffline(context, null);
        }
    }

    static int findOffline(ServerContext context, String tableName) throws TableNotFoundException {
        final AtomicBoolean scanning = new AtomicBoolean(false);
        LiveTServerSet tservers = new LiveTServerSet(context, new LiveTServerSet.Listener(){

            @Override
            public void update(LiveTServerSet current, Set<TServerInstance> deleted, Set<TServerInstance> added) {
                if (!deleted.isEmpty() && scanning.get()) {
                    log.warn("Tablet servers deleted while scanning: {}", deleted);
                }
                if (!added.isEmpty() && scanning.get()) {
                    log.warn("Tablet servers added while scanning: {}", added);
                }
            }
        });
        tservers.startListeningForTabletServerChanges();
        scanning.set(true);
        Iterator zooScanner = new ZooTabletStateStore(context).iterator();
        int offline = 0;
        System.out.println("Scanning zookeeper");
        offline = FindOfflineTablets.checkTablets(context, zooScanner, tservers);
        if (offline > 0) {
            return offline;
        }
        if (RootTable.NAME.equals(tableName)) {
            return 0;
        }
        System.out.println("Scanning " + RootTable.NAME);
        MetaDataTableScanner rootScanner = new MetaDataTableScanner((ClientContext)context, MetadataSchema.TabletsSection.getRange(), RootTable.NAME);
        offline = FindOfflineTablets.checkTablets(context, rootScanner, tservers);
        if (offline > 0) {
            return offline;
        }
        if (MetadataTable.NAME.equals(tableName)) {
            return 0;
        }
        System.out.println("Scanning " + MetadataTable.NAME);
        Range range = MetadataSchema.TabletsSection.getRange();
        if (tableName != null) {
            TableId tableId = Tables.getTableId((ClientContext)context, (String)tableName);
            range = new KeyExtent(tableId, null, null).toMetadataRange();
        }
        try (MetaDataTableScanner metaScanner = new MetaDataTableScanner((ClientContext)context, range, MetadataTable.NAME);){
            int n = FindOfflineTablets.checkTablets(context, metaScanner, tservers);
            return n;
        }
    }

    private static int checkTablets(ServerContext context, Iterator<TabletLocationState> scanner, LiveTServerSet tservers) {
        int offline = 0;
        while (scanner.hasNext() && !System.out.checkError()) {
            TabletLocationState locationState = scanner.next();
            TabletState state = locationState.getState(tservers.getCurrentServers());
            if (state == null || state == TabletState.HOSTED || context.getTableManager().getTableState(locationState.extent.getTableId()) == TableState.OFFLINE) continue;
            System.out.println(locationState + " is " + (Object)((Object)state) + "  #walogs:" + locationState.walogs.size());
            ++offline;
        }
        return offline;
    }
}

