/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.server.cli.ServerUtilOpts;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.htrace.TraceScope;

public class LocalityCheck {
    public int run(String[] args) throws Exception {
        ServerUtilOpts opts = new ServerUtilOpts();
        try (TraceScope clientSpan = opts.parseArgsAndTrace(LocalityCheck.class.getName(), args, new Object[0]);){
            VolumeManager fs = opts.getServerContext().getVolumeManager();
            try (AccumuloClient accumuloClient = (AccumuloClient)Accumulo.newClient().from(opts.getClientProps()).build();){
                Scanner scanner = accumuloClient.createScanner(MetadataTable.NAME, Authorizations.EMPTY);
                scanner.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
                scanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
                scanner.setRange(MetadataSchema.TabletsSection.getRange());
                HashMap<String, Long> totalBlocks = new HashMap<String, Long>();
                HashMap<String, Long> localBlocks = new HashMap<String, Long>();
                ArrayList<String> files = new ArrayList<String>();
                for (Map.Entry entry : scanner) {
                    Key key = (Key)entry.getKey();
                    if (key.compareColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME) == 0) {
                        String location = ((Value)entry.getValue()).toString();
                        String[] parts = location.split(":");
                        String host = parts[0];
                        this.addBlocks(fs, host, files, totalBlocks, localBlocks);
                        files.clear();
                        continue;
                    }
                    if (key.compareColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME) != 0) continue;
                    files.add(fs.getFullPath(key).toString());
                }
                System.out.println(" Server         %local  total blocks");
                for (Map.Entry entry : totalBlocks.entrySet()) {
                    String host = (String)entry.getKey();
                    Long blocksForHost = (Long)entry.getValue();
                    System.out.println(String.format("%15s %5.1f %8d", host, (double)((Long)localBlocks.get(host)).longValue() * 100.0 / (double)blocksForHost.longValue(), blocksForHost));
                }
            }
            int n = 0;
            return n;
        }
    }

    private void addBlocks(VolumeManager fs, String host, ArrayList<String> files, Map<String, Long> totalBlocks, Map<String, Long> localBlocks) throws Exception {
        long allBlocks = 0L;
        long matchingBlocks = 0L;
        if (!totalBlocks.containsKey(host)) {
            totalBlocks.put(host, 0L);
            localBlocks.put(host, 0L);
        }
        for (String file : files) {
            BlockLocation[] fileBlockLocations;
            Path filePath = new Path(file);
            FileSystem ns = fs.getVolumeByPath(filePath).getFileSystem();
            FileStatus fileStatus = ns.getFileStatus(filePath);
            block1: for (BlockLocation blockLocation : fileBlockLocations = ns.getFileBlockLocations(fileStatus, 0L, fileStatus.getLen())) {
                ++allBlocks;
                for (String location : blockLocation.getHosts()) {
                    HostAndPort hap = HostAndPort.fromParts((String)location, (int)0);
                    if (!hap.getHost().equals(host)) continue;
                    ++matchingBlocks;
                    continue block1;
                }
            }
        }
        totalBlocks.put(host, allBlocks + totalBlocks.get(host));
        localBlocks.put(host, matchingBlocks + localBlocks.get(host));
    }

    public static void main(String[] args) throws Exception {
        LocalityCheck check = new LocalityCheck();
        System.exit(check.run(args));
    }
}

