/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import java.nio.charset.StandardCharsets;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.ServerContext;
import org.apache.zookeeper.KeeperException;

public class NamespacePropUtil {
    public static boolean setNamespaceProperty(ServerContext context, NamespaceId namespaceId, String property, String value) throws KeeperException, InterruptedException {
        if (!NamespacePropUtil.isPropertyValid(property, value)) {
            return false;
        }
        ZooReaderWriter zoo = context.getZooReaderWriter();
        String zkNamespacePath = NamespacePropUtil.getPath(context, namespaceId);
        zoo.putPersistentData(zkNamespacePath, new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
        String zPath = zkNamespacePath + "/" + property;
        zoo.putPersistentData(zPath, value.getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.OVERWRITE);
        return true;
    }

    public static boolean isPropertyValid(String property, String value) {
        Property p = Property.getPropertyByKey((String)property);
        return (p == null || p.getType().isValidFormat(value)) && Property.isValidTablePropertyKey((String)property);
    }

    public static void removeNamespaceProperty(ServerContext context, NamespaceId namespaceId, String property) throws InterruptedException, KeeperException {
        String zPath = NamespacePropUtil.getPath(context, namespaceId) + "/" + property;
        context.getZooReaderWriter().recursiveDelete(zPath, ZooUtil.NodeMissingPolicy.SKIP);
    }

    private static String getPath(ServerContext context, NamespaceId namespaceId) {
        return context.getZooKeeperRoot() + "/namespaces" + "/" + namespaceId + "/conf";
    }
}

