/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import java.nio.charset.StandardCharsets;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.ServerContext;
import org.apache.zookeeper.KeeperException;

public class TablePropUtil {
    public static boolean setTableProperty(ServerContext context, TableId tableId, String property, String value) throws KeeperException, InterruptedException {
        return TablePropUtil.setTableProperty(context.getZooReaderWriter(), context.getZooKeeperRoot(), tableId, property, value);
    }

    public static boolean setTableProperty(ZooReaderWriter zoo, String zkRoot, TableId tableId, String property, String value) throws KeeperException, InterruptedException {
        if (!TablePropUtil.isPropertyValid(property, value)) {
            return false;
        }
        String zkTablePath = TablePropUtil.getTablePath(zkRoot, tableId);
        zoo.putPersistentData(zkTablePath, new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
        String zPath = zkTablePath + "/" + property;
        zoo.putPersistentData(zPath, value.getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.OVERWRITE);
        return true;
    }

    public static boolean isPropertyValid(String property, String value) {
        Property p = Property.getPropertyByKey((String)property);
        return (p == null || p.getType().isValidFormat(value)) && Property.isValidTablePropertyKey((String)property);
    }

    public static void removeTableProperty(ServerContext context, TableId tableId, String property) throws InterruptedException, KeeperException {
        String zPath = TablePropUtil.getTablePath(context.getZooKeeperRoot(), tableId) + "/" + property;
        context.getZooReaderWriter().recursiveDelete(zPath, ZooUtil.NodeMissingPolicy.SKIP);
    }

    private static String getTablePath(String zkRoot, TableId tableId) {
        return zkRoot + "/tables" + "/" + tableId.canonical() + "/conf";
    }
}

