/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.tablet;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.replication.ReplicationConfigurationUtil;
import org.apache.accumulo.core.util.MapCounter;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.fate.zookeeper.ZooLock;
import org.apache.accumulo.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.replication.StatusUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.accumulo.server.util.MasterMetadataUtil;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.accumulo.server.util.ReplicationTableUtil;
import org.apache.accumulo.tserver.tablet.CommitSession;
import org.apache.accumulo.tserver.tablet.RootFiles;
import org.apache.accumulo.tserver.tablet.Tablet;
import org.apache.hadoop.fs.Path;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DatafileManager {
    private final Logger log = LoggerFactory.getLogger(DatafileManager.class);
    private final Map<FileRef, DataFileValue> datafileSizes = Collections.synchronizedMap(new TreeMap());
    private final Tablet tablet;
    private Long maxMergingMinorCompactionFileSize;
    private final Object bulkFileImportLock = new Object();
    private FileRef mergingMinorCompactionFile = null;
    private final Set<FileRef> filesToDeleteAfterScan = new HashSet<FileRef>();
    private final Map<Long, Set<FileRef>> scanFileReservations = new HashMap<Long, Set<FileRef>>();
    private final MapCounter<FileRef> fileScanReferenceCounts = new MapCounter();
    private long nextScanReservationId = 0L;
    private boolean reservationsBlocked = false;
    private final Set<FileRef> majorCompactingFiles = new HashSet<FileRef>();

    DatafileManager(Tablet tablet, SortedMap<FileRef, DataFileValue> datafileSizes) {
        for (Map.Entry<FileRef, DataFileValue> datafiles : datafileSizes.entrySet()) {
            this.datafileSizes.put(datafiles.getKey(), datafiles.getValue());
        }
        this.tablet = tablet;
    }

    static void rename(VolumeManager fs, Path src, Path dst) throws IOException {
        if (!fs.rename(src, dst)) {
            throw new IOException("Rename " + src + " to " + dst + " returned false ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Pair<Long, Map<FileRef, DataFileValue>> reserveFilesForScan() {
        Tablet tablet = this.tablet;
        synchronized (tablet) {
            while (this.reservationsBlocked) {
                try {
                    this.tablet.wait(50L);
                }
                catch (InterruptedException e) {
                    this.log.warn("{}", (Object)e.getMessage(), (Object)e);
                }
            }
            HashSet<FileRef> absFilePaths = new HashSet<FileRef>(this.datafileSizes.keySet());
            long rid = this.nextScanReservationId++;
            this.scanFileReservations.put(rid, absFilePaths);
            HashMap<FileRef, DataFileValue> ret = new HashMap<FileRef, DataFileValue>();
            for (FileRef path : absFilePaths) {
                this.fileScanReferenceCounts.increment((Object)path, 1L);
                ret.put(path, this.datafileSizes.get(path));
            }
            return new Pair((Object)rid, ret);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void returnFilesForScan(Long reservationId) {
        HashSet<FileRef> filesToDelete = new HashSet<FileRef>();
        Tablet tablet = this.tablet;
        synchronized (tablet) {
            Set<FileRef> absFilePaths = this.scanFileReservations.remove(reservationId);
            if (absFilePaths == null) {
                throw new IllegalArgumentException("Unknown scan reservation id " + reservationId);
            }
            boolean notify = false;
            for (FileRef path : absFilePaths) {
                long refCount = this.fileScanReferenceCounts.decrement((Object)path, 1L);
                if (refCount == 0L) {
                    if (this.filesToDeleteAfterScan.remove(path)) {
                        filesToDelete.add(path);
                    }
                    notify = true;
                    continue;
                }
                if (refCount >= 0L) continue;
                throw new IllegalStateException("Scan ref count for " + path + " is " + refCount);
            }
            if (notify) {
                this.tablet.notifyAll();
            }
        }
        if (filesToDelete.size() > 0) {
            this.log.debug("Removing scan refs from metadata {} {}", (Object)this.tablet.getExtent(), filesToDelete);
            MetadataTableUtil.removeScanFiles((KeyExtent)this.tablet.getExtent(), filesToDelete, (ServerContext)this.tablet.getContext(), (ZooLock)this.tablet.getTabletServer().getLock());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFilesAfterScan(Set<FileRef> scanFiles) {
        if (scanFiles.size() == 0) {
            return;
        }
        HashSet<FileRef> filesToDelete = new HashSet<FileRef>();
        Tablet tablet = this.tablet;
        synchronized (tablet) {
            for (FileRef path : scanFiles) {
                if (this.fileScanReferenceCounts.get((Object)path) == 0L) {
                    filesToDelete.add(path);
                    continue;
                }
                this.filesToDeleteAfterScan.add(path);
            }
        }
        if (filesToDelete.size() > 0) {
            this.log.debug("Removing scan refs from metadata {} {}", (Object)this.tablet.getExtent(), filesToDelete);
            MetadataTableUtil.removeScanFiles((KeyExtent)this.tablet.getExtent(), filesToDelete, (ServerContext)this.tablet.getContext(), (ZooLock)this.tablet.getTabletServer().getLock());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeSet<FileRef> waitForScansToFinish(Set<FileRef> pathsToWaitFor, boolean blockNewScans, long maxWaitTime) {
        long startTime = System.currentTimeMillis();
        TreeSet<FileRef> inUse = new TreeSet<FileRef>();
        try (TraceScope waitForScans = Trace.startSpan((String)"waitForScans");){
            Tablet tablet = this.tablet;
            synchronized (tablet) {
                if (blockNewScans) {
                    if (this.reservationsBlocked) {
                        throw new IllegalStateException();
                    }
                    this.reservationsBlocked = true;
                }
                for (FileRef path : pathsToWaitFor) {
                    while (this.fileScanReferenceCounts.get((Object)path) > 0L && System.currentTimeMillis() - startTime < maxWaitTime) {
                        try {
                            this.tablet.wait(100L);
                        }
                        catch (InterruptedException e) {
                            this.log.warn("{}", (Object)e.getMessage(), (Object)e);
                        }
                    }
                }
                for (FileRef path : pathsToWaitFor) {
                    if (this.fileScanReferenceCounts.get((Object)path) <= 0L) continue;
                    inUse.add(path);
                }
                if (blockNewScans) {
                    this.reservationsBlocked = false;
                    this.tablet.notifyAll();
                }
            }
        }
        return inUse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importMapFiles(long tid, Map<FileRef, DataFileValue> pathsString, boolean setTime) throws IOException {
        String bulkDir = null;
        HashMap<FileRef, DataFileValue> paths = new HashMap<FileRef, DataFileValue>();
        for (Map.Entry<FileRef, DataFileValue> entry : pathsString.entrySet()) {
            paths.put(entry.getKey(), entry.getValue());
        }
        for (FileRef tpath : paths.keySet()) {
            boolean inTheRightDirectory = false;
            Path parent = tpath.path().getParent().getParent();
            for (String tablesDir : ServerConstants.getTablesDirs((ServerContext)this.tablet.getContext())) {
                if (!parent.equals((Object)new Path(tablesDir, this.tablet.getExtent().getTableId().canonical()))) continue;
                inTheRightDirectory = true;
                break;
            }
            if (!inTheRightDirectory) {
                throw new IOException("Data file " + tpath + " not in table dirs");
            }
            if (bulkDir == null) {
                bulkDir = tpath.path().getParent().toString();
                continue;
            }
            if (bulkDir.equals(tpath.path().getParent().toString())) continue;
            throw new IllegalArgumentException("bulk files in different dirs " + bulkDir + " " + tpath);
        }
        if (this.tablet.getExtent().isMeta()) {
            throw new IllegalArgumentException("Can not import files to a metadata tablet");
        }
        Iterator iterator = this.bulkFileImportLock;
        synchronized (iterator) {
            if (paths.size() > 0) {
                long bulkTime = Long.MIN_VALUE;
                if (setTime) {
                    for (DataFileValue dfv : paths.values()) {
                        long nextTime = this.tablet.getAndUpdateTime();
                        if (nextTime < bulkTime) {
                            throw new IllegalStateException("Time went backwards unexpectedly " + nextTime + " " + bulkTime);
                        }
                        bulkTime = nextTime;
                        dfv.setTime(bulkTime);
                    }
                }
                this.tablet.updatePersistedTime(bulkTime, paths, tid);
            }
        }
        iterator = this.tablet;
        synchronized (iterator) {
            for (Map.Entry tpath : paths.entrySet()) {
                if (this.datafileSizes.containsKey(tpath.getKey())) {
                    this.log.error("Adding file that is already in set {}", tpath.getKey());
                }
                this.datafileSizes.put((FileRef)tpath.getKey(), (DataFileValue)tpath.getValue());
            }
            this.tablet.getTabletResources().importedMapFiles();
            this.tablet.computeNumEntries();
        }
        for (Map.Entry entry : paths.entrySet()) {
            this.log.debug("TABLET_HIST {} import {} {}", new Object[]{this.tablet.getExtent(), entry.getKey(), entry.getValue()});
        }
    }

    FileRef reserveMergingMinorCompactionFile() {
        if (this.mergingMinorCompactionFile != null) {
            throw new IllegalStateException("Tried to reserve merging minor compaction file when already reserved  : " + this.mergingMinorCompactionFile);
        }
        if (this.tablet.getExtent().isRootTablet()) {
            return null;
        }
        int maxFiles = this.tablet.getTableConfiguration().getMaxFilesPerTablet();
        if (this.majorCompactingFiles.size() > 0 && this.datafileSizes.size() == maxFiles) {
            return null;
        }
        if (this.datafileSizes.size() >= maxFiles) {
            long maxFileSize = Long.MAX_VALUE;
            this.maxMergingMinorCompactionFileSize = ConfigurationTypeHelper.getFixedMemoryAsBytes((String)this.tablet.getTableConfiguration().get(Property.TABLE_MINC_MAX_MERGE_FILE_SIZE));
            if (this.maxMergingMinorCompactionFileSize > 0L) {
                maxFileSize = this.maxMergingMinorCompactionFileSize;
            }
            long min = maxFileSize;
            FileRef minName = null;
            for (Map.Entry<FileRef, DataFileValue> entry : this.datafileSizes.entrySet()) {
                if (entry.getValue().getSize() > min || this.majorCompactingFiles.contains(entry.getKey())) continue;
                min = entry.getValue().getSize();
                minName = entry.getKey();
            }
            if (minName == null) {
                return null;
            }
            this.mergingMinorCompactionFile = minName;
            return minName;
        }
        return null;
    }

    void unreserveMergingMinorCompactionFile(FileRef file) {
        if (file == null && this.mergingMinorCompactionFile != null || file != null && this.mergingMinorCompactionFile == null || file != null && this.mergingMinorCompactionFile != null && !file.equals((Object)this.mergingMinorCompactionFile)) {
            throw new IllegalStateException("Disagreement " + file + " " + this.mergingMinorCompactionFile);
        }
        this.mergingMinorCompactionFile = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bringMinorCompactionOnline(FileRef tmpDatafile, FileRef newDatafile, FileRef absMergeFile, DataFileValue dfv, CommitSession commitSession, long flushId) {
        long t2;
        long t1;
        ZooReaderWriter zoo = this.tablet.getContext().getZooReaderWriter();
        if (this.tablet.getExtent().isRootTablet()) {
            try {
                if (!zoo.isLockHeld(this.tablet.getTabletServer().getLock().getLockID())) {
                    throw new IllegalStateException();
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Can not bring major compaction online, lock not held", e);
            }
        }
        while (true) {
            try {
                if (dfv.getNumEntries() == 0L) {
                    this.tablet.getTabletServer().getFileSystem().deleteRecursively(tmpDatafile.path());
                    break;
                }
                if (this.tablet.getTabletServer().getFileSystem().exists(newDatafile.path())) {
                    this.log.warn("Target map file already exist {}", (Object)newDatafile);
                    this.tablet.getTabletServer().getFileSystem().deleteRecursively(newDatafile.path());
                }
                DatafileManager.rename(this.tablet.getTabletServer().getFileSystem(), tmpDatafile.path(), newDatafile.path());
            }
            catch (IOException ioe) {
                this.log.warn("Tablet " + this.tablet.getExtent() + " failed to rename " + newDatafile + " after MinC, will retry in 60 secs...", (Throwable)ioe);
                UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.MINUTES);
                continue;
            }
            break;
        }
        Set<FileRef> filesInUseByScans = Collections.emptySet();
        if (absMergeFile != null) {
            filesInUseByScans = Collections.singleton(absMergeFile);
        }
        if (absMergeFile != null) {
            MetadataTableUtil.addDeleteEntries((KeyExtent)this.tablet.getExtent(), Collections.singleton(absMergeFile), (ServerContext)this.tablet.getContext());
        }
        Set<String> unusedWalLogs = this.tablet.beginClearingUnusedLogs();
        boolean replicate = ReplicationConfigurationUtil.isEnabled((KeyExtent)this.tablet.getExtent(), (AccumuloConfiguration)this.tablet.getTableConfiguration());
        HashSet<String> logFileOnly = null;
        if (replicate) {
            logFileOnly = new HashSet<String>();
            for (String unusedWalLog : unusedWalLogs) {
                int index = unusedWalLog.indexOf(47);
                if (index == -1) {
                    this.log.warn("Could not find host component to strip from DFSLogger representation of WAL");
                } else {
                    unusedWalLog = unusedWalLog.substring(index + 1);
                }
                logFileOnly.add(unusedWalLog);
            }
        }
        try {
            this.tablet.updateTabletDataFile(commitSession.getMaxCommittedTime(), newDatafile, absMergeFile, dfv, unusedWalLogs, filesInUseByScans, flushId);
            if (replicate) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Recording that data has been ingested into {} using {}", (Object)this.tablet.getExtent(), logFileOnly);
                }
                for (String logFile : logFileOnly) {
                    ReplicationTableUtil.updateFiles((ClientContext)this.tablet.getContext(), (KeyExtent)this.tablet.getExtent(), (String)logFile, (Replication.Status)StatusUtil.openWithUnknownLength());
                }
            }
        }
        finally {
            this.tablet.finishClearingUnusedLogs();
        }
        while (true) {
            try {
                this.tablet.getTabletServer().minorCompactionFinished(this.tablet.getTabletMemory().getCommitSession(), commitSession.getWALogSeq() + 2L);
            }
            catch (IOException e) {
                this.log.error("Failed to write to write-ahead log " + e.getMessage() + " will retry", (Throwable)e);
                UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                continue;
            }
            break;
        }
        Tablet e = this.tablet;
        synchronized (e) {
            t1 = System.currentTimeMillis();
            if (this.datafileSizes.containsKey(newDatafile)) {
                this.log.error("Adding file that is already in set {}", (Object)newDatafile);
            }
            if (dfv.getNumEntries() > 0L) {
                this.datafileSizes.put(newDatafile, dfv);
            }
            if (absMergeFile != null) {
                this.datafileSizes.remove(absMergeFile);
            }
            this.unreserveMergingMinorCompactionFile(absMergeFile);
            this.tablet.flushComplete(flushId);
            t2 = System.currentTimeMillis();
        }
        this.removeFilesAfterScan(filesInUseByScans);
        if (absMergeFile != null) {
            this.log.debug("TABLET_HIST {} MinC [{},memory] -> {}", new Object[]{this.tablet.getExtent(), absMergeFile, newDatafile});
        } else {
            this.log.debug("TABLET_HIST {} MinC [memory] -> {}", (Object)this.tablet.getExtent(), (Object)newDatafile);
        }
        this.log.debug(String.format("MinC finish lock %.2f secs %s", (double)(t2 - t1) / 1000.0, this.tablet.getExtent().toString()));
        long splitSize = this.tablet.getTableConfiguration().getAsBytes(Property.TABLE_SPLIT_THRESHOLD);
        if (dfv.getSize() > splitSize) {
            this.log.debug(String.format("Minor Compaction wrote out file larger than split threshold. split threshold = %,d  file size = %,d", splitSize, dfv.getSize()));
        }
    }

    public void reserveMajorCompactingFiles(Collection<FileRef> files) {
        if (this.majorCompactingFiles.size() != 0) {
            throw new IllegalStateException("Major compacting files not empty " + this.majorCompactingFiles);
        }
        if (this.mergingMinorCompactionFile != null && files.contains(this.mergingMinorCompactionFile)) {
            throw new IllegalStateException("Major compaction tried to resrve file in use by minor compaction " + this.mergingMinorCompactionFile);
        }
        this.majorCompactingFiles.addAll(files);
    }

    public void clearMajorCompactingFile() {
        this.majorCompactingFiles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bringMajorCompactionOnline(Set<FileRef> oldDatafiles, FileRef tmpDatafile, FileRef newDatafile, Long compactionId, DataFileValue dfv) throws IOException {
        long t2;
        long t1;
        KeyExtent extent = this.tablet.getExtent();
        if (!extent.isRootTablet()) {
            if (this.tablet.getTabletServer().getFileSystem().exists(newDatafile.path())) {
                this.log.error("Target map file already exist " + newDatafile, (Throwable)new Exception());
                throw new IllegalStateException("Target map file already exist " + newDatafile);
            }
            DatafileManager.rename(this.tablet.getTabletServer().getFileSystem(), tmpDatafile.path(), newDatafile.path());
            if (dfv.getNumEntries() == 0L) {
                this.tablet.getTabletServer().getFileSystem().deleteRecursively(newDatafile.path());
            }
        }
        TServerInstance lastLocation = null;
        Tablet tablet = this.tablet;
        synchronized (tablet) {
            t1 = System.currentTimeMillis();
            ZooReaderWriter zoo = this.tablet.getContext().getZooReaderWriter();
            this.tablet.incrementDataSourceDeletions();
            if (extent.isRootTablet()) {
                this.waitForScansToFinish(oldDatafiles, true, Long.MAX_VALUE);
                try {
                    if (!zoo.isLockHeld(this.tablet.getTabletServer().getLock().getLockID())) {
                        throw new IllegalStateException();
                    }
                }
                catch (Exception e) {
                    throw new IllegalStateException("Can not bring major compaction online, lock not held", e);
                }
                RootFiles.replaceFiles((AccumuloConfiguration)this.tablet.getTableConfiguration(), this.tablet.getTabletServer().getFileSystem(), this.tablet.getLocation(), oldDatafiles, tmpDatafile, newDatafile);
            }
            for (FileRef oldDatafile : oldDatafiles) {
                if (!this.datafileSizes.containsKey(oldDatafile)) {
                    this.log.error("file does not exist in set {}", (Object)oldDatafile);
                }
                this.datafileSizes.remove(oldDatafile);
                this.majorCompactingFiles.remove(oldDatafile);
            }
            if (this.datafileSizes.containsKey(newDatafile)) {
                this.log.error("Adding file that is already in set {}", (Object)newDatafile);
            }
            if (dfv.getNumEntries() > 0L) {
                this.datafileSizes.put(newDatafile, dfv);
            }
            this.majorCompactingFiles.add(newDatafile);
            this.tablet.computeNumEntries();
            lastLocation = this.tablet.resetLastLocation();
            this.tablet.setLastCompactionID(compactionId);
            t2 = System.currentTimeMillis();
        }
        if (!extent.isRootTablet()) {
            TreeSet<FileRef> filesInUseByScans = this.waitForScansToFinish(oldDatafiles, false, 10000L);
            if (filesInUseByScans.size() > 0) {
                this.log.debug("Adding scan refs to metadata {} {}", (Object)extent, filesInUseByScans);
            }
            MasterMetadataUtil.replaceDatafiles((ServerContext)this.tablet.getContext(), (KeyExtent)extent, oldDatafiles, filesInUseByScans, (FileRef)newDatafile, (Long)compactionId, (DataFileValue)dfv, (String)this.tablet.getTabletServer().getClientAddressString(), (TServerInstance)lastLocation, (ZooLock)this.tablet.getTabletServer().getLock());
            this.removeFilesAfterScan(filesInUseByScans);
        }
        this.log.debug(String.format("MajC finish lock %.2f secs", (double)(t2 - t1) / 1000.0));
        this.log.debug("TABLET_HIST {} MajC  --> {}", oldDatafiles, (Object)newDatafile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<FileRef, DataFileValue> getDatafileSizes() {
        Tablet tablet = this.tablet;
        synchronized (tablet) {
            TreeMap<FileRef, DataFileValue> copy = new TreeMap<FileRef, DataFileValue>(this.datafileSizes);
            return Collections.unmodifiableSortedMap(copy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<FileRef> getFiles() {
        Tablet tablet = this.tablet;
        synchronized (tablet) {
            HashSet<FileRef> files = new HashSet<FileRef>(this.datafileSizes.keySet());
            return Collections.unmodifiableSet(files);
        }
    }

    public int getNumFiles() {
        return this.datafileSizes.size();
    }
}

