/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.tablet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.tabletserver.log.LogEntry;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeUtil;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.accumulo.tserver.tablet.RootFiles;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabletData {
    private static Logger log = LoggerFactory.getLogger(TabletData.class);
    private String time = null;
    private SortedMap<FileRef, DataFileValue> dataFiles = new TreeMap<FileRef, DataFileValue>();
    private List<LogEntry> logEntries = new ArrayList<LogEntry>();
    private HashSet<FileRef> scanFiles = new HashSet();
    private long flushID = -1L;
    private long compactID = -1L;
    private TServerInstance lastLocation = null;
    private Map<Long, List<FileRef>> bulkImported = new HashMap<Long, List<FileRef>>();
    private long splitTime = 0L;
    private String directory = null;

    public TabletData(KeyExtent extent, VolumeManager fs, Iterator<Map.Entry<Key, Value>> entries) {
        Text family = new Text();
        Text rowName = extent.getMetadataEntry();
        while (entries.hasNext()) {
            KeyExtent check;
            Map.Entry<Key, Value> entry = entries.next();
            Key key = entry.getKey();
            Value value = entry.getValue();
            key.getColumnFamily(family);
            if (key.compareRow(rowName) != 0) {
                log.info("Unexpected metadata table entry for {}: {}", (Object)extent, (Object)key.getRow());
                continue;
            }
            if (MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.hasColumns(entry.getKey())) {
                if (this.time != null) continue;
                this.time = value.toString();
                continue;
            }
            if (MetadataSchema.TabletsSection.DataFileColumnFamily.NAME.equals((Object)family)) {
                FileRef ref = new FileRef(fs, key);
                this.dataFiles.put(ref, new DataFileValue(entry.getValue().get()));
                continue;
            }
            if (MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.hasColumns(key)) {
                this.directory = value.toString();
                continue;
            }
            if (family.equals((Object)MetadataSchema.TabletsSection.LogColumnFamily.NAME)) {
                this.logEntries.add(LogEntry.fromKeyValue((Key)key, (Value)entry.getValue()));
                continue;
            }
            if (family.equals((Object)MetadataSchema.TabletsSection.ScanFileColumnFamily.NAME)) {
                this.scanFiles.add(new FileRef(fs, key));
                continue;
            }
            if (MetadataSchema.TabletsSection.ServerColumnFamily.FLUSH_COLUMN.hasColumns(key)) {
                this.flushID = Long.parseLong(value.toString());
                continue;
            }
            if (MetadataSchema.TabletsSection.ServerColumnFamily.COMPACT_COLUMN.hasColumns(key)) {
                this.compactID = Long.parseLong(entry.getValue().toString());
                continue;
            }
            if (family.equals((Object)MetadataSchema.TabletsSection.LastLocationColumnFamily.NAME)) {
                this.lastLocation = new TServerInstance(value, key.getColumnQualifier());
                continue;
            }
            if (family.equals((Object)MetadataSchema.TabletsSection.BulkFileColumnFamily.NAME)) {
                Long id = MetadataTableUtil.getBulkLoadTid((Value)value);
                this.bulkImported.computeIfAbsent(id, l -> new ArrayList()).add(new FileRef(fs, key));
                continue;
            }
            if (!MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.hasColumns(key) || (check = new KeyExtent(key.getRow(), value)).equals((Object)extent)) continue;
            throw new RuntimeException("Found bad entry for " + extent + ": " + check);
        }
        if (this.time == null && this.dataFiles.isEmpty() && extent.equals((Object)RootTable.OLD_EXTENT)) {
            this.time = "L-9223372036854775808";
        }
    }

    public TabletData(ServerContext context, VolumeManager fs, AccumuloConfiguration conf) throws IOException {
        this.directory = VolumeUtil.switchRootTableVolume((ServerContext)context, (String)MetadataTableUtil.getRootTabletDir((ServerContext)context));
        Path location = new Path(this.directory);
        FileStatus[] files = fs.listStatus(location);
        Collection<String> goodPaths = RootFiles.cleanupReplacement(fs, files, true);
        long rtime = Long.MIN_VALUE;
        for (String good : goodPaths) {
            Path path = new Path(good);
            String filename = path.getName();
            FileRef ref = new FileRef(location + "/" + filename, path);
            DataFileValue dfv = new DataFileValue(0L, 0L);
            this.dataFiles.put(ref, dfv);
            FileSystem ns = fs.getVolumeByPath(path).getFileSystem();
            long maxTime = -1L;
            try (FileSKVIterator reader = FileOperations.getInstance().newReaderBuilder().forFile(path.toString(), ns, ns.getConf(), context.getCryptoService()).withTableConfiguration(conf).seekToBeginning().build();){
                while (reader.hasTop()) {
                    maxTime = Math.max(maxTime, ((Key)reader.getTopKey()).getTimestamp());
                    reader.next();
                }
            }
            if (maxTime <= rtime) continue;
            this.time = "L" + maxTime;
            rtime = maxTime;
        }
        try {
            this.logEntries = MetadataTableUtil.getLogEntries((ServerContext)context, (KeyExtent)RootTable.EXTENT);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to read tablet log entries", ex);
        }
    }

    public TabletData(String tabletDirectory, SortedMap<FileRef, DataFileValue> highDatafileSizes, String time, long lastFlushID, long lastCompactID, TServerInstance lastLocation, Map<Long, List<FileRef>> bulkIngestedFiles) {
        this.directory = tabletDirectory;
        this.dataFiles = highDatafileSizes;
        this.time = time;
        this.flushID = lastFlushID;
        this.compactID = lastCompactID;
        this.lastLocation = lastLocation;
        this.bulkImported = bulkIngestedFiles;
        this.splitTime = System.currentTimeMillis();
    }

    public String getTime() {
        return this.time;
    }

    public SortedMap<FileRef, DataFileValue> getDataFiles() {
        return this.dataFiles;
    }

    public List<LogEntry> getLogEntries() {
        return this.logEntries;
    }

    public HashSet<FileRef> getScanFiles() {
        return this.scanFiles;
    }

    public long getFlushID() {
        return this.flushID;
    }

    public long getCompactID() {
        return this.compactID;
    }

    public TServerInstance getLastLocation() {
        return this.lastLocation;
    }

    public Map<Long, List<FileRef>> getBulkImported() {
        return this.bulkImported;
    }

    public String getDirectory() {
        return this.directory;
    }

    public long getSplitTime() {
        return this.splitTime;
    }
}

