/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory;

import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.arrow.memory.AllocationOutcome;
import org.apache.arrow.memory.OutOfMemoryException;
import org.apache.arrow.util.Preconditions;

@ThreadSafe
class Accountant
implements AutoCloseable {
    protected final Accountant parent;
    protected final long reservation;
    private final AtomicLong peakAllocation = new AtomicLong();
    private final AtomicLong allocationLimit = new AtomicLong();
    private final AtomicLong locallyHeldMemory = new AtomicLong();

    public Accountant(Accountant parent, long reservation, long maxAllocation) {
        AllocationOutcome outcome;
        Preconditions.checkArgument(reservation >= 0L, "The initial reservation size must be non-negative.");
        Preconditions.checkArgument(maxAllocation >= 0L, "The maximum allocation limit must be non-negative.");
        Preconditions.checkArgument(reservation <= maxAllocation, "The initial reservation size must be <= the maximum allocation.");
        Preconditions.checkArgument(reservation == 0L || parent != null, "The root accountant can't reserve memory.");
        this.parent = parent;
        this.reservation = reservation;
        this.allocationLimit.set(maxAllocation);
        if (reservation != 0L && !(outcome = parent.allocateBytes(reservation)).isOk()) {
            throw new OutOfMemoryException(String.format("Failure trying to allocate initial reservation for Allocator. Attempted to allocate %d bytes and received an outcome of %s.", reservation, outcome.name()));
        }
    }

    AllocationOutcome allocateBytes(long size) {
        AllocationOutcome outcome = this.allocate(size, true, false);
        if (!outcome.isOk()) {
            this.releaseBytes(size);
        }
        return outcome;
    }

    private void updatePeak() {
        long previousPeak;
        long currentMemory = this.locallyHeldMemory.get();
        while (currentMemory > (previousPeak = this.peakAllocation.get()) && !this.peakAllocation.compareAndSet(previousPeak, currentMemory)) {
        }
    }

    boolean forceAllocate(long size) {
        AllocationOutcome outcome = this.allocate(size, true, true);
        return outcome.isOk();
    }

    private AllocationOutcome allocate(long size, boolean incomingUpdatePeak, boolean forceAllocation) {
        AllocationOutcome finalOutcome;
        long newLocal = this.locallyHeldMemory.addAndGet(size);
        long beyondReservation = newLocal - this.reservation;
        boolean beyondLimit = newLocal > this.allocationLimit.get();
        boolean updatePeak = forceAllocation || incomingUpdatePeak && !beyondLimit;
        AllocationOutcome parentOutcome = AllocationOutcome.SUCCESS;
        if (beyondReservation > 0L && this.parent != null) {
            long parentRequest = Math.min(beyondReservation, size);
            parentOutcome = this.parent.allocate(parentRequest, updatePeak, forceAllocation);
        }
        AllocationOutcome allocationOutcome = beyondLimit ? AllocationOutcome.FAILED_LOCAL : (finalOutcome = parentOutcome.isOk() ? AllocationOutcome.SUCCESS : AllocationOutcome.FAILED_PARENT);
        if (updatePeak) {
            this.updatePeak();
        }
        return finalOutcome;
    }

    public void releaseBytes(long size) {
        long newSize = this.locallyHeldMemory.addAndGet(-size);
        Preconditions.checkArgument(newSize >= 0L, "Accounted size went negative.");
        long originalSize = newSize + size;
        if (originalSize > this.reservation && this.parent != null) {
            long possibleAmountToReleaseToParent = originalSize - this.reservation;
            long actualToReleaseToParent = Math.min(size, possibleAmountToReleaseToParent);
            this.parent.releaseBytes(actualToReleaseToParent);
        }
    }

    public boolean isOverLimit() {
        return this.getAllocatedMemory() > this.getLimit() || this.parent != null && this.parent.isOverLimit();
    }

    @Override
    public void close() {
        if (this.parent != null) {
            this.parent.releaseBytes(this.reservation);
        }
    }

    public long getLimit() {
        return this.allocationLimit.get();
    }

    public void setLimit(long newLimit) {
        this.allocationLimit.set(newLimit);
    }

    public long getAllocatedMemory() {
        return this.locallyHeldMemory.get();
    }

    public long getPeakMemoryAllocation() {
        return this.peakAllocation.get();
    }

    public long getHeadroom() {
        long localHeadroom = this.allocationLimit.get() - this.locallyHeldMemory.get();
        if (this.parent == null) {
            return localHeadroom;
        }
        long reservedHeadroom = Math.max(0L, this.reservation - this.locallyHeldMemory.get());
        return Math.min(localHeadroom, this.parent.getHeadroom() + reservedHeadroom);
    }
}

