/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.validator;

import java.util.ArrayList;
import java.util.List;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescription;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescriptionJava;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescriptionWSDL;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.description.validator.Validator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointInterfaceDescriptionValidator
extends Validator {
    EndpointInterfaceDescription epInterfaceDesc;
    EndpointInterfaceDescriptionJava epInterfaceDescJava;
    EndpointInterfaceDescriptionWSDL epInterfaceDescWSDL;
    private static final Log log = LogFactory.getLog(EndpointInterfaceDescriptionValidator.class);

    public EndpointInterfaceDescriptionValidator(EndpointInterfaceDescription toValidate) {
        this.epInterfaceDesc = toValidate;
        this.epInterfaceDescJava = (EndpointInterfaceDescriptionJava)((Object)this.epInterfaceDesc);
        this.epInterfaceDescWSDL = (EndpointInterfaceDescriptionWSDL)((Object)this.epInterfaceDesc);
    }

    @Override
    public boolean validate() {
        if (this.getValidationLevel() == Validator.ValidationLevel.OFF) {
            return true;
        }
        if (!this.validateSEIvsWSDLPortType()) {
            return false;
        }
        return this.validateSEIvsImplementation();
    }

    private boolean validateSEIvsWSDLPortType() {
        PortType portType = this.epInterfaceDescWSDL.getWSDLPortType();
        if (portType != null) {
            List wsdlOperationList = portType.getOperations();
            OperationDescription[] dispatchableOpDescArray = this.epInterfaceDesc.getDispatchableOperations();
            if (wsdlOperationList.size() != dispatchableOpDescArray.length) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("The number of operations in the WSDL portType does not match the number of methods in the SEI or Web service implementation class.  wsdl operations = [" + EndpointInterfaceDescriptionValidator.toString(wsdlOperationList) + "] dispatch operations = [" + EndpointInterfaceDescriptionValidator.toString(dispatchableOpDescArray) + "]"));
                }
                return true;
            }
            if (!this.checkOperationsMatchMethods(wsdlOperationList, dispatchableOpDescArray)) {
                this.addValidationFailure(this, "The operation names in the WSDL portType do not match the method names in the SEI or Web service implementation class.  wsdl operations = [" + EndpointInterfaceDescriptionValidator.toString(wsdlOperationList) + "] dispatch operations = [" + EndpointInterfaceDescriptionValidator.toString(dispatchableOpDescArray) + "]");
                return false;
            }
        }
        return true;
    }

    private boolean checkOperationsMatchMethods(List wsdlOperationList, OperationDescription[] opDescArray) {
        List<String> opNameList = this.createWSDLOperationNameList(wsdlOperationList);
        for (int i = 0; i < opDescArray.length; ++i) {
            OperationDescription opDesc = opDescArray[i];
            if (!opNameList.contains(opDesc.getOperationName())) {
                return false;
            }
            opNameList.remove(opDesc.getOperationName());
        }
        return true;
    }

    private List<String> createWSDLOperationNameList(List wsdlOperationList) {
        ArrayList<String> opNameList = new ArrayList<String>();
        for (Object obj : wsdlOperationList) {
            if (!(obj instanceof Operation)) continue;
            Operation operation = (Operation)obj;
            opNameList.add(operation.getName());
        }
        return opNameList;
    }

    private boolean validateSEIvsImplementation() {
        return true;
    }

    private static String toString(List wsdlOperationList) {
        String result = "";
        for (Object obj : wsdlOperationList) {
            if (!(obj instanceof Operation)) continue;
            Operation operation = (Operation)obj;
            result = result + operation.getName() + " ";
        }
        return result;
    }

    private static String toString(OperationDescription[] wsdlOpDescs) {
        String result = "";
        for (int i = 0; i < wsdlOpDescs.length; ++i) {
            result = result + wsdlOpDescs[i].getOperationName() + " ";
        }
        return result;
    }
}

