/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.tree;

import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import org.apache.calcite.linq4j.tree.DeclarationStatement;
import org.apache.calcite.linq4j.tree.Evaluator;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.ExpressionWriter;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.linq4j.tree.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockStatement
extends Statement {
    public final List<Statement> statements;
    private int hash;

    BlockStatement(List<Statement> statements, Type type) {
        super(ExpressionType.Block, type);
        assert (statements != null) : "statements should not be null";
        this.statements = statements;
        assert (this.distinctVariables(true));
    }

    private boolean distinctVariables(boolean fail) {
        HashSet<String> names = new HashSet<String>();
        for (Statement statement : this.statements) {
            String name;
            if (!(statement instanceof DeclarationStatement) || names.add(name = ((DeclarationStatement)statement).parameter.name)) continue;
            assert (!fail) : "duplicate variable " + name;
            return false;
        }
        return true;
    }

    @Override
    public BlockStatement accept(Visitor visitor) {
        visitor = visitor.preVisit(this);
        List<Statement> newStatements = Expressions.acceptStatements(this.statements, visitor);
        return visitor.visit(this, newStatements);
    }

    @Override
    void accept0(ExpressionWriter writer) {
        if (this.statements.isEmpty()) {
            writer.append("{}");
            return;
        }
        writer.begin("{\n");
        for (Statement node : this.statements) {
            node.accept(writer, 0, 0);
        }
        writer.end("}\n");
    }

    @Override
    public Object evaluate(Evaluator evaluator) {
        Object o = null;
        for (Statement statement : this.statements) {
            o = statement.evaluate(evaluator);
        }
        return o;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BlockStatement that = (BlockStatement)o;
        return this.statements.equals(that.statements);
    }

    @Override
    public int hashCode() {
        int result = this.hash;
        if (result == 0) {
            result = super.hashCode();
            if ((result = 31 * result + this.statements.hashCode()) == 0) {
                result = 1;
            }
            this.hash = result;
        }
        return result;
    }
}

