/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.tree;

import java.lang.reflect.Type;
import java.util.List;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.ExpressionWriter;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MemberDeclaration;
import org.apache.calcite.linq4j.tree.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewExpression
extends Expression {
    public final Type type;
    public final List<Expression> arguments;
    public final List<MemberDeclaration> memberDeclarations;
    private int hash;

    public NewExpression(Type type, List<Expression> arguments, List<MemberDeclaration> memberDeclarations) {
        super(ExpressionType.New, type);
        this.type = type;
        this.arguments = arguments;
        this.memberDeclarations = memberDeclarations;
    }

    @Override
    public Expression accept(Visitor visitor) {
        visitor = visitor.preVisit(this);
        List<Expression> arguments = Expressions.acceptExpressions(this.arguments, visitor);
        List<MemberDeclaration> memberDeclarations = Expressions.acceptMemberDeclarations(this.memberDeclarations, visitor);
        return visitor.visit(this, arguments, memberDeclarations);
    }

    @Override
    void accept(ExpressionWriter writer, int lprec, int rprec) {
        writer.append("new ").append(this.type).list("(\n", ",\n", ")", this.arguments);
        if (this.memberDeclarations != null) {
            writer.list("{\n", "", "}", this.memberDeclarations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NewExpression that = (NewExpression)o;
        if (this.arguments != null ? !this.arguments.equals(that.arguments) : that.arguments != null) {
            return false;
        }
        if (this.memberDeclarations != null ? !this.memberDeclarations.equals(that.memberDeclarations) : that.memberDeclarations != null) {
            return false;
        }
        return this.type.equals(that.type);
    }

    @Override
    public int hashCode() {
        int result = this.hash;
        if (result == 0) {
            result = super.hashCode();
            result = 31 * result + this.type.hashCode();
            result = 31 * result + (this.arguments != null ? this.arguments.hashCode() : 0);
            if ((result = 31 * result + (this.memberDeclarations != null ? this.memberDeclarations.hashCode() : 0)) == 0) {
                result = 1;
            }
            this.hash = result;
        }
        return result;
    }
}

