/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelConfiguration;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.main.BaseMainSupport;
import org.apache.camel.main.DefaultMainShutdownStrategy;
import org.apache.camel.main.MainBootstrapCloseable;
import org.apache.camel.main.MainDurationEventNotifier;
import org.apache.camel.main.MainLifecycleStrategy;
import org.apache.camel.main.MainListener;
import org.apache.camel.main.MainShutdownStrategy;
import org.apache.camel.spi.BootstrapCloseable;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MainSupport
extends BaseMainSupport {
    protected static final Logger LOG = LoggerFactory.getLogger(MainSupport.class);
    protected static final int UNINITIALIZED_EXIT_CODE = Integer.MIN_VALUE;
    protected static final int DEFAULT_EXIT_CODE = 0;
    protected final AtomicInteger exitCode = new AtomicInteger(Integer.MIN_VALUE);
    protected MainShutdownStrategy shutdownStrategy = new DefaultMainShutdownStrategy(this);
    protected volatile ProducerTemplate camelTemplate;
    private String appName = "Apache Camel (Main)";
    private int durationMaxIdleSeconds;
    private int durationMaxMessages;
    private long durationMaxSeconds;
    private int durationHitExitCode;
    private String durationMaxAction = "shutdown";

    @SafeVarargs
    protected MainSupport(Class<? extends CamelConfiguration> ... configurationClasses) {
        this();
        for (Class<? extends CamelConfiguration> clazz : configurationClasses) {
            this.configure().addConfiguration(clazz);
        }
    }

    protected MainSupport() {
    }

    protected void doInit() throws Exception {
        LOG.info("{} {} is starting", (Object)this.appName, (Object)this.helper.getVersion());
        super.doInit();
    }

    @Override
    protected void autoconfigure(CamelContext camelContext) throws Exception {
        super.autoconfigure(camelContext);
        this.shutdownStrategy.setExtraShutdownTimeout(this.configure().getExtraShutdownTimeout());
    }

    public void run() throws Exception {
        if (this.shutdownStrategy.isRunAllowed()) {
            this.init();
            this.internalBeforeStart();
            this.beforeStart();
            this.start();
            try {
                this.afterStart();
                this.waitUntilCompleted();
                this.internalBeforeStop();
                this.beforeStop();
                this.stop();
                this.afterStop();
            }
            catch (Exception e) {
                LOG.error("Failed: {}", (Object)e, (Object)e);
            }
            LOG.info("{} {} shutdown", (Object)this.appName, (Object)this.helper.getVersion());
        }
    }

    protected void beforeStart() throws Exception {
        for (MainListener listener : this.listeners) {
            listener.beforeStart(this);
        }
    }

    protected void afterStart() throws Exception {
        for (MainListener listener : this.listeners) {
            listener.afterStart(this);
        }
    }

    protected void internalBeforeStart() {
        this.durationMaxIdleSeconds = this.mainConfigurationProperties.getDurationMaxIdleSeconds();
        this.durationMaxMessages = this.mainConfigurationProperties.getDurationMaxMessages();
        this.durationMaxSeconds = this.mainConfigurationProperties.getDurationMaxSeconds();
        this.durationHitExitCode = this.mainConfigurationProperties.getDurationHitExitCode();
        this.durationMaxAction = this.mainConfigurationProperties.getDurationMaxAction();
        this.registerMainBootstrap();
    }

    protected void beforeStop() throws Exception {
        for (MainListener listener : this.listeners) {
            listener.beforeStop(this);
        }
    }

    protected void afterStop() throws Exception {
        for (MainListener listener : this.listeners) {
            listener.afterStop(this);
        }
    }

    private void internalBeforeStop() {
        try {
            if (this.camelTemplate != null) {
                ServiceHelper.stopService((Object)this.camelTemplate);
                this.camelTemplate = null;
            }
        }
        catch (Exception e) {
            LOG.debug("Error stopping camelTemplate due " + e.getMessage() + ". This exception is ignored.", (Throwable)e);
        }
    }

    public void completed() {
        this.shutdownStrategy.shutdown();
        this.exitCode.compareAndSet(Integer.MIN_VALUE, 0);
    }

    public Runnable getCompleteTask() {
        return this::completed;
    }

    protected void registerMainBootstrap() {
        CamelContext context = this.getCamelContext();
        if (context != null) {
            context.getCamelContextExtension().addBootstrap((BootstrapCloseable)new MainBootstrapCloseable());
        }
    }

    public int getExitCode() {
        return this.exitCode.get();
    }

    public boolean isTrace() {
        return this.mainConfigurationProperties.isTracing();
    }

    public void enableTrace() {
        this.mainConfigurationProperties.setTracing(true);
    }

    public void enableTraceStandby() {
        this.mainConfigurationProperties.setTracingStandby(true);
    }

    public MainShutdownStrategy getShutdownStrategy() {
        return this.shutdownStrategy;
    }

    public void setShutdownStrategy(MainShutdownStrategy shutdownStrategy) {
        this.shutdownStrategy = shutdownStrategy;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    protected void doStop() throws Exception {
        this.completed();
    }

    protected void doStart() throws Exception {
    }

    @Override
    protected void configureLifecycle(CamelContext camelContext) throws Exception {
        if (this.mainConfigurationProperties.getDurationMaxSeconds() > 0 && this.mainConfigurationProperties.isRoutesReloadRestartDuration() || this.mainConfigurationProperties.getDurationMaxMessages() > 0 || this.mainConfigurationProperties.getDurationMaxIdleSeconds() > 0) {
            MainDurationEventNotifier notifier = new MainDurationEventNotifier(camelContext, this.mainConfigurationProperties.getDurationMaxMessages(), this.mainConfigurationProperties.getDurationMaxIdleSeconds(), this.shutdownStrategy, true, this.mainConfigurationProperties.isRoutesReloadRestartDuration(), this.mainConfigurationProperties.getDurationMaxAction());
            ServiceHelper.startService((Object)((Object)notifier));
            camelContext.getManagementStrategy().addEventNotifier((EventNotifier)notifier);
        }
        camelContext.addLifecycleStrategy((LifecycleStrategy)new MainLifecycleStrategy(this.shutdownStrategy));
    }

    protected void waitUntilCompleted() {
        while (this.shutdownStrategy.isRunAllowed()) {
            try {
                int idle = this.durationMaxIdleSeconds;
                int max = this.durationMaxMessages;
                long sec = this.durationMaxSeconds;
                int exit = this.durationHitExitCode;
                if (sec > 0L) {
                    LOG.info("Waiting until complete: Duration max {} seconds", (Object)sec);
                    boolean zero = this.shutdownStrategy.await(sec, TimeUnit.SECONDS);
                    if (!zero && "stop".equalsIgnoreCase(this.durationMaxAction)) {
                        LOG.info("Duration max seconds triggering stopping all routes");
                        try {
                            this.camelContext.getRouteController().stopAllRoutes();
                        }
                        catch (Exception e) {
                            LOG.warn("Error during stopping all routes. This exception is ignored.", (Throwable)e);
                        }
                        continue;
                    }
                    LOG.info("Duration max seconds triggering shutdown of the JVM");
                    this.exitCode.compareAndSet(Integer.MIN_VALUE, exit);
                    this.shutdownStrategy.shutdown();
                    continue;
                }
                if (idle > 0 || max > 0) {
                    if (idle > 0 && max > 0) {
                        LOG.info("Waiting until complete: Duration idle {} seconds or max {} messages processed", (Object)idle, (Object)max);
                    } else if (idle > 0) {
                        LOG.info("Waiting until complete: Duration idle {} seconds", (Object)idle);
                    } else {
                        LOG.info("Waiting until complete: Duration max {} messages processed", (Object)max);
                    }
                    this.exitCode.compareAndSet(Integer.MIN_VALUE, exit);
                    this.shutdownStrategy.await();
                    this.shutdownStrategy.shutdown();
                    continue;
                }
                this.shutdownStrategy.await();
            }
            catch (InterruptedException e) {
                this.shutdownStrategy.shutdown();
                Thread.currentThread().interrupt();
            }
        }
    }

    protected abstract ProducerTemplate findOrCreateCamelTemplate();

    protected abstract CamelContext createCamelContext();

    public ProducerTemplate getCamelTemplate() throws Exception {
        if (this.camelTemplate == null) {
            this.camelTemplate = this.findOrCreateCamelTemplate();
        }
        return this.camelTemplate;
    }

    protected void initCamelContext() throws Exception {
        this.camelContext = this.createCamelContext();
        if (this.camelContext == null) {
            throw new IllegalStateException("Created CamelContext is null");
        }
        this.postProcessCamelContext(this.camelContext);
    }
}

