/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.Category;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.EndpointHelper;
import org.apache.camel.maven.packaging.PropertyConfigurerGenerator;
import org.apache.camel.maven.packaging.SupportLevelHelper;
import org.apache.camel.maven.packaging.generics.ClassUtil;
import org.apache.camel.maven.packaging.generics.GenericsUtil;
import org.apache.camel.spi.ApiMethod;
import org.apache.camel.spi.ApiParam;
import org.apache.camel.spi.ApiParams;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.tooling.model.ApiMethodModel;
import org.apache.camel.tooling.model.ApiModel;
import org.apache.camel.tooling.model.BaseOptionModel;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.camel.tooling.model.SupportLevel;
import org.apache.camel.tooling.util.JavadocHelper;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.camel.tooling.util.Strings;
import org.apache.camel.tooling.util.srcgen.GenericType;
import org.apache.camel.util.json.Jsoner;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ASTNode;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Javadoc;
import org.jboss.forge.roaster.model.JavaDoc;
import org.jboss.forge.roaster.model.JavaDocCapable;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.IndexView;

@Mojo(name="generate-endpoint-schema", threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class EndpointSchemaGeneratorMojo
extends AbstractGeneratorMojo {
    public static final DotName URI_ENDPOINT = DotName.createSimple((String)UriEndpoint.class.getName());
    public static final DotName COMPONENT = DotName.createSimple((String)Component.class.getName());
    public static final DotName API_PARAMS = DotName.createSimple((String)ApiParams.class.getName());
    private static final String HEADER_FILTER_STRATEGY_JAVADOC = "To use a custom HeaderFilterStrategy to filter header to and from Camel message.";
    @Parameter(defaultValue="${project.build.outputDirectory}")
    protected File classesDirectory;
    @Parameter(defaultValue="${project.basedir}/src/generated/java")
    protected File sourcesOutputDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File resourcesOutputDir;
    protected IndexView indexView;
    protected Map<String, String> resources = new HashMap<String, String>();
    protected List<Path> sourceRoots;
    protected Map<String, String> sources = new HashMap<String, String>();
    protected Map<String, JavaClassSource> parsed = new HashMap<String, JavaClassSource>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.classesDirectory == null) {
            this.classesDirectory = new File(this.project.getBuild().getOutputDirectory());
        }
        if (this.sourcesOutputDir == null) {
            this.sourcesOutputDir = new File(this.project.getBasedir(), "src/generated/java");
        }
        if (this.resourcesOutputDir == null) {
            this.resourcesOutputDir = new File(this.project.getBasedir(), "src/generated/resources");
        }
        if (!this.classesDirectory.isDirectory()) {
            return;
        }
        this.executeUriEndpoint();
    }

    private void executeUriEndpoint() throws MojoExecutionException, MojoFailureException {
        String scheme;
        UriEndpoint uriEndpoint;
        ArrayList<Class> classes = new ArrayList<Class>();
        for (AnnotationInstance ai : this.getIndex().getAnnotations(URI_ENDPOINT)) {
            Class classElement = this.loadClass(ai.target().asClass().name().toString());
            uriEndpoint = classElement.getAnnotation(UriEndpoint.class);
            if (uriEndpoint == null || Strings.isNullOrEmpty((String)(scheme = uriEndpoint.scheme()))) continue;
            classes.add(classElement);
        }
        classes.sort((c1, c2) -> {
            if (c1.isAssignableFrom((Class<?>)c2)) {
                return -1;
            }
            if (c2.isAssignableFrom((Class<?>)c1)) {
                return 1;
            }
            return c1.getName().compareTo(c2.getName());
        });
        HashMap<Class, ComponentModel> models = new HashMap<Class, ComponentModel>();
        for (Class classElement : classes) {
            uriEndpoint = classElement.getAnnotation(UriEndpoint.class);
            scheme = uriEndpoint.scheme();
            String extendsScheme = uriEndpoint.extendsScheme();
            String title = uriEndpoint.title();
            Category[] categories = uriEndpoint.category();
            String label = categories.length > 0 ? Arrays.stream(categories).map(Category::getValue).collect(Collectors.joining(",")) : uriEndpoint.label();
            this.validateSchemaName(scheme, classElement);
            String[] schemes = scheme.split(",");
            String[] titles = title.split(",");
            String[] extendsSchemes = extendsScheme.split(",");
            for (int i = 0; i < schemes.length; ++i) {
                UriEndpoint parentUriEndpoint;
                String aTitle;
                String alias = schemes[i];
                String extendsAlias = i < extendsSchemes.length ? extendsSchemes[i] : extendsSchemes[0];
                String string = aTitle = i < titles.length ? titles[i] : titles[0];
                if (EndpointSchemaGeneratorMojo.secureAlias(schemes[0], alias)) {
                    aTitle = aTitle + " (Secure)";
                }
                String aliasTitle = aTitle;
                ComponentModel parentData = null;
                Class superclass = classElement.getSuperclass();
                if (superclass != null && (parentData = (ComponentModel)models.get(superclass)) == null && (parentUriEndpoint = superclass.getAnnotation(UriEndpoint.class)) != null) {
                    String parentScheme = parentUriEndpoint.scheme().split(",")[0];
                    String superClassName = superclass.getName();
                    String packageName = superClassName.substring(0, superClassName.lastIndexOf(46));
                    String fileName = packageName.replace('.', '/') + "/" + parentScheme + ".json";
                    String json = this.loadResource(fileName);
                    parentData = JsonMapper.generateComponentModel((String)json);
                }
                ComponentModel model = this.writeJSonSchemeAndPropertyConfigurer(classElement, uriEndpoint, aliasTitle, alias, extendsAlias, label, schemes, parentData);
                models.put(classElement, model);
            }
        }
    }

    private void validateSchemaName(String schemaName, Class<?> classElement) {
        if (!schemaName.equals(schemaName.toLowerCase())) {
            this.getLog().warn((CharSequence)String.format("Mixed case schema name in '%s' with value '%s' has been deprecated. Please use lowercase only!", classElement.getName(), schemaName));
        }
    }

    protected ComponentModel writeJSonSchemeAndPropertyConfigurer(Class<?> classElement, UriEndpoint uriEndpoint, String title, String scheme, String extendsScheme, String label, String[] schemes, ComponentModel parentData) {
        ComponentModel componentModel = this.findComponentProperties(uriEndpoint, classElement, title, scheme, extendsScheme, label, schemes);
        Class<?> componentClassElement = this.loadClass(componentModel.getJavaType());
        String excludedComponentProperties = "";
        if (componentClassElement != null) {
            this.findComponentClassProperties(componentModel, componentClassElement, "", null, null);
            Metadata componentMetadata = componentClassElement.getAnnotation(Metadata.class);
            if (componentMetadata != null) {
                excludedComponentProperties = componentMetadata.excludeProperties();
            }
        }
        this.findClassProperties(componentModel, classElement, new HashSet<String>(), "", null, null, false);
        String excludedEndpointProperties = "";
        Metadata endpointMetadata = classElement.getAnnotation(Metadata.class);
        if (endpointMetadata != null) {
            excludedEndpointProperties = endpointMetadata.excludeProperties();
        }
        this.enhanceComponentModel(componentModel, parentData, excludedEndpointProperties, excludedComponentProperties);
        if (!"@@@JAVATYPE@@@".equals(componentModel.getJavaType())) {
            this.generateComponentConfigurer(uriEndpoint, scheme, schemes, componentModel, parentData);
        }
        if (componentModel.isApi()) {
            this.enhanceComponentModelWithApiModel(componentModel);
        }
        String json = JsonMapper.createParameterJsonSchema((ComponentModel)componentModel);
        String name = classElement.getName();
        String packageName = name.substring(0, name.lastIndexOf(46));
        String fileName = scheme + ".json";
        String file = packageName.replace('.', '/') + "/" + fileName;
        this.updateResource(this.resourcesOutputDir.toPath(), file, json);
        this.generateEndpointConfigurer(classElement, uriEndpoint, scheme, schemes, componentModel, parentData);
        return componentModel;
    }

    private void enhanceComponentModelWithApiModel(ComponentModel componentModel) {
        for (AnnotationInstance ai : this.getIndex().getAnnotations(API_PARAMS)) {
            String apiName;
            Class<?> classElement = this.loadClass(ai.target().asClass().name().toString());
            ApiParams apiParams = classElement.getAnnotation(ApiParams.class);
            if (apiParams == null || Strings.isNullOrEmpty((String)(apiName = apiParams.apiName()))) continue;
            UriParams uriParams = classElement.getAnnotation(UriParams.class);
            String extraPrefix = uriParams != null ? uriParams.prefix() : "";
            this.findClassProperties(componentModel, classElement, Collections.EMPTY_SET, extraPrefix, null, null, false);
        }
    }

    @Override
    protected boolean updateResource(Path dir, String file, String data) {
        this.resources.put(file, data);
        return super.updateResource(dir, file, data);
    }

    private String loadResource(String fileName) {
        String data;
        if (this.resources.containsKey(fileName)) {
            return this.resources.get(fileName);
        }
        try (InputStream is = this.getProjectClassLoader().getResourceAsStream(fileName);){
            if (is == null) {
                throw new FileNotFoundException("Resource: " + fileName);
            }
            data = PackageHelper.loadText((InputStream)is);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while loading " + fileName + ": " + e.toString(), e);
        }
        this.resources.put(fileName, data);
        return data;
    }

    private void enhanceComponentModel(ComponentModel componentModel, ComponentModel parentData, String excludedEndpointProperties, String excludedComponentProperties) {
        componentModel.getComponentOptions().removeIf(option -> this.filterOutOption(componentModel, (BaseOptionModel)option));
        componentModel.getComponentOptions().forEach(option -> this.fixDoc((BaseOptionModel)option, parentData != null ? parentData.getComponentOptions() : null));
        componentModel.getComponentOptions().sort(EndpointHelper.createGroupAndLabelComparator());
        componentModel.getEndpointOptions().removeIf(option -> this.filterOutOption(componentModel, (BaseOptionModel)option));
        componentModel.getEndpointOptions().forEach(option -> this.fixDoc((BaseOptionModel)option, parentData != null ? parentData.getEndpointOptions() : null));
        componentModel.getEndpointOptions().sort(EndpointHelper.createOverallComparator(componentModel.getSyntax()));
        if (parentData != null) {
            Set componentOptionNames = componentModel.getComponentOptions().stream().map(BaseOptionModel::getName).collect(Collectors.toSet());
            Set endpointOptionNames = componentModel.getEndpointOptions().stream().map(BaseOptionModel::getName).collect(Collectors.toSet());
            Collections.addAll(componentOptionNames, excludedComponentProperties.split(","));
            Collections.addAll(endpointOptionNames, excludedEndpointProperties.split(","));
            parentData.getComponentOptions().stream().filter(option -> !componentOptionNames.contains(option.getName())).forEach(option -> componentModel.getComponentOptions().add(option));
            parentData.getEndpointOptions().stream().filter(option -> !endpointOptionNames.contains(option.getName())).forEach(option -> componentModel.getEndpointOptions().add(option));
        }
    }

    private void fixDoc(BaseOptionModel option, List<? extends BaseOptionModel> parentOptions) {
        String doc = this.getDocumentationWithNotes(option);
        if (Strings.isNullOrEmpty((String)doc) && parentOptions != null) {
            doc = parentOptions.stream().filter(opt -> Objects.equals(opt.getName(), option.getName())).map(BaseOptionModel::getDescription).findFirst().orElse(null);
        }
        doc = JavadocHelper.sanitizeDescription((String)doc, (boolean)false);
        option.setDescription(doc);
        if (EndpointSchemaGeneratorMojo.isNullOrEmpty(doc)) {
            throw new IllegalStateException("Empty doc for option: " + option.getName() + ", parent options: " + (parentOptions != null ? Jsoner.serialize((Object)JsonMapper.asJsonObject(parentOptions)) : "<null>"));
        }
    }

    private boolean filterOutOption(ComponentModel component, BaseOptionModel option) {
        String label = option.getLabel();
        if (label != null) {
            return component.isConsumerOnly() && label.contains("producer") || component.isProducerOnly() && label.contains("consumer");
        }
        return false;
    }

    public String getDocumentationWithNotes(BaseOptionModel option) {
        StringBuilder sb = new StringBuilder();
        sb.append(option.getDescription());
        if (!Strings.isNullOrEmpty((String)option.getDefaultValueNote())) {
            if (sb.charAt(sb.length() - 1) != '.') {
                sb.append('.');
            }
            sb.append(" Default value notice: ").append(option.getDefaultValueNote());
        }
        if (!Strings.isNullOrEmpty((String)option.getDeprecationNote())) {
            if (sb.charAt(sb.length() - 1) != '.') {
                sb.append('.');
            }
            sb.append(" Deprecation note: ").append(option.getDeprecationNote());
        }
        return sb.toString();
    }

    private void generateComponentConfigurer(UriEndpoint uriEndpoint, String scheme, String[] schemes, ComponentModel componentModel, ComponentModel parentData) {
        List options;
        boolean hasSuper;
        String pfqn;
        if (!uriEndpoint.generateConfigurer()) {
            return;
        }
        if (schemes != null && !schemes[0].equals(scheme)) {
            return;
        }
        if (parentData != null && this.loadClass(componentModel.getJavaType()).getSuperclass() == this.loadClass(parentData.getJavaType())) {
            pfqn = parentData.getJavaType() + "Configurer";
            hasSuper = true;
        } else {
            pfqn = "org.apache.camel.support.component.PropertyConfigurerSupport";
            hasSuper = false;
            parentData = null;
        }
        String psn = pfqn.substring(pfqn.lastIndexOf(46) + 1);
        String fqComponentClassName = componentModel.getJavaType();
        String componentClassName = fqComponentClassName.substring(fqComponentClassName.lastIndexOf(46) + 1);
        String className = componentClassName + "Configurer";
        String packageName = fqComponentClassName.substring(0, fqComponentClassName.lastIndexOf(46));
        String fqClassName = packageName + "." + className;
        if (parentData != null) {
            Set parentOptionsNames = parentData.getComponentOptions().stream().map(BaseOptionModel::getName).collect(Collectors.toSet());
            options = componentModel.getComponentOptions().stream().filter(o -> !parentOptionsNames.contains(o.getName())).collect(Collectors.toList());
        } else {
            options = componentModel.getComponentOptions();
        }
        this.generatePropertyConfigurer(packageName, className, fqClassName, componentClassName, pfqn, psn, componentModel.getScheme() + "-component", hasSuper, true, options, componentModel);
    }

    private void generateEndpointConfigurer(Class<?> classElement, UriEndpoint uriEndpoint, String scheme, String[] schemes, ComponentModel componentModel, ComponentModel parentData) {
        List options;
        boolean hasSuper;
        String pfqn;
        if (!uriEndpoint.generateConfigurer()) {
            return;
        }
        if (schemes != null && !schemes[0].equals(scheme)) {
            return;
        }
        if (parentData != null && this.loadClass(componentModel.getJavaType()).getSuperclass() == this.loadClass(parentData.getJavaType())) {
            try {
                pfqn = classElement.getSuperclass().getName() + "Configurer";
                hasSuper = true;
            }
            catch (NoClassDefFoundError e) {
                pfqn = "org.apache.camel.support.component.PropertyConfigurerSupport";
                hasSuper = false;
                parentData = null;
            }
        } else {
            pfqn = "org.apache.camel.support.component.PropertyConfigurerSupport";
            hasSuper = false;
        }
        String psn = pfqn.substring(pfqn.lastIndexOf(46) + 1);
        String fqEndpointClassName = classElement.getName();
        String endpointClassName = fqEndpointClassName.substring(fqEndpointClassName.lastIndexOf(46) + 1);
        String className = endpointClassName + "Configurer";
        String packageName = fqEndpointClassName.substring(0, fqEndpointClassName.lastIndexOf(46));
        String fqClassName = packageName + "." + className;
        if (parentData != null) {
            Set parentOptionsNames = parentData.getEndpointParameterOptions().stream().map(BaseOptionModel::getName).collect(Collectors.toSet());
            options = componentModel.getEndpointParameterOptions().stream().filter(o -> !parentOptionsNames.contains(o.getName())).collect(Collectors.toList());
        } else {
            options = componentModel.getEndpointParameterOptions();
        }
        this.generatePropertyConfigurer(packageName, className, fqClassName, endpointClassName, pfqn, psn, componentModel.getScheme() + "-endpoint", hasSuper, false, options, componentModel);
    }

    protected ComponentModel findComponentProperties(UriEndpoint uriEndpoint, Class<?> endpointClassElement, String title, String scheme, String extendsScheme, String label, String[] schemes) {
        ComponentModel model = new ComponentModel();
        model.setScheme(scheme);
        model.setName(scheme);
        model.setExtendsScheme(extendsScheme);
        if (schemes != null && schemes.length > 1) {
            model.setAlternativeSchemes(String.join((CharSequence)",", schemes));
        }
        String syntax = scheme + ":" + Strings.after((String)uriEndpoint.syntax(), (String)":");
        if (!Strings.isNullOrEmpty((String)uriEndpoint.alternativeSyntax())) {
            String alternativeSyntax = scheme + ":" + Strings.after((String)uriEndpoint.alternativeSyntax(), (String)":");
            model.setAlternativeSyntax(alternativeSyntax);
        }
        model.setSyntax(syntax);
        model.setTitle(title);
        model.setLabel(label);
        model.setConsumerOnly(uriEndpoint.consumerOnly());
        model.setProducerOnly(uriEndpoint.producerOnly());
        model.setLenientProperties(uriEndpoint.lenientProperties());
        model.setAsync(this.loadClass("org.apache.camel.AsyncEndpoint").isAssignableFrom(endpointClassElement));
        model.setApi(this.loadClass("org.apache.camel.ApiEndpoint").isAssignableFrom(endpointClassElement));
        model.setApiSyntax(uriEndpoint.apiSyntax());
        String firstVersion = uriEndpoint.firstVersion();
        if (Strings.isNullOrEmpty((String)firstVersion) && endpointClassElement.getAnnotation(Metadata.class) != null) {
            firstVersion = endpointClassElement.getAnnotation(Metadata.class).firstVersion();
        }
        if (!Strings.isNullOrEmpty((String)firstVersion)) {
            model.setFirstVersion(firstVersion);
        }
        model.setDescription(this.project.getDescription());
        model.setGroupId(this.project.getGroupId());
        model.setArtifactId(this.project.getArtifactId());
        model.setVersion(this.project.getVersion());
        String level = this.project.getProperties().getProperty("supportLevel");
        boolean experimental = ClassUtil.hasAnnotation("org.apache.camel.Experimental", endpointClassElement);
        if (experimental) {
            model.setSupportLevel(SupportLevel.Experimental);
        } else if (level != null) {
            model.setSupportLevel(SupportLevel.safeValueOf((String)level));
        } else {
            model.setSupportLevel(SupportLevelHelper.defaultSupportLevel(model.getFirstVersion(), model.getVersion()));
        }
        for (AnnotationInstance ai : this.getIndex().getAnnotations(COMPONENT)) {
            String[] cschemes = ai.value().asString().split(",");
            if (!Arrays.asList(cschemes).contains(scheme) || ai.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            String name = ai.target().asClass().name().toString();
            model.setJavaType(name);
            break;
        }
        boolean deprecated = endpointClassElement.getAnnotation(Deprecated.class) != null || this.project.getName().contains("(deprecated)");
        model.setDeprecated(deprecated);
        String deprecationNote = null;
        if (endpointClassElement.getAnnotation(Metadata.class) != null) {
            deprecationNote = endpointClassElement.getAnnotation(Metadata.class).deprecationNote();
        }
        model.setDeprecationNote(deprecationNote);
        model.setDeprecatedSince(this.project.getProperties().getProperty("deprecatedSince"));
        if (model.getJavaType() == null) {
            throw new IllegalStateException("Could not find component java type");
        }
        String doc = this.getDocComment(endpointClassElement);
        if (doc != null && !Strings.isNullOrEmpty((String)(doc = JavadocHelper.sanitizeDescription((String)doc, (boolean)true)))) {
            model.setDescription(doc);
        }
        if ("Camel Components".equalsIgnoreCase(model.getDescription()) || Strings.isNullOrEmpty((String)model.getDescription())) {
            throw new IllegalStateException("Cannot find description to use for component: " + scheme + ". Add <description> to Maven pom.xml or javadoc to the endpoint: " + endpointClassElement);
        }
        return model;
    }

    protected void findComponentClassProperties(ComponentModel componentModel, Class<?> classElement, String prefix, String nestedTypeName, String nestedFieldName) {
        Class<?> orgClassElement = classElement;
        HashSet excludes = new HashSet();
        while (true) {
            boolean annotationBasedOptions;
            Metadata componentAnnotation;
            if ((componentAnnotation = classElement.getAnnotation(Metadata.class)) != null) {
                if (Objects.equals("verifiers", componentAnnotation.label())) {
                    componentModel.setVerifiers(componentAnnotation.enums());
                }
                Collections.addAll(excludes, componentAnnotation.excludeProperties().split(","));
            }
            List methods = Stream.of(classElement.getDeclaredMethods()).filter(method -> {
                boolean isSetter;
                Metadata metadata = method.getAnnotation(Metadata.class);
                String methodName = method.getName();
                if (metadata != null && metadata.skip()) {
                    return false;
                }
                if (method.isSynthetic() || !Modifier.isPublic(method.getModifiers())) {
                    return false;
                }
                boolean bl = isSetter = methodName.startsWith("set") && method.getParameters().length == 1 && method.getReturnType() == Void.TYPE;
                if (!isSetter) {
                    return false;
                }
                if ("setEndpointClass".equals(methodName) || "setCamelContext".equals(methodName) || "setEndpointHeaderFilterStrategy".equals(methodName) || "setApplicationContext".equals(methodName)) {
                    return false;
                }
                return !EndpointSchemaGeneratorMojo.isGroovyMetaClassProperty(method);
            }).collect(Collectors.toList());
            List fields = Stream.of(classElement.getDeclaredFields()).collect(Collectors.toList());
            boolean bl = annotationBasedOptions = fields.stream().anyMatch(f -> f.getAnnotation(Metadata.class) != null) || methods.stream().anyMatch(m -> m.getAnnotation(Metadata.class) != null);
            if (!methods.isEmpty() && !annotationBasedOptions) {
                this.getLog().warn((CharSequence)("Component class " + classElement.getName() + " has not been marked up with @Metadata for " + methods.size() + " options."));
            }
            for (Method method2 : methods) {
                Optional<ComponentModel.ComponentOptionModel> prev;
                boolean accept;
                String displayName;
                Field fieldElement;
                String methodName = method2.getName();
                Metadata metadata = method2.getAnnotation(Metadata.class);
                boolean deprecated = method2.getAnnotation(Deprecated.class) != null;
                String deprecationNote = null;
                if (metadata != null) {
                    deprecationNote = metadata.deprecationNote();
                }
                String fieldName = methodName.substring(3);
                fieldName = fieldName.substring(0, 1).toLowerCase() + fieldName.substring(1);
                try {
                    fieldElement = classElement.getDeclaredField(fieldName);
                }
                catch (NoSuchFieldException e) {
                    fieldElement = null;
                }
                if (fieldElement != null && metadata == null) {
                    metadata = fieldElement.getAnnotation(Metadata.class);
                }
                if (metadata != null && metadata.skip() || annotationBasedOptions && metadata == null) continue;
                if (fieldElement != null) {
                    Class<?> fieldTypeElement = fieldElement.getType();
                    String fieldTypeName = EndpointSchemaGeneratorMojo.getTypeName(GenericsUtil.resolveType(orgClassElement, fieldElement));
                    UriParams fieldParams = fieldTypeElement.getAnnotation(UriParams.class);
                    if (fieldParams != null) {
                        String nestedPrefix = prefix;
                        String extraPrefix = fieldParams.prefix();
                        if (!Strings.isNullOrEmpty((String)extraPrefix)) {
                            nestedPrefix = nestedPrefix + extraPrefix;
                        }
                        nestedTypeName = fieldTypeName;
                        nestedFieldName = fieldElement.getName();
                        this.findClassProperties(componentModel, fieldTypeElement, Collections.EMPTY_SET, nestedPrefix, nestedTypeName, nestedFieldName, true);
                        nestedTypeName = null;
                        nestedFieldName = null;
                    }
                }
                boolean required = metadata != null && metadata.required();
                String label = metadata != null ? metadata.label() : null;
                boolean secret = metadata != null && metadata.secret();
                boolean autowired = metadata != null && metadata.autowired();
                Object defaultValue = metadata != null ? metadata.defaultValue() : "";
                String defaultValueNote = null;
                String name = prefix + fieldName;
                String string = displayName = metadata != null ? metadata.displayName() : null;
                if (Strings.isNullOrEmpty((String)displayName)) {
                    displayName = Strings.asTitle((String)name);
                }
                Class<?> fieldType = method2.getParameters()[0].getType();
                String fieldTypeName = EndpointSchemaGeneratorMojo.getTypeName(GenericsUtil.resolveParameterTypes(orgClassElement, method2)[0]);
                String docComment = this.findJavaDoc(method2, fieldName, name, classElement, false);
                if (Strings.isNullOrEmpty((String)docComment)) {
                    String string2 = docComment = metadata != null ? metadata.description() : null;
                }
                if (Strings.isNullOrEmpty((String)docComment)) {
                    docComment = "setHeaderFilterStrategy".equals(methodName) ? HEADER_FILTER_STRATEGY_JAVADOC : "";
                }
                List<Object> enums = null;
                if (metadata != null && !Strings.isNullOrEmpty((String)metadata.enums())) {
                    String[] values = metadata.enums().split(",");
                    enums = Stream.of(values).map(String::trim).collect(Collectors.toList());
                } else if (fieldType.isEnum()) {
                    enums = new ArrayList();
                    for (Object val : fieldType.getEnumConstants()) {
                        String str = val.toString();
                        if (enums.contains(str)) continue;
                        enums.add(str);
                    }
                }
                boolean isDuration = false;
                if (metadata != null && !Strings.isNullOrEmpty((String)metadata.javaType())) {
                    String mjt = metadata.javaType();
                    if ("java.time.Duration".equals(mjt)) {
                        isDuration = true;
                    } else {
                        fieldTypeName = mjt;
                    }
                }
                String nestedType = null;
                String desc = fieldTypeName;
                if (desc.contains("<") && desc.contains(">")) {
                    int pos = (desc = Strings.between((String)desc, (String)"<", (String)">")).indexOf(60);
                    if (pos != -1) {
                        desc = desc.substring(0, pos);
                    }
                    if ((pos = desc.indexOf(44)) != -1) {
                        desc = desc.substring(pos + 1);
                    }
                    desc = desc.replace('$', '.');
                    if (!(desc = desc.trim()).isEmpty() && desc.indexOf(63) == -1 && !desc.contains(" extends ")) {
                        nestedType = desc;
                    }
                }
                defaultValue = EndpointSchemaGeneratorMojo.getDefaultValue(defaultValue, fieldTypeName, isDuration);
                String group = EndpointHelper.labelAsGroupName(label, componentModel.isConsumerOnly(), componentModel.isProducerOnly());
                boolean bl2 = accept = !excludes.contains(name);
                if (componentModel.isConsumerOnly() && "producer".equals(group)) {
                    accept = false;
                } else if (componentModel.isProducerOnly() && "consumer".equals(group)) {
                    accept = false;
                }
                if (accept && (prev = componentModel.getComponentOptions().stream().filter(opt -> name.equals(opt.getName())).findAny()).isPresent()) {
                    String prv = prev.get().getJavaType();
                    String cur = fieldTypeName;
                    if (prv.equals("java.lang.String") || prv.equals("java.lang.String[]") && cur.equals("java.util.Collection<java.lang.String>")) {
                        componentModel.getComponentOptions().remove(prev.get());
                    } else {
                        accept = false;
                    }
                }
                if (!accept) continue;
                ComponentModel.ComponentOptionModel option = new ComponentModel.ComponentOptionModel();
                option.setKind("property");
                option.setName(name);
                option.setDisplayName(displayName);
                option.setType(EndpointSchemaGeneratorMojo.getType(fieldTypeName, false, isDuration));
                option.setJavaType(fieldTypeName);
                option.setRequired(required);
                option.setDefaultValue(defaultValue);
                option.setDefaultValueNote(defaultValueNote);
                option.setDescription(docComment.trim());
                option.setDeprecated(deprecated);
                option.setDeprecationNote(deprecationNote);
                option.setSecret(secret);
                option.setAutowired(autowired);
                option.setGroup(group);
                option.setLabel(label);
                option.setEnums(enums);
                option.setNestedType(nestedType);
                option.setConfigurationClass(nestedTypeName);
                option.setConfigurationField(nestedFieldName);
                componentModel.addComponentOption(option);
            }
            Class<?> superclass = classElement.getSuperclass();
            if (superclass == null || superclass == Object.class) break;
            classElement = superclass;
        }
    }

    protected void findClassProperties(ComponentModel componentModel, Class<?> classElement, Set<String> excludes, String prefix, String nestedTypeName, String nestedFieldName, boolean componentOption) {
        Class<?> orgClassElement = classElement;
        excludes = new HashSet<String>(excludes);
        while (true) {
            Class<?> superclass;
            UriEndpoint uriEndpoint;
            String apiName = null;
            boolean apiOption = false;
            ApiParams apiParams = null;
            if (componentModel.isApi() && (apiParams = classElement.getAnnotation(ApiParams.class)) != null) {
                apiName = apiParams.apiName();
                apiOption = !Strings.isNullOrEmpty((String)apiName);
            }
            String excludedProperties = "";
            Metadata metadata = classElement.getAnnotation(Metadata.class);
            if (metadata != null) {
                excludedProperties = metadata.excludeProperties();
            }
            if ((uriEndpoint = classElement.getAnnotation(UriEndpoint.class)) != null) {
                Collections.addAll(excludes, excludedProperties.split(","));
            }
            for (Field fieldElement : classElement.getDeclaredFields()) {
                String displayName;
                UriParam param;
                metadata = fieldElement.getAnnotation(Metadata.class);
                if (metadata != null && metadata.skip()) continue;
                boolean deprecated = fieldElement.getAnnotation(Deprecated.class) != null;
                String deprecationNote = null;
                if (metadata != null) {
                    deprecationNote = metadata.deprecationNote();
                }
                Boolean secret = metadata != null ? Boolean.valueOf(metadata.secret()) : null;
                UriPath path = fieldElement.getAnnotation(UriPath.class);
                String fieldName = fieldElement.getName();
                if (!componentOption && path != null) {
                    String displayName2;
                    String name = prefix + (Strings.isNullOrEmpty((String)path.name()) ? fieldName : path.name());
                    if (excludes.contains(name)) continue;
                    Object defaultValue = path.defaultValue();
                    if ("".equals(defaultValue) && metadata != null) {
                        defaultValue = metadata.defaultValue();
                    }
                    String defaultValueNote = path.defaultValueNote();
                    boolean required = metadata != null && metadata.required();
                    String label = path.label();
                    if (Strings.isNullOrEmpty((String)label) && metadata != null) {
                        label = metadata.label();
                    }
                    if (Strings.isNullOrEmpty((String)(displayName2 = path.displayName()))) {
                        String string = displayName2 = metadata != null ? metadata.displayName() : null;
                    }
                    if (Strings.isNullOrEmpty((String)displayName2)) {
                        displayName2 = Strings.asTitle((String)name);
                    }
                    Class<?> fieldTypeElement = fieldElement.getType();
                    String fieldTypeName = EndpointSchemaGeneratorMojo.getTypeName(GenericsUtil.resolveType(orgClassElement, fieldElement));
                    String docComment = path.description();
                    if (Strings.isNullOrEmpty((String)docComment)) {
                        docComment = this.findJavaDoc(fieldElement, fieldName, name, classElement, false);
                    }
                    List<Object> enums = null;
                    if (!Strings.isNullOrEmpty((String)path.enums())) {
                        String[] values = path.enums().split(",");
                        enums = Stream.of(values).map(String::trim).collect(Collectors.toList());
                    } else if (fieldTypeElement.isEnum()) {
                        enums = new ArrayList();
                        for (Object val : fieldTypeElement.getEnumConstants()) {
                            String str = val.toString();
                            if (enums.contains(str)) continue;
                            enums.add(str);
                        }
                    }
                    boolean isDuration = false;
                    if (!Strings.isNullOrEmpty((String)path.javaType())) {
                        String mjt = path.javaType();
                        if ("java.time.Duration".equals(mjt)) {
                            isDuration = true;
                        } else {
                            fieldTypeName = mjt;
                        }
                    }
                    defaultValue = EndpointSchemaGeneratorMojo.getDefaultValue(defaultValue, fieldTypeName, isDuration);
                    boolean isSecret = secret != null && secret != false || path.secret();
                    boolean isAutowired = metadata != null && metadata.autowired();
                    String group = EndpointHelper.labelAsGroupName(label, componentModel.isConsumerOnly(), componentModel.isProducerOnly());
                    String nestedType = null;
                    String desc = fieldTypeName;
                    if (desc.contains("<") && desc.contains(">")) {
                        int pos = (desc = Strings.between((String)desc, (String)"<", (String)">")).indexOf(60);
                        if (pos != -1) {
                            desc = desc.substring(0, pos);
                        }
                        if ((pos = desc.indexOf(44)) != -1) {
                            desc = desc.substring(pos + 1);
                        }
                        desc = desc.replace('$', '.');
                        if (!(desc = desc.trim()).isEmpty() && desc.indexOf(63) == -1 && !desc.contains(" extends ")) {
                            nestedType = desc;
                        }
                    }
                    Object option = componentOption ? new ComponentModel.ComponentOptionModel() : new ComponentModel.EndpointOptionModel();
                    option.setName(name);
                    option.setKind("path");
                    option.setDisplayName(displayName2);
                    option.setType(EndpointSchemaGeneratorMojo.getType(fieldTypeName, false, isDuration));
                    option.setJavaType(fieldTypeName);
                    option.setRequired(required);
                    option.setDefaultValue(defaultValue);
                    option.setDefaultValueNote(defaultValueNote);
                    option.setDescription(docComment.trim());
                    option.setDeprecated(deprecated);
                    option.setDeprecationNote(deprecationNote);
                    option.setSecret(isSecret);
                    option.setAutowired(isAutowired);
                    option.setGroup(group);
                    option.setLabel(label);
                    option.setEnums(enums);
                    option.setNestedType(nestedType);
                    option.setConfigurationClass(nestedTypeName);
                    option.setConfigurationField(nestedFieldName);
                    if (componentModel.getEndpointOptions().stream().noneMatch(opt -> name.equals(opt.getName()))) {
                        componentModel.addEndpointOption((ComponentModel.EndpointOptionModel)option);
                    }
                }
                if ((param = fieldElement.getAnnotation(UriParam.class)) == null) continue;
                ApiParam apiParam = fieldElement.getAnnotation(ApiParam.class);
                fieldName = fieldElement.getName();
                String name = prefix + (Strings.isNullOrEmpty((String)param.name()) ? fieldName : param.name());
                if (excludes.contains(name)) continue;
                String paramOptionalPrefix = param.optionalPrefix();
                String paramPrefix = param.prefix();
                boolean multiValue = param.multiValue();
                Object defaultValue = param.defaultValue();
                if (EndpointSchemaGeneratorMojo.isNullOrEmpty(defaultValue) && metadata != null) {
                    defaultValue = metadata.defaultValue();
                }
                String defaultValueNote = param.defaultValueNote();
                boolean required = metadata != null && metadata.required();
                String label = param.label();
                if (Strings.isNullOrEmpty((String)label) && metadata != null) {
                    label = metadata.label();
                }
                if (Strings.isNullOrEmpty((String)(displayName = param.displayName()))) {
                    String string = displayName = metadata != null ? metadata.displayName() : null;
                }
                if (Strings.isNullOrEmpty((String)displayName)) {
                    displayName = Strings.asTitle((String)name);
                }
                Class<?> fieldTypeElement = fieldElement.getType();
                String fieldTypeName = EndpointSchemaGeneratorMojo.getTypeName(GenericsUtil.resolveType(orgClassElement, fieldElement));
                UriParams fieldParams = fieldTypeElement.getAnnotation(UriParams.class);
                if (fieldParams != null) {
                    String nestedPrefix = prefix;
                    String extraPrefix = fieldParams.prefix();
                    if (!Strings.isNullOrEmpty((String)extraPrefix)) {
                        nestedPrefix = nestedPrefix + extraPrefix;
                    }
                    nestedTypeName = fieldTypeName;
                    nestedFieldName = fieldElement.getName();
                    this.findClassProperties(componentModel, fieldTypeElement, excludes, nestedPrefix, nestedTypeName, nestedFieldName, componentOption);
                    nestedTypeName = null;
                    nestedFieldName = null;
                    continue;
                }
                String docComment = param.description();
                if (Strings.isNullOrEmpty((String)docComment)) {
                    docComment = this.findJavaDoc(fieldElement, fieldName, name, classElement, false);
                }
                if (Strings.isNullOrEmpty((String)docComment)) {
                    docComment = "";
                }
                List<Object> enums = null;
                if (!Strings.isNullOrEmpty((String)param.enums())) {
                    String[] values = param.enums().split(",");
                    enums = Stream.of(values).map(String::trim).collect(Collectors.toList());
                } else if (fieldTypeElement.isEnum()) {
                    enums = new ArrayList();
                    for (Object val : fieldTypeElement.getEnumConstants()) {
                        String str = val.toString();
                        if (enums.contains(str)) continue;
                        enums.add(str);
                    }
                }
                boolean isDuration = false;
                if (!Strings.isNullOrEmpty((String)param.javaType())) {
                    String jt = param.javaType();
                    if ("java.time.Duration".equals(jt)) {
                        isDuration = true;
                    } else {
                        fieldTypeName = param.javaType();
                    }
                }
                defaultValue = EndpointSchemaGeneratorMojo.getDefaultValue(defaultValue, fieldTypeName, isDuration);
                boolean isSecret = secret != null && secret != false || param.secret();
                boolean isAutowired = metadata != null && metadata.autowired();
                String group = EndpointHelper.labelAsGroupName(label, componentModel.isConsumerOnly(), componentModel.isProducerOnly());
                String nestedType = null;
                String desc = fieldTypeName;
                if (desc.contains("<") && desc.contains(">")) {
                    int pos = (desc = Strings.between((String)desc, (String)"<", (String)">")).indexOf(60);
                    if (pos != -1) {
                        desc = desc.substring(0, pos);
                    }
                    if ((pos = desc.indexOf(44)) != -1) {
                        desc = desc.substring(pos + 1);
                    }
                    desc = desc.replace('$', '.');
                    if (!(desc = desc.trim()).isEmpty() && desc.indexOf(63) == -1 && !desc.contains(" extends ")) {
                        nestedType = desc;
                    }
                }
                Object option = componentOption ? new ComponentModel.ComponentOptionModel() : (apiOption ? new ComponentModel.ApiOptionModel() : new ComponentModel.EndpointOptionModel());
                option.setName(name);
                option.setDisplayName(displayName);
                option.setType(EndpointSchemaGeneratorMojo.getType(fieldTypeName, false, isDuration));
                option.setJavaType(fieldTypeName);
                option.setRequired(required);
                option.setDefaultValue(defaultValue);
                option.setDefaultValueNote(defaultValueNote);
                option.setDescription(docComment.trim());
                option.setDeprecated(deprecated);
                option.setDeprecationNote(deprecationNote);
                option.setSecret(isSecret);
                option.setAutowired(isAutowired);
                option.setGroup(group);
                option.setLabel(label);
                option.setEnums(enums);
                option.setNestedType(nestedType);
                option.setConfigurationClass(nestedTypeName);
                option.setConfigurationField(nestedFieldName);
                option.setPrefix(paramPrefix);
                option.setOptionalPrefix(paramOptionalPrefix);
                option.setMultiValue(multiValue);
                if (componentOption) {
                    option.setKind("property");
                    componentModel.addComponentOption(option);
                    continue;
                }
                if (apiOption && apiParam != null) {
                    ApiModel api;
                    option.setKind("parameter");
                    String targetApiName = apiName;
                    Optional<ApiModel> op = componentModel.getApiOptions().stream().filter(o -> o.getName().equals(targetApiName)).findFirst();
                    if (!op.isPresent()) {
                        api = new ApiModel();
                        api.setName(apiName);
                        componentModel.getApiOptions().add(api);
                        if (apiParams != null) {
                            for (String string : apiParams.aliases()) {
                                api.addAlias(string);
                            }
                        }
                        if (apiParams != null) {
                            api.setDescription(apiParams.description());
                            api.setConsumerOnly(componentModel.isConsumerOnly() || apiParams.consumerOnly());
                            api.setProducerOnly(componentModel.isProducerOnly() || apiParams.producerOnly());
                        }
                    } else {
                        api = op.get();
                    }
                    for (ApiMethod apiMethod : apiParam.apiMethods()) {
                        ApiMethodModel apiMethod2 = null;
                        for (ApiMethodModel m : api.getMethods()) {
                            if (!m.getName().equals(apiMethod.methodName())) continue;
                            apiMethod2 = m;
                            break;
                        }
                        if (apiMethod2 == null) {
                            apiMethod2 = api.newMethod(apiMethod.methodName());
                        }
                        if (apiParams != null) {
                            for (ApiMethod m : apiParams.apiMethods()) {
                                if (!m.methodName().equals(apiMethod.methodName())) continue;
                                apiMethod2.setDescription(m.description());
                                for (String sig : m.signatures()) {
                                    apiMethod2.addSignature(sig);
                                }
                                break;
                            }
                        }
                        ComponentModel.ApiOptionModel copy = ((ComponentModel.ApiOptionModel)option).copy();
                        apiMethod2.addApiOptionModel(copy);
                        copy.setDescription(apiMethod.description());
                        group = EndpointHelper.labelAsGroupName(copy.getLabel(), api.isConsumerOnly(), api.isProducerOnly());
                        copy.setGroup(group);
                        copy.setOptional(apiParam.optional());
                    }
                    continue;
                }
                option.setKind("parameter");
                if (!componentModel.getEndpointOptions().stream().noneMatch(opt -> name.equals(opt.getName()))) continue;
                componentModel.addEndpointOption((ComponentModel.EndpointOptionModel)option);
            }
            if (apiOption || (superclass = classElement.getSuperclass()) == null) break;
            classElement = superclass;
        }
    }

    private static boolean isNullOrEmpty(Object value) {
        return value == null || "".equals(value) || "null".equals(value);
    }

    private static boolean secureAlias(String scheme, String alias) {
        if (scheme.equals(alias)) {
            return false;
        }
        return (scheme + "s").equals(alias);
    }

    private static boolean isGroovyMetaClassProperty(Method method) {
        String methodName = method.getName();
        if (!"setMetaClass".equals(methodName)) {
            return false;
        }
        return "groovy.lang.MetaClass".equals(method.getReturnType().getName());
    }

    protected void generatePropertyConfigurer(String pn, String cn, String fqn, String en, String pfqn, String psn, String scheme, boolean hasSuper, boolean component, Collection<? extends BaseOptionModel> options, ComponentModel model) {
        try (StringWriter w = new StringWriter();){
            boolean extended = model.isApi();
            PropertyConfigurerGenerator.generatePropertyConfigurer(pn, cn, en, pfqn, psn, hasSuper, component, extended, false, options, model, w);
            this.updateResource(this.sourcesOutputDir.toPath(), fqn.replace('.', '/') + ".java", ((Object)w).toString());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to generate source code file: " + fqn + ": " + e.getMessage(), e);
        }
        this.generateMetaInfConfigurer(scheme, fqn);
    }

    protected void generateMetaInfConfigurer(String name, String fqn) {
        try (StringWriter w = new StringWriter();){
            ((Writer)w).append("# Generated by camel build tools - do NOT edit this file!\n");
            ((Writer)w).append("class=").append(fqn).append("\n");
            this.updateResource(this.resourcesOutputDir.toPath(), "META-INF/services/org/apache/camel/configurer/" + name, ((Object)w).toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private IndexView getIndex() {
        if (this.indexView == null) {
            Path output = Paths.get(this.project.getBuild().getOutputDirectory(), new String[0]);
            try (InputStream is = Files.newInputStream(output.resolve("META-INF/jandex.idx"), new OpenOption[0]);){
                this.indexView = new IndexReader(is).read();
            }
            catch (IOException e) {
                throw new RuntimeException("IOException: " + e.getMessage(), e);
            }
        }
        return this.indexView;
    }

    private String findJavaDoc(AnnotatedElement member, String fieldName, String name, Class<?> classElement, boolean builderPattern) {
        String doc;
        JavaClassSource source;
        String doc2;
        Metadata md;
        String doc3;
        if (member instanceof Method) {
            try {
                Field field = classElement.getDeclaredField(fieldName);
                Metadata md2 = field.getAnnotation(Metadata.class);
                if (md2 != null && !Strings.isNullOrEmpty((String)(doc3 = md2.description()))) {
                    return doc3;
                }
            }
            catch (Exception field) {
                // empty catch block
            }
        }
        if (member != null && (md = member.getAnnotation(Metadata.class)) != null && !Strings.isNullOrEmpty((String)(doc2 = md.description()))) {
            return doc2;
        }
        try {
            source = this.javaClassSource(classElement.getName());
            if (source == null) {
                return "";
            }
        }
        catch (Exception e) {
            return "";
        }
        FieldSource field = source.getField(fieldName);
        if (field != null && !Strings.isNullOrEmpty((String)(doc3 = EndpointSchemaGeneratorMojo.getJavaDocText(this.loadJavaSource(classElement.getName()), field)))) {
            return doc3;
        }
        String setterName = "set" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        for (MethodSource setter : source.getMethods()) {
            String doc4;
            if (setter.getParameters().size() != 1 || !setter.getName().equals(setterName) || Strings.isNullOrEmpty((String)(doc4 = EndpointSchemaGeneratorMojo.getJavaDocText(this.loadJavaSource(classElement.getName()), setter)))) continue;
            return doc4;
        }
        String propName = Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        for (MethodSource getter : source.getMethods()) {
            if (!getter.getParameters().isEmpty() || !getter.getName().equals("get" + propName) && !getter.getName().equals("is" + propName) || Strings.isNullOrEmpty((String)(doc = EndpointSchemaGeneratorMojo.getJavaDocText(this.loadJavaSource(classElement.getName()), getter)))) continue;
            return doc;
        }
        if (builderPattern) {
            if (name != null && !name.equals(fieldName)) {
                for (MethodSource builder : source.getMethods()) {
                    if (builder.getParameters().size() != 1 || !builder.getName().equals(name) || Strings.isNullOrEmpty((String)(doc = EndpointSchemaGeneratorMojo.getJavaDocText(this.loadJavaSource(classElement.getName()), builder)))) continue;
                    return doc;
                }
                for (MethodSource builder : source.getMethods()) {
                    if (!builder.getParameters().isEmpty() || !builder.getName().equals(name) || Strings.isNullOrEmpty((String)(doc = EndpointSchemaGeneratorMojo.getJavaDocText(this.loadJavaSource(classElement.getName()), builder)))) continue;
                    return doc;
                }
            }
            for (MethodSource builder : source.getMethods()) {
                if (builder.getParameters().size() != 1 || !builder.getName().equals(fieldName) || Strings.isNullOrEmpty((String)(doc = EndpointSchemaGeneratorMojo.getJavaDocText(this.loadJavaSource(classElement.getName()), builder)))) continue;
                return doc;
            }
            for (MethodSource builder : source.getMethods()) {
                if (!builder.getParameters().isEmpty() || !builder.getName().equals(fieldName) || Strings.isNullOrEmpty((String)(doc = EndpointSchemaGeneratorMojo.getJavaDocText(this.loadJavaSource(classElement.getName()), builder)))) continue;
                return doc;
            }
        }
        return "";
    }

    static String getJavaDocText(String source, JavaDocCapable<?> member) {
        if (member == null) {
            return null;
        }
        JavaDoc javaDoc = member.getJavaDoc();
        Javadoc jd = (Javadoc)javaDoc.getInternal();
        if (source != null && !jd.tags().isEmpty()) {
            ASTNode n = (ASTNode)jd.tags().get(0);
            String txt = source.substring(n.getStartPosition(), n.getStartPosition() + n.getLength());
            return txt.replaceAll(" *\n *\\* *\n", "\n\n").replaceAll(" *\n *\\* +", "\n");
        }
        return null;
    }

    private String getDocComment(Class<?> classElement) {
        JavaClassSource source = this.javaClassSource(classElement.getName());
        return EndpointSchemaGeneratorMojo.getJavaDocText(this.loadJavaSource(classElement.getName()), source);
    }

    private JavaClassSource javaClassSource(String className) {
        return this.parsed.computeIfAbsent(className, this::doParseJavaClassSource);
    }

    private List<Path> getSourceRoots() {
        if (this.sourceRoots == null) {
            this.sourceRoots = this.project.getCompileSourceRoots().stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        }
        return this.sourceRoots;
    }

    private JavaClassSource doParseJavaClassSource(String className) {
        try {
            String source = this.loadJavaSource(className);
            if (source != null) {
                return (JavaClassSource)Roaster.parse((String)source);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to parse java class " + className, e);
        }
    }

    private String loadJavaSource(String className) {
        return this.sources.computeIfAbsent(className, this::doLoadJavaSource);
    }

    private String doLoadJavaSource(String className) {
        try {
            Path file = this.getSourceRoots().stream().map(d -> d.resolve(className.replace('.', '/') + ".java")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).findFirst().orElse(null);
            if (file == null && className.startsWith("org.apache.camel.support.")) {
                return null;
            }
            if (file == null) {
                throw new FileNotFoundException("Unable to find source for " + className);
            }
            return PackageHelper.loadText((Path)file);
        }
        catch (IOException e) {
            String classpath;
            try {
                classpath = this.project.getCompileClasspathElements().toString();
            }
            catch (Exception e2) {
                classpath = e2.toString();
            }
            throw new RuntimeException("Unable to load source for class " + className + " in folders " + this.getSourceRoots() + " (classpath: " + classpath + ")");
        }
    }

    private static String getTypeName(Type fieldType) {
        String fieldTypeName = new GenericType(fieldType).toString();
        fieldTypeName = fieldTypeName.replace('$', '.');
        return fieldTypeName;
    }

    public static String getType(String type, boolean enumType, boolean isDuration) {
        if (enumType) {
            return "enum";
        }
        if (isDuration) {
            return "duration";
        }
        if (type == null) {
            return "object";
        }
        if (type.equals(URI.class.getName()) || type.equals(URL.class.getName())) {
            return "string";
        }
        if (type.equals(File.class.getName())) {
            return "string";
        }
        if (type.equals(Date.class.getName())) {
            return "string";
        }
        if (type.startsWith("java.lang.Class")) {
            return "string";
        }
        if (type.startsWith("java.util.List") || type.startsWith("java.util.Collection")) {
            return "array";
        }
        String primitive = EndpointSchemaGeneratorMojo.getPrimitiveType(type);
        if (primitive != null) {
            return primitive;
        }
        return "object";
    }

    public static String getPrimitiveType(String name) {
        if ("java.lang.byte[]".equals(name) || "byte[]".equals(name)) {
            return "string";
        }
        if ("java.lang.Byte[]".equals(name) || "Byte[]".equals(name)) {
            return "array";
        }
        if ("java.lang.Object[]".equals(name) || "Object[]".equals(name)) {
            return "array";
        }
        if ("java.lang.String[]".equals(name) || "String[]".equals(name)) {
            return "array";
        }
        if ("java.lang.Character".equals(name) || "Character".equals(name) || "char".equals(name)) {
            return "string";
        }
        if ("java.lang.String".equals(name) || "String".equals(name)) {
            return "string";
        }
        if ("java.lang.Boolean".equals(name) || "Boolean".equals(name) || "boolean".equals(name)) {
            return "boolean";
        }
        if ("java.lang.Integer".equals(name) || "Integer".equals(name) || "int".equals(name)) {
            return "integer";
        }
        if ("java.lang.Long".equals(name) || "Long".equals(name) || "long".equals(name)) {
            return "integer";
        }
        if ("java.lang.Short".equals(name) || "Short".equals(name) || "short".equals(name)) {
            return "integer";
        }
        if ("java.lang.Byte".equals(name) || "Byte".equals(name) || "byte".equals(name)) {
            return "integer";
        }
        if ("java.lang.Float".equals(name) || "Float".equals(name) || "float".equals(name)) {
            return "number";
        }
        if ("java.lang.Double".equals(name) || "Double".equals(name) || "double".equals(name)) {
            return "number";
        }
        return null;
    }

    private static Object getDefaultValue(Object defaultValue, String fieldTypeName, boolean isDuration) {
        if ("boolean".equals(fieldTypeName)) {
            defaultValue = EndpointSchemaGeneratorMojo.isNullOrEmpty(defaultValue) ? Boolean.valueOf(false) : Boolean.valueOf("true".equalsIgnoreCase(defaultValue.toString()));
        }
        if (!isDuration) {
            if ("int".equals(fieldTypeName) && !EndpointSchemaGeneratorMojo.isNullOrEmpty(defaultValue) && defaultValue instanceof String) {
                defaultValue = Integer.parseInt(defaultValue.toString());
            }
            if ("long".equals(fieldTypeName) && !EndpointSchemaGeneratorMojo.isNullOrEmpty(defaultValue) && defaultValue instanceof String) {
                defaultValue = Long.parseLong(defaultValue.toString());
            }
            if ("double".equals(fieldTypeName) && !EndpointSchemaGeneratorMojo.isNullOrEmpty(defaultValue) && defaultValue instanceof String) {
                defaultValue = Double.parseDouble(defaultValue.toString());
            }
            if ("float".equals(fieldTypeName) && !EndpointSchemaGeneratorMojo.isNullOrEmpty(defaultValue) && defaultValue instanceof String) {
                defaultValue = Float.valueOf(Float.parseFloat(defaultValue.toString()));
            }
        }
        if (EndpointSchemaGeneratorMojo.isNullOrEmpty(defaultValue)) {
            defaultValue = "";
        }
        return defaultValue;
    }
}

