/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import org.apache.camel.AsyncEndpoint;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.WaitForTaskToComplete;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.seda.BlockingQueueFactory;
import org.apache.camel.component.seda.LinkedBlockingQueueFactory;
import org.apache.camel.component.seda.QueueReference;
import org.apache.camel.component.seda.SedaComponent;
import org.apache.camel.component.seda.SedaConsumer;
import org.apache.camel.component.seda.SedaPollingConsumer;
import org.apache.camel.component.seda.SedaProducer;
import org.apache.camel.spi.BrowsableEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Managed SedaEndpoint")
@UriEndpoint(firstVersion="1.1.0", scheme="seda", title="SEDA", syntax="seda:name", category={Category.CORE, Category.MESSAGING})
public class SedaEndpoint
extends DefaultEndpoint
implements AsyncEndpoint,
BrowsableEndpoint,
MultipleConsumersSupport {
    private static final Logger LOG = LoggerFactory.getLogger(SedaEndpoint.class);
    private final Set<SedaProducer> producers = new CopyOnWriteArraySet<SedaProducer>();
    private final Set<SedaConsumer> consumers = new CopyOnWriteArraySet<SedaConsumer>();
    private volatile AsyncProcessor consumerMulticastProcessor;
    private volatile boolean multicastStarted;
    private volatile ExecutorService multicastExecutor;
    @UriPath(description="Name of queue")
    @Metadata(required=true)
    private String name;
    @UriParam(label="advanced", description="Define the queue instance which will be used by the endpoint")
    private BlockingQueue<Exchange> queue;
    @UriParam(defaultValue="1000")
    private int size = 1000;
    @UriParam(label="consumer", defaultValue="1")
    private int concurrentConsumers = 1;
    @UriParam(label="consumer,advanced", defaultValue="true")
    private boolean limitConcurrentConsumers = true;
    @UriParam(label="consumer,advanced")
    private boolean multipleConsumers;
    @UriParam(label="consumer,advanced")
    private boolean purgeWhenStopping;
    @UriParam(label="consumer,advanced", defaultValue="1000")
    private int pollTimeout = 1000;
    @UriParam(label="producer", defaultValue="IfReplyExpected")
    private WaitForTaskToComplete waitForTaskToComplete = WaitForTaskToComplete.IfReplyExpected;
    @UriParam(label="producer", defaultValue="30000", javaType="java.time.Duration")
    private long timeout = 30000L;
    @UriParam(label="producer", javaType="java.time.Duration")
    private long offerTimeout;
    @UriParam(label="producer")
    private boolean blockWhenFull;
    @UriParam(label="producer")
    private boolean discardWhenFull;
    @UriParam(label="producer")
    private boolean failIfNoConsumers;
    @UriParam(label="producer")
    private boolean discardIfNoConsumers;
    private BlockingQueueFactory<Exchange> queueFactory;
    private volatile QueueReference ref;

    public SedaEndpoint() {
        this.queueFactory = new LinkedBlockingQueueFactory<Exchange>();
    }

    public SedaEndpoint(String endpointUri, Component component, BlockingQueue<Exchange> queue) {
        this(endpointUri, component, queue, 1);
    }

    public SedaEndpoint(String endpointUri, Component component, BlockingQueue<Exchange> queue, int concurrentConsumers) {
        this(endpointUri, component, concurrentConsumers);
        this.queue = queue;
        if (queue != null) {
            this.size = queue.remainingCapacity();
        }
        this.queueFactory = new LinkedBlockingQueueFactory<Exchange>();
        this.getComponent().registerQueue(this, queue);
    }

    public SedaEndpoint(String endpointUri, Component component, BlockingQueueFactory<Exchange> queueFactory, int concurrentConsumers) {
        this(endpointUri, component, concurrentConsumers);
        this.queueFactory = queueFactory;
    }

    private SedaEndpoint(String endpointUri, Component component, int concurrentConsumers) {
        super(endpointUri, component);
        this.concurrentConsumers = concurrentConsumers;
    }

    public SedaComponent getComponent() {
        return (SedaComponent)super.getComponent();
    }

    public Producer createProducer() throws Exception {
        return new SedaProducer(this, this.getWaitForTaskToComplete(), this.getTimeout(), this.isBlockWhenFull(), this.isDiscardWhenFull(), this.getOfferTimeout());
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (this.getComponent() != null) {
            String key = this.getComponent().getQueueKey(this.getEndpointUri());
            QueueReference ref = this.getComponent().getQueueReference(key);
            if (ref != null && ref.getMultipleConsumers().booleanValue() != this.isMultipleConsumers()) {
                throw new IllegalArgumentException("Cannot use existing queue " + key + " as the existing queue multiple consumers " + ref.getMultipleConsumers() + " does not match given multiple consumers " + this.multipleConsumers);
            }
        }
        SedaConsumer answer = this.createNewConsumer(processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    protected SedaConsumer createNewConsumer(Processor processor) {
        return new SedaConsumer(this, processor);
    }

    public PollingConsumer createPollingConsumer() throws Exception {
        SedaPollingConsumer answer = new SedaPollingConsumer((Endpoint)this);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public synchronized BlockingQueue<Exchange> getQueue() {
        if (this.queue == null) {
            if (this.getComponent() != null) {
                Integer size = this.getSize() == Integer.MAX_VALUE || this.getSize() == 1000 ? null : Integer.valueOf(this.getSize());
                QueueReference ref = this.getComponent().getOrCreateQueue(this, size, this.isMultipleConsumers(), this.queueFactory);
                this.queue = ref.getQueue();
                String key = this.getComponent().getQueueKey(this.getEndpointUri());
                LOG.debug("Endpoint {} is using shared queue: {} with size: {}", new Object[]{this, key, ref.getSize() != null ? ref.getSize() : Integer.MAX_VALUE});
                if (ref.getSize() != null) {
                    this.setSize(ref.getSize());
                }
            } else {
                this.queue = this.createQueue();
                LOG.debug("Endpoint {} is using queue: {} with size: {}", new Object[]{this, this.getEndpointUri(), this.getSize()});
            }
        }
        return this.queue;
    }

    protected BlockingQueue<Exchange> createQueue() {
        if (this.size > 0) {
            return this.queueFactory.create(this.size);
        }
        return this.queueFactory.create();
    }

    public QueueReference getQueueReference() {
        if (this.ref == null) {
            this.ref = this.tryQueueRefInit();
        }
        return this.ref;
    }

    private QueueReference tryQueueRefInit() {
        SedaComponent component = this.getComponent();
        if (component != null) {
            String key = component.getQueueKey(this.getEndpointUri());
            return component.getQueueReference(key);
        }
        return null;
    }

    protected synchronized AsyncProcessor getConsumerMulticastProcessor() {
        if (!this.multicastStarted && this.consumerMulticastProcessor != null) {
            ServiceHelper.startService((Object)this.consumerMulticastProcessor);
            this.multicastStarted = true;
        }
        return this.consumerMulticastProcessor;
    }

    protected synchronized void updateMulticastProcessor() throws Exception {
        int size;
        if (!this.isMultipleConsumersSupported()) {
            return;
        }
        if (this.consumerMulticastProcessor != null) {
            ServiceHelper.stopService((Object)this.consumerMulticastProcessor);
            this.consumerMulticastProcessor = null;
        }
        if ((size = this.getConsumers().size()) >= 1) {
            if (this.multicastExecutor == null) {
                this.multicastExecutor = this.getCamelContext().getExecutorServiceManager().newDefaultThreadPool((Object)this, URISupport.sanitizeUri((String)this.getEndpointUri()) + "(multicast)");
            }
            ArrayList<Processor> processors = new ArrayList<Processor>(size);
            for (SedaConsumer consumer : this.getConsumers()) {
                processors.add(consumer.getProcessor());
            }
            this.multicastStarted = false;
            this.consumerMulticastProcessor = (AsyncProcessor)PluginHelper.getProcessorFactory((CamelContext)this.getCamelContext()).createProcessor(this.getCamelContext(), "MulticastProcessor", new Object[]{processors, this.multicastExecutor, false});
        }
    }

    public void setQueue(BlockingQueue<Exchange> queue) {
        this.queue = queue;
        this.size = queue.remainingCapacity();
    }

    @ManagedAttribute(description="Queue max capacity")
    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @ManagedAttribute(description="Current queue size")
    public int getCurrentQueueSize() {
        return this.queue.size();
    }

    public void setBlockWhenFull(boolean blockWhenFull) {
        this.blockWhenFull = blockWhenFull;
    }

    @ManagedAttribute(description="Whether the caller will block sending to a full queue")
    public boolean isBlockWhenFull() {
        return this.blockWhenFull;
    }

    public void setDiscardWhenFull(boolean discardWhenFull) {
        this.discardWhenFull = discardWhenFull;
    }

    @ManagedAttribute(description="Whether the caller will discard sending to a full queue")
    public boolean isDiscardWhenFull() {
        return this.discardWhenFull;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    @ManagedAttribute(description="Number of concurrent consumers")
    public int getConcurrentConsumers() {
        return this.concurrentConsumers;
    }

    @ManagedAttribute
    public boolean isLimitConcurrentConsumers() {
        return this.limitConcurrentConsumers;
    }

    public void setLimitConcurrentConsumers(boolean limitConcurrentConsumers) {
        this.limitConcurrentConsumers = limitConcurrentConsumers;
    }

    public WaitForTaskToComplete getWaitForTaskToComplete() {
        return this.waitForTaskToComplete;
    }

    public void setWaitForTaskToComplete(WaitForTaskToComplete waitForTaskToComplete) {
        this.waitForTaskToComplete = waitForTaskToComplete;
    }

    @ManagedAttribute
    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @ManagedAttribute
    public long getOfferTimeout() {
        return this.offerTimeout;
    }

    public void setOfferTimeout(long offerTimeout) {
        this.offerTimeout = offerTimeout;
    }

    @ManagedAttribute
    public boolean isFailIfNoConsumers() {
        return this.failIfNoConsumers;
    }

    public void setFailIfNoConsumers(boolean failIfNoConsumers) {
        this.failIfNoConsumers = failIfNoConsumers;
    }

    @ManagedAttribute
    public boolean isDiscardIfNoConsumers() {
        return this.discardIfNoConsumers;
    }

    public void setDiscardIfNoConsumers(boolean discardIfNoConsumers) {
        this.discardIfNoConsumers = discardIfNoConsumers;
    }

    @ManagedAttribute
    public boolean isMultipleConsumers() {
        return this.multipleConsumers;
    }

    public void setMultipleConsumers(boolean multipleConsumers) {
        this.multipleConsumers = multipleConsumers;
    }

    @ManagedAttribute
    public int getPollTimeout() {
        return this.pollTimeout;
    }

    public void setPollTimeout(int pollTimeout) {
        this.pollTimeout = pollTimeout;
    }

    @ManagedAttribute
    public boolean isPurgeWhenStopping() {
        return this.purgeWhenStopping;
    }

    public void setPurgeWhenStopping(boolean purgeWhenStopping) {
        this.purgeWhenStopping = purgeWhenStopping;
    }

    public List<Exchange> getExchanges() {
        return new ArrayList<Exchange>(this.getQueue());
    }

    @ManagedAttribute
    public boolean isMultipleConsumersSupported() {
        return this.isMultipleConsumers();
    }

    @ManagedOperation(description="Purges the seda queue")
    public void purgeQueue() {
        LOG.debug("Purging queue with {} exchanges", (Object)this.queue.size());
        this.queue.clear();
    }

    public Set<SedaConsumer> getConsumers() {
        return this.consumers;
    }

    public Set<SedaProducer> getProducers() {
        return new HashSet<SedaProducer>(this.producers);
    }

    void onStarted(SedaProducer producer) {
        this.producers.add(producer);
    }

    void onStopped(SedaProducer producer) {
        this.producers.remove((Object)producer);
    }

    void onStarted(SedaConsumer consumer) throws Exception {
        this.consumers.add(consumer);
        if (this.isMultipleConsumers()) {
            this.updateMulticastProcessor();
        }
    }

    void onStopped(SedaConsumer consumer) throws Exception {
        this.consumers.remove(consumer);
        if (this.isMultipleConsumers()) {
            this.updateMulticastProcessor();
        }
    }

    public boolean hasConsumers() {
        return !this.consumers.isEmpty();
    }

    protected void doInit() throws Exception {
        super.doInit();
        if (this.discardWhenFull && this.blockWhenFull) {
            throw new IllegalArgumentException("Cannot enable both discardWhenFull=true and blockWhenFull=true. You can only either discard or block when full.");
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.queue == null) {
            this.queue = this.getQueue();
        }
        this.ref = this.tryQueueRefInit();
    }

    public void stop() {
        if (this.getConsumers().isEmpty()) {
            super.stop();
        } else {
            LOG.debug("There is still active consumers.");
        }
        this.ref = null;
    }

    public void shutdown() {
        if (this.isShutdown()) {
            LOG.trace("Service already shut down");
            return;
        }
        if (this.getComponent() != null) {
            this.getComponent().onShutdownEndpoint(this);
        }
        if (this.getConsumers().isEmpty()) {
            super.shutdown();
        } else {
            LOG.debug("There is still active consumers.");
        }
    }

    protected void doShutdown() throws Exception {
        if (this.multicastExecutor != null) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow(this.multicastExecutor);
            this.multicastExecutor = null;
        }
        this.queue = null;
        this.ref = null;
    }
}

