/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.attachment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.activation.CommandInfo;
import javax.activation.CommandMap;
import javax.activation.DataContentHandler;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.MailcapCommandMap;
import javax.activation.URLDataSource;
import javax.mail.Header;
import javax.mail.internet.InternetHeaders;
import org.apache.cxf.attachment.AttachmentDataSource;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.attachment.ByteDataSource;
import org.apache.cxf.attachment.ContentDisposition;
import org.apache.cxf.attachment.ImageDataContentHandler;
import org.apache.cxf.attachment.LazyAttachmentCollection;
import org.apache.cxf.attachment.LazyDataSource;
import org.apache.cxf.attachment.QuotedPrintableDecoderStream;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;

public final class AttachmentUtil {
    public static final String BODY_ATTACHMENT_ID = "root.message@cxf.apache.org";
    private static volatile int counter;
    private static final String ATT_UUID;
    private static final Random BOUND_RANDOM;
    private static final CommandMap DEFAULT_COMMAND_MAP;
    private static final MailcapCommandMap COMMAND_MAP;

    private AttachmentUtil() {
    }

    public static CommandMap getCommandMap() {
        return COMMAND_MAP;
    }

    public static boolean isMtomEnabled(Message message) {
        Object prop = message.getContextualProperty("mtom-enabled");
        return MessageUtils.isTrue(prop);
    }

    public static void setStreamedAttachmentProperties(Message message, CachedOutputStream bos) throws IOException {
        Object threshold;
        Object directory = message.getContextualProperty("attachment-directory");
        if (directory != null) {
            if (directory instanceof File) {
                bos.setOutputDir((File)directory);
            } else {
                bos.setOutputDir(new File((String)directory));
            }
        }
        if ((threshold = message.getContextualProperty("attachment-memory-threshold")) != null) {
            if (threshold instanceof Long) {
                bos.setThreshold((Long)threshold);
            } else {
                bos.setThreshold(Long.valueOf((String)threshold));
            }
        } else {
            bos.setThreshold(102400L);
        }
        Object maxSize = message.getContextualProperty("attachment-max-size");
        if (maxSize != null) {
            if (maxSize instanceof Long) {
                bos.setMaxSize((Long)maxSize);
            } else {
                bos.setMaxSize(Long.valueOf((String)maxSize));
            }
        }
    }

    public static String createContentID(String ns) throws UnsupportedEncodingException {
        String cid = "cxf.apache.org";
        String name = ATT_UUID + "-" + String.valueOf(++counter);
        if (ns != null && ns.length() > 0) {
            try {
                String host;
                URI uri = new URI(ns);
                cid = host = uri.toURL().getHost();
            }
            catch (Exception e) {
                cid = ns;
            }
        }
        return URLEncoder.encode(name, "UTF-8") + "@" + URLEncoder.encode(cid, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUniqueBoundaryValue() {
        long leastSigBits = 0L;
        long mostSigBits = 0L;
        Random random = BOUND_RANDOM;
        synchronized (random) {
            mostSigBits = BOUND_RANDOM.nextLong();
            leastSigBits = BOUND_RANDOM.nextLong();
        }
        mostSigBits &= 0xFFFFFFFFFFFF0FFFL;
        leastSigBits &= 0x3FFFFFFFFFFFFFFFL;
        UUID result = new UUID(mostSigBits |= 0x4000L, leastSigBits |= Long.MIN_VALUE);
        return "uuid:" + result.toString();
    }

    public static String getAttachmentPartHeader(Attachment att) {
        String id;
        StringBuilder buffer = new StringBuilder(200);
        buffer.append(HttpHeaderHelper.getHeaderKey("Content-Type") + ": " + att.getDataHandler().getContentType() + ";\r\n");
        if (att.isXOP()) {
            buffer.append("Content-Transfer-Encoding: binary\r\n");
        }
        if ((id = att.getId()).charAt(0) == '<') {
            id = id.substring(1, id.length() - 1);
        }
        buffer.append("Content-ID: <" + id + ">\r\n\r\n");
        return buffer.toString();
    }

    public static Map<String, DataHandler> getDHMap(Collection<Attachment> attachments) {
        Map<Object, Object> dataHandlers = null;
        if (attachments != null) {
            if (attachments instanceof LazyAttachmentCollection) {
                dataHandlers = ((LazyAttachmentCollection)attachments).createDataHandlerMap();
            } else {
                dataHandlers = new LinkedHashMap();
                for (Attachment attachment : attachments) {
                    dataHandlers.put(attachment.getId(), attachment.getDataHandler());
                }
            }
        }
        return dataHandlers == null ? new LinkedHashMap() : dataHandlers;
    }

    public static String cleanContentId(String id) {
        if (id != null) {
            if (id.startsWith("<")) {
                id = id.substring(1, id.length() - 1);
            }
            if (id.startsWith("cid:")) {
                id = id.substring(4);
            }
            try {
                id = URLDecoder.decode(id, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (id == null) {
            id = BODY_ATTACHMENT_ID;
        }
        return id;
    }

    public static Attachment createAttachment(InputStream stream, InternetHeaders headers) throws IOException {
        AttachmentDataSource source;
        String id = AttachmentUtil.cleanContentId(headers.getHeader("Content-ID", null));
        AttachmentImpl att = new AttachmentImpl(id);
        String ct = headers.getHeader("Content-Type", null);
        String cd = headers.getHeader("Content-Disposition", null);
        String fileName = AttachmentUtil.getContentDispositionFileName(cd);
        boolean quotedPrintable = false;
        Enumeration e = headers.getAllHeaders();
        while (e.hasMoreElements()) {
            Header header = (Header)e.nextElement();
            if (header.getName().equalsIgnoreCase("Content-Transfer-Encoding")) {
                if (header.getValue().equalsIgnoreCase("binary")) {
                    att.setXOP(true);
                } else if (header.getValue().equalsIgnoreCase("quoted-printable")) {
                    quotedPrintable = true;
                }
            }
            att.setHeader(header.getName(), header.getValue());
        }
        if (quotedPrintable) {
            source = new AttachmentDataSource(ct, new QuotedPrintableDecoderStream(stream));
            if (!StringUtils.isEmpty(fileName)) {
                source.setName(fileName);
            }
            att.setDataHandler(new DataHandler((DataSource)source));
        } else {
            source = new AttachmentDataSource(ct, stream);
            if (!StringUtils.isEmpty(fileName)) {
                source.setName(fileName);
            }
            att.setDataHandler(new DataHandler((DataSource)source));
        }
        return att;
    }

    static String getContentDispositionFileName(String cd) {
        if (StringUtils.isEmpty(cd)) {
            return null;
        }
        ContentDisposition c = new ContentDisposition(cd);
        String s = c.getParameter("filename");
        if (s == null) {
            s = c.getParameter("name");
        }
        return s;
    }

    public static boolean isTypeSupported(String contentType, List<String> types) {
        if (contentType == null) {
            return false;
        }
        contentType = contentType.toLowerCase();
        for (String s : types) {
            if (contentType.indexOf(s) == -1) continue;
            return true;
        }
        return false;
    }

    public static Attachment createMtomAttachment(boolean isXop, String mimeType, String elementNS, byte[] data, int offset, int length, int threshold) {
        String id;
        if (!isXop || length <= threshold) {
            return null;
        }
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        ByteDataSource source = new ByteDataSource(data, offset, length);
        source.setContentType(mimeType);
        DataHandler handler = new DataHandler((DataSource)source);
        try {
            id = AttachmentUtil.createContentID(elementNS);
        }
        catch (UnsupportedEncodingException e) {
            throw new Fault(e);
        }
        AttachmentImpl att = new AttachmentImpl(id, handler);
        att.setXOP(isXop);
        return att;
    }

    public static Attachment createMtomAttachmentFromDH(boolean isXop, DataHandler handler, String elementNS, int threshold) {
        String id;
        Object file;
        if (!isXop) {
            return null;
        }
        try {
            DataSource ds = handler.getDataSource();
            if (ds instanceof FileDataSource) {
                FileDataSource fds = (FileDataSource)ds;
                file = fds.getFile();
                if (((File)file).length() < (long)threshold) {
                    return null;
                }
            } else if (ds.getClass().getName().endsWith("ObjectDataSource")) {
                Object o = handler.getContent();
                if (o instanceof String && ((String)o).length() < threshold) {
                    return null;
                }
                if (o instanceof byte[] && ((byte[])o).length < threshold) {
                    return null;
                }
            }
        }
        catch (IOException e1) {
            // empty catch block
        }
        try {
            id = AttachmentUtil.createContentID(elementNS);
        }
        catch (UnsupportedEncodingException e) {
            throw new Fault(e);
        }
        AttachmentImpl att = new AttachmentImpl(id, handler);
        if (!StringUtils.isEmpty(handler.getName())) {
            file = handler.getName();
            File f = new File((String)file);
            if (f.exists() && f.isFile()) {
                file = f.getName();
            }
            att.setHeader("Content-Disposition", "attachment;name=\"" + (String)file + "\"");
        }
        att.setXOP(isXop);
        return att;
    }

    public static DataSource getAttachmentDataSource(String contentId, Collection<Attachment> atts) {
        if (contentId.startsWith("cid:")) {
            try {
                contentId = URLDecoder.decode(contentId.substring(4), "UTF-8");
            }
            catch (UnsupportedEncodingException ue) {
                contentId = contentId.substring(4);
            }
            return AttachmentUtil.loadDataSource(contentId, atts);
        }
        if (contentId.indexOf("://") == -1) {
            return AttachmentUtil.loadDataSource(contentId, atts);
        }
        try {
            return new URLDataSource(new URL(contentId));
        }
        catch (MalformedURLException e) {
            throw new Fault(e);
        }
    }

    private static DataSource loadDataSource(String contentId, Collection<Attachment> atts) {
        return new LazyDataSource(contentId, atts);
    }

    static {
        ATT_UUID = UUID.randomUUID().toString();
        BOUND_RANDOM = new Random();
        DEFAULT_COMMAND_MAP = CommandMap.getDefaultCommandMap();
        COMMAND_MAP = new EnhancedMailcapCommandMap();
        COMMAND_MAP.addMailcap("image/*;;x-java-content-handler=" + ImageDataContentHandler.class.getName());
    }

    static final class EnhancedMailcapCommandMap
    extends MailcapCommandMap {
        EnhancedMailcapCommandMap() {
        }

        public synchronized DataContentHandler createDataContentHandler(String mimeType) {
            DataContentHandler dch = super.createDataContentHandler(mimeType);
            if (dch == null) {
                dch = DEFAULT_COMMAND_MAP.createDataContentHandler(mimeType);
            }
            return dch;
        }

        public DataContentHandler createDataContentHandler(String mimeType, DataSource ds) {
            DataContentHandler dch = super.createDataContentHandler(mimeType);
            if (dch == null) {
                dch = DEFAULT_COMMAND_MAP.createDataContentHandler(mimeType, ds);
            }
            return dch;
        }

        public synchronized CommandInfo[] getAllCommands(String mimeType) {
            CommandInfo[] commands = super.getAllCommands(mimeType);
            CommandInfo[] defaultCommands = DEFAULT_COMMAND_MAP.getAllCommands(mimeType);
            ArrayList<CommandInfo> cmdList = new ArrayList<CommandInfo>(Arrays.asList(commands));
            for (CommandInfo defCmdInfo : defaultCommands) {
                String defCmdName = defCmdInfo.getCommandName();
                boolean cmdNameExist = false;
                for (CommandInfo cmdInfo : commands) {
                    if (!cmdInfo.getCommandName().equals(defCmdName)) continue;
                    cmdNameExist = true;
                    break;
                }
                if (cmdNameExist) continue;
                cmdList.add(defCmdInfo);
            }
            CommandInfo[] allCommandArray = new CommandInfo[]{};
            return cmdList.toArray(allCommandArray);
        }

        public synchronized CommandInfo getCommand(String mimeType, String cmdName) {
            CommandInfo cmdInfo = super.getCommand(mimeType, cmdName);
            if (cmdInfo == null) {
                cmdInfo = DEFAULT_COMMAND_MAP.getCommand(mimeType, cmdName);
            }
            return cmdInfo;
        }

        public synchronized String[] getMimeTypes() {
            String[] mimeTypes = super.getMimeTypes();
            String[] defMimeTypes = DEFAULT_COMMAND_MAP.getMimeTypes();
            HashSet<String> mimeTypeSet = new HashSet<String>();
            mimeTypeSet.addAll(Arrays.asList(mimeTypes));
            mimeTypeSet.addAll(Arrays.asList(defMimeTypes));
            String[] mimeArray = new String[]{};
            return mimeTypeSet.toArray(mimeArray);
        }
    }
}

