/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.spring;

import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.ws.rs.Path;
import org.apache.cxf.annotations.Provider;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.common.util.ClasspathScanner;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.spring.AbstractSpringConfigurationFactory;
import org.apache.cxf.jaxrs.spring.JAXRSServerFactoryBeanDefinitionParser;
import org.apache.cxf.jaxrs.spring.SpringResourceFactory;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.FilterType;

@ComponentScan(includeFilters={@ComponentScan.Filter(type=FilterType.ANNOTATION, value={Path.class, javax.ws.rs.ext.Provider.class, Provider.class})})
public abstract class AbstractSpringComponentScanServer
extends AbstractSpringConfigurationFactory {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractSpringComponentScanServer.class);
    @Value(value="${cxf.jaxrs.classes-scan-packages:}")
    private String classesScanPackages;
    @Value(value="${cxf.jaxrs.component-scan-packages:}")
    private String componentScanPackages;
    @Value(value="${cxf.jaxrs.component-scan-beans:}")
    private String componentScanBeans;
    private List<ResourceProvider> resourceProviders = new LinkedList<ResourceProvider>();
    private List<Object> jaxrsProviders = new LinkedList<Object>();
    private List<Feature> cxfFeatures = new LinkedList<Feature>();
    private List<Interceptor<? extends Message>> cxfInInterceptors = new LinkedList<Interceptor<? extends Message>>();
    private List<Interceptor<? extends Message>> cxfOutInterceptors = new LinkedList<Interceptor<? extends Message>>();
    private Class<? extends Annotation> serviceAnnotation;

    protected AbstractSpringComponentScanServer() {
    }

    protected AbstractSpringComponentScanServer(Class<? extends Annotation> serviceAnnotation) {
        this.serviceAnnotation = serviceAnnotation;
    }

    @Override
    protected void setJaxrsResources(JAXRSServerFactoryBean factory) {
        boolean checkJaxrsRoots = this.checkJaxrsRoots();
        boolean checkJaxrsProviders = this.checkJaxrsProviders();
        boolean checkCxfProviders = this.checkCxfProviders();
        Set componentScanPackagesSet = !StringUtils.isEmpty((String)this.componentScanPackages) ? ClasspathScanner.parsePackages((String)this.componentScanPackages) : null;
        Set componentScanBeansSet = !StringUtils.isEmpty((String)this.componentScanBeans) ? ClasspathScanner.parsePackages((String)this.componentScanBeans) : null;
        for (String beanName : this.applicationContext.getBeanDefinitionNames()) {
            if (checkJaxrsRoots && this.isValidComponent(beanName, Path.class, componentScanPackagesSet, componentScanBeansSet)) {
                SpringResourceFactory resourceFactory = new SpringResourceFactory(beanName);
                resourceFactory.setApplicationContext(this.applicationContext);
                this.resourceProviders.add(resourceFactory);
                continue;
            }
            if (checkJaxrsProviders && this.isValidComponent(beanName, javax.ws.rs.ext.Provider.class, componentScanPackagesSet, componentScanBeansSet)) {
                this.jaxrsProviders.add(this.getProviderBean(beanName));
                continue;
            }
            if (!checkCxfProviders || !this.isValidComponent(beanName, Provider.class, componentScanPackagesSet, componentScanBeansSet)) continue;
            this.addCxfProvider(this.getProviderBean(beanName));
        }
        if (!StringUtils.isEmpty((String)this.classesScanPackages)) {
            try {
                Map classes = ClasspathScanner.findClasses((String)this.classesScanPackages, (Class[])new Class[]{javax.ws.rs.ext.Provider.class, Provider.class});
                this.jaxrsProviders.addAll(JAXRSServerFactoryBeanDefinitionParser.createBeansFromDiscoveredClasses(this.applicationContext, (Collection)classes.get(javax.ws.rs.ext.Provider.class), null));
                AbstractSpringComponentScanServer.warnIfDuplicatesAvailable(this.jaxrsProviders);
                List<Object> cxfProviders = JAXRSServerFactoryBeanDefinitionParser.createBeansFromDiscoveredClasses(this.applicationContext, (Collection)classes.get(Provider.class), null);
                for (Object cxfProvider : cxfProviders) {
                    this.addCxfProvider(cxfProvider);
                }
                AbstractSpringComponentScanServer.warnIfDuplicatesAvailable(this.cxfFeatures);
            }
            catch (Exception ex) {
                throw new ServiceConstructionException((Throwable)ex);
            }
        }
        factory.setResourceProviders(this.getResourceProviders());
        factory.setProviders(this.getJaxrsProviders());
        factory.setFeatures(this.getFeatures());
        factory.setInInterceptors(this.getInInterceptors());
        factory.setOutInterceptors(this.getOutInterceptors());
    }

    protected boolean isValidComponent(String beanName, Class<? extends Annotation> ann, Set<String> componentScanPackagesSet, Set<String> componentScanBeansSet) {
        return this.isAnnotationAvailable(beanName, ann) && this.nonProxyClass(beanName) && this.matchesServiceAnnotation(beanName) && this.matchesComponentPackage(beanName, componentScanPackagesSet) && this.matchesComponentName(beanName, componentScanBeansSet);
    }

    protected boolean nonProxyClass(String beanName) {
        Class type = ClassHelper.getRealClassFromClass((Class)this.applicationContext.getType(beanName));
        if (Proxy.isProxyClass(type) && this.applicationContext.isSingleton(beanName)) {
            type = ClassHelper.getRealClass((Object)this.applicationContext.getBean(beanName));
        }
        if (Proxy.isProxyClass(type)) {
            LOG.fine("Can not determine the real class of the component '" + beanName + "'");
            return false;
        }
        return true;
    }

    protected boolean matchesComponentName(String beanName, Set<String> componentScanBeansSet) {
        return componentScanBeansSet == null || componentScanBeansSet.contains(beanName);
    }

    protected boolean matchesComponentPackage(String beanName, Set<String> componentScanPackagesSet) {
        return componentScanPackagesSet == null || !this.applicationContext.isSingleton(beanName) || componentScanPackagesSet.contains(PackageUtils.getPackageName(this.applicationContext.getBean(beanName).getClass()));
    }

    private static void warnIfDuplicatesAvailable(List<? extends Object> providers) {
        HashSet<String> classNames = new HashSet<String>();
        for (Object object : providers) {
            if (classNames.add(object.getClass().getName())) continue;
            LOG.warning("Duplicate Provider " + object.getClass().getName() + " has been detected");
        }
    }

    private Object getProviderBean(String beanName) {
        return this.applicationContext.getBean(beanName);
    }

    protected void addCxfProvider(Object bean) {
        Provider ann = bean.getClass().getAnnotation(Provider.class);
        if (ann.scope() == Provider.Scope.Client) {
            return;
        }
        if (ann.value() == Provider.Type.Feature) {
            this.cxfFeatures.add((Feature)bean);
        } else if (ann.value() == Provider.Type.InInterceptor) {
            this.cxfInInterceptors.add((Interceptor<? extends Message>)((Interceptor)bean));
        } else if (ann.value() == Provider.Type.OutInterceptor) {
            this.cxfOutInterceptors.add((Interceptor<? extends Message>)((Interceptor)bean));
        }
    }

    protected boolean matchesServiceAnnotation(String beanName) {
        return this.serviceAnnotation == null || this.isAnnotationAvailable(beanName, this.serviceAnnotation);
    }

    protected <A extends Annotation> boolean isAnnotationAvailable(String beanName, Class<A> annClass) {
        return this.applicationContext.findAnnotationOnBean(beanName, annClass) != null;
    }

    protected boolean checkCxfProviders() {
        return true;
    }

    protected boolean checkJaxrsProviders() {
        return true;
    }

    protected boolean checkJaxrsRoots() {
        return true;
    }

    protected List<ResourceProvider> getResourceProviders() {
        return this.resourceProviders;
    }

    @Override
    protected List<Object> getJaxrsProviders() {
        return this.jaxrsProviders;
    }

    @Override
    public List<Feature> getFeatures() {
        return this.cxfFeatures;
    }

    public List<Interceptor<? extends Message>> getInInterceptors() {
        return this.cxfInInterceptors;
    }

    public List<Interceptor<? extends Message>> getOutInterceptors() {
        return this.cxfOutInterceptors;
    }
}

