/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.swagger.ui;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;

public class SwaggerUiResolver {
    protected static final String UI_RESOURCES_ROOT_START = "META-INF/resources/webjars/swagger-ui/";
    private final ClassLoader cl;

    public SwaggerUiResolver(ClassLoader cl) {
        this.cl = cl;
    }

    public String findSwaggerUiRootInternal(String swaggerUiMavenGroupAndArtifact, String swaggerUiVersion) {
        try {
            if (this.cl instanceof URLClassLoader) {
                for (URL url : ((URLClassLoader)this.cl).getURLs()) {
                    String root = SwaggerUiResolver.checkUiRoot(url.toString(), swaggerUiVersion);
                    if (root == null) continue;
                    return root;
                }
            }
            Enumeration<URL> urls = this.cl.getResources(UI_RESOURCES_ROOT_START);
            while (urls.hasMoreElements()) {
                String urlStr = urls.nextElement().toString().replace(UI_RESOURCES_ROOT_START, "");
                String root = SwaggerUiResolver.checkUiRoot(urlStr, swaggerUiVersion);
                if (root == null) continue;
                return root;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    protected static String checkUiRoot(String urlStr, String swaggerUiVersion) {
        int swaggerUiIndex = urlStr.lastIndexOf("/swagger-ui-");
        if (swaggerUiIndex != -1 && urlStr.matches("^.*\\.jar!?/?$")) {
            String version = urlStr.substring(swaggerUiIndex + 12, urlStr.lastIndexOf(".jar"));
            if (swaggerUiVersion != null && !swaggerUiVersion.equals(version)) {
                return null;
            }
            if (!urlStr.endsWith("/")) {
                urlStr = "jar:" + urlStr + "!/";
            }
            return urlStr + UI_RESOURCES_ROOT_START + version + "/";
        }
        return null;
    }
}

