/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.swagger;

import io.swagger.annotations.Api;
import java.net.URL;
import org.apache.cxf.jaxrs.swagger.SwaggerUiResolver;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class OsgiSwaggerUiResolver
extends SwaggerUiResolver {
    private static final String[] LOCATIONS = new String[]{"mvn:org.webjars/swagger-ui/", "wrap:mvn:org.webjars/swagger-ui/"};

    OsgiSwaggerUiResolver() throws Exception {
        Class.forName("org.osgi.framework.FrameworkUtil");
    }

    @Override
    protected String findSwaggerUiRootInternal(String swaggerUiVersion) {
        try {
            Bundle bundle = FrameworkUtil.getBundle(Api.class);
            if (bundle == null) {
                return null;
            }
            for (Bundle b : bundle.getBundleContext().getBundles()) {
                String location = b.getLocation();
                for (String pattern : LOCATIONS) {
                    if (swaggerUiVersion != null) {
                        if (!location.equals(pattern + swaggerUiVersion)) continue;
                        return this.getSwaggerUiRoot(b, swaggerUiVersion);
                    }
                    if (!location.startsWith(pattern)) continue;
                    int dollarIndex = location.indexOf("$");
                    swaggerUiVersion = location.substring(pattern.length(), dollarIndex > pattern.length() ? dollarIndex : location.length());
                    return this.getSwaggerUiRoot(b, swaggerUiVersion);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private String getSwaggerUiRoot(Bundle b, String swaggerUiVersion) {
        String resourcesRootStart = "META-INF/resources/webjars/swagger-ui/";
        URL entry = b.getEntry("META-INF/resources/webjars/swagger-ui/" + swaggerUiVersion);
        if (entry != null) {
            return entry.toString() + "/";
        }
        return null;
    }
}

