/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.dq.rule.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.DataQualityTaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.dp.ExecuteSqlType;
import org.apache.dolphinscheduler.plugin.task.dq.exception.DataQualityException;
import org.apache.dolphinscheduler.plugin.task.dq.rule.entity.DqRuleExecuteSql;
import org.apache.dolphinscheduler.plugin.task.dq.rule.parameter.BaseConfig;
import org.apache.dolphinscheduler.plugin.task.dq.rule.parameter.DataQualityConfiguration;
import org.apache.dolphinscheduler.plugin.task.dq.rule.parser.IRuleParser;
import org.apache.dolphinscheduler.plugin.task.dq.rule.parser.MappingColumn;
import org.apache.dolphinscheduler.plugin.task.dq.utils.RuleParserUtils;

public class MultiTableAccuracyRuleParser
implements IRuleParser {
    @Override
    public DataQualityConfiguration parse(Map<String, String> inputParameterValue, DataQualityTaskExecutionContext context) throws DataQualityException {
        List dqRuleExecuteSqlList = JSONUtils.toList((String)context.getExecuteSqlList(), DqRuleExecuteSql.class);
        DqRuleExecuteSql statisticsSql = RuleParserUtils.getExecuteSqlListByType(dqRuleExecuteSqlList, ExecuteSqlType.STATISTICS).get(0);
        inputParameterValue.put("statistics_table", statisticsSql.getTableAlias());
        int index = 1;
        List<BaseConfig> readerConfigList = RuleParserUtils.getReaderConfigList(inputParameterValue, context);
        RuleParserUtils.addStatisticsValueTableReaderConfig(readerConfigList, context);
        ArrayList<BaseConfig> transformerConfigList = new ArrayList<BaseConfig>();
        List<MappingColumn> mappingColumnList = RuleParserUtils.getMappingColumnList(inputParameterValue.get("mapping_columns"));
        inputParameterValue.put("on_clause", RuleParserUtils.getOnClause(mappingColumnList, inputParameterValue));
        inputParameterValue.put("where_clause", RuleParserUtils.getWhereClause(mappingColumnList, inputParameterValue));
        index = RuleParserUtils.replaceExecuteSqlPlaceholder(dqRuleExecuteSqlList, index, inputParameterValue, transformerConfigList);
        String writerSql = "select ${rule_type} as rule_type,${rule_name} as rule_name,${process_definition_id} as process_definition_id,${process_instance_id} as process_instance_id,${task_instance_id} as task_instance_id,${statistics_name} AS statistics_value,${comparison_name} AS comparison_value,${comparison_type} AS comparison_type,${check_type} as check_type,${threshold} as threshold,${operator} as operator,${failure_strategy} as failure_strategy,'${error_output_path}' as error_output_path,${create_time} as create_time,${update_time} as update_time from ${statistics_table} full join ${comparison_table}";
        if (context.isCompareWithFixedValue()) {
            writerSql = writerSql.replaceAll("full join \\$\\{comparison_table}", "");
        }
        List<BaseConfig> writerConfigList = RuleParserUtils.getAllWriterConfigList(inputParameterValue, context, index, transformerConfigList, writerSql, "select ${process_definition_id} as process_definition_id,${task_instance_id} as task_instance_id,${rule_id} as rule_id,${unique_code} as unique_code,'${statistics_name}'AS statistics_name,${statistics_name} AS statistics_value,${data_time} as data_time,${create_time} as create_time,${update_time} as update_time from ${statistics_table}");
        return new DataQualityConfiguration(context.getRuleName(), RuleParserUtils.getEnvConfig(), readerConfigList, writerConfigList, transformerConfigList);
    }
}

