/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.channel;

import java.io.IOException;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateByteBuffer;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.checkpoint.channel.RecoveredChannelStateHandler;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.io.network.partition.consumer.RecoveredInputChannel;

class InputChannelRecoveredStateHandler
implements RecoveredChannelStateHandler<InputChannelInfo, Buffer> {
    private final InputGate[] inputGates;

    InputChannelRecoveredStateHandler(InputGate[] inputGates) {
        this.inputGates = inputGates;
    }

    @Override
    public RecoveredChannelStateHandler.BufferWithContext<Buffer> getBuffer(InputChannelInfo channelInfo) throws IOException, InterruptedException {
        RecoveredInputChannel channel = this.getChannel(channelInfo);
        Buffer buffer = channel.requestBufferBlocking();
        return new RecoveredChannelStateHandler.BufferWithContext<Buffer>(ChannelStateByteBuffer.wrap(buffer), buffer);
    }

    @Override
    public void recover(InputChannelInfo channelInfo, Buffer buffer) {
        if (buffer.readableBytes() > 0) {
            this.getChannel(channelInfo).onRecoveredStateBuffer(buffer);
        } else {
            buffer.recycleBuffer();
        }
    }

    @Override
    public void close() throws IOException {
        for (InputGate inputGate : this.inputGates) {
            inputGate.finishReadRecoveredState();
        }
    }

    private RecoveredInputChannel getChannel(InputChannelInfo info) {
        return (RecoveredInputChannel)this.inputGates[info.getGateIdx()].getChannel(info.getInputChannelIdx());
    }
}

