/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.types;

import java.io.Serializable;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceIDRetrievable;
import org.apache.flink.util.Preconditions;

public class SlotID
implements ResourceIDRetrievable,
Serializable {
    private static final long serialVersionUID = -6399206032549807771L;
    private final ResourceID resourceId;
    private final int slotNumber;

    public SlotID(ResourceID resourceId, int slotNumber) {
        Preconditions.checkArgument((0 <= slotNumber ? 1 : 0) != 0, (Object)"Slot number must be positive.");
        this.resourceId = (ResourceID)Preconditions.checkNotNull((Object)resourceId, (String)"ResourceID must not be null");
        this.slotNumber = slotNumber;
    }

    private SlotID(ResourceID resourceID) {
        this.resourceId = (ResourceID)Preconditions.checkNotNull((Object)resourceID, (String)"ResourceID must not be null");
        this.slotNumber = -1;
    }

    @Override
    public ResourceID getResourceID() {
        return this.resourceId;
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlotID slotID = (SlotID)o;
        return this.slotNumber == slotID.slotNumber && this.resourceId.equals(slotID.resourceId);
    }

    public int hashCode() {
        int result = this.resourceId.hashCode();
        result = 31 * result + this.slotNumber;
        return result;
    }

    public String toString() {
        return this.resourceId + "_" + (this.slotNumber >= 0 ? Integer.valueOf(this.slotNumber) : "dynamic");
    }

    public static SlotID generateDynamicSlotID(ResourceID resourceID) {
        return new SlotID(resourceID);
    }
}

