/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.dispatcher.DispatcherJobResult;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.jobmaster.JobManagerRunner;
import org.apache.flink.runtime.jobmaster.JobMasterGateway;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.messages.webmonitor.JobDetails;
import org.apache.flink.util.AutoCloseableAsync;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DispatcherJob
implements AutoCloseableAsync {
    private final Logger log = LoggerFactory.getLogger(DispatcherJob.class);
    private final CompletableFuture<JobManagerRunner> jobManagerRunnerFuture;
    private final CompletableFuture<DispatcherJobResult> jobResultFuture;
    private final CompletableFuture<Void> terminationFuture = new CompletableFuture();
    private final long initializationTimestamp;
    private final JobID jobId;
    private final String jobName;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private DispatcherJobStatus jobStatus = DispatcherJobStatus.INITIALIZING;

    static DispatcherJob createFor(CompletableFuture<JobManagerRunner> jobManagerRunnerFuture, JobID jobId, String jobName, long initializationTimestamp) {
        return new DispatcherJob(jobManagerRunnerFuture, jobId, jobName, initializationTimestamp);
    }

    private DispatcherJob(CompletableFuture<JobManagerRunner> jobManagerRunnerFuture, JobID jobId, String jobName, long initializationTimestamp) {
        this.jobManagerRunnerFuture = jobManagerRunnerFuture;
        this.jobId = jobId;
        this.jobName = jobName;
        this.initializationTimestamp = initializationTimestamp;
        this.jobResultFuture = new CompletableFuture();
        FutureUtils.assertNoException(this.jobManagerRunnerFuture.handle((jobManagerRunner, throwable) -> {
            Object object = this.lock;
            synchronized (object) {
                this.jobStatus = DispatcherJobStatus.JOB_MANAGER_RUNNER_INITIALIZED;
                if (throwable == null) {
                    jobManagerRunner.getResultFuture().whenComplete((archivedExecutionGraph, resultThrowable) -> {
                        if (archivedExecutionGraph != null) {
                            this.jobResultFuture.complete(DispatcherJobResult.forSuccess(archivedExecutionGraph));
                        } else {
                            this.jobResultFuture.completeExceptionally(ExceptionUtils.stripCompletionException((Throwable)resultThrowable));
                        }
                    });
                } else {
                    Throwable strippedThrowable = ExceptionUtils.stripCompletionException((Throwable)throwable);
                    ArchivedExecutionGraph archivedExecutionGraph2 = ArchivedExecutionGraph.createFromInitializingJob(jobId, jobName, JobStatus.FAILED, strippedThrowable, initializationTimestamp);
                    this.jobResultFuture.complete(DispatcherJobResult.forInitializationFailure(archivedExecutionGraph2, strippedThrowable));
                }
            }
            return null;
        }));
    }

    public CompletableFuture<DispatcherJobResult> getResultFuture() {
        return this.jobResultFuture;
    }

    public CompletableFuture<JobDetails> requestJobDetails(Time timeout) {
        return this.requestJob(timeout).thenApply(executionGraph -> {
            Object object = this.lock;
            synchronized (object) {
                return JobDetails.createDetailsForJob(executionGraph);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Acknowledge> cancel(Time timeout) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isInitialized()) {
                return this.getJobMasterGateway().thenCompose(jobMasterGateway -> jobMasterGateway.cancel(timeout));
            }
            this.log.info("Cancellation during initialization requested for job {}. Job will be cancelled once JobManager has been initialized.", (Object)this.jobId);
            CompletionStage cancelFuture = ((CompletableFuture)this.jobManagerRunnerFuture.thenCompose(JobManagerRunner::getJobMasterGateway)).thenCompose(jobMasterGateway -> jobMasterGateway.cancel(timeout));
            ((CompletableFuture)cancelFuture).whenComplete((ignored, cancelThrowable) -> {
                if (cancelThrowable != null) {
                    this.log.warn("Cancellation of job {} failed", (Object)this.jobId, cancelThrowable);
                }
            });
            this.jobStatus = DispatcherJobStatus.CANCELLING;
            return cancelFuture;
        }
    }

    public CompletableFuture<JobStatus> requestJobStatus(Time timeout) {
        return this.requestJob(timeout).thenApply(ArchivedExecutionGraph::getState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<ArchivedExecutionGraph> requestJob(Time timeout) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isInitialized()) {
                if (this.jobResultFuture.isDone()) {
                    return this.jobResultFuture.thenApply(DispatcherJobResult::getArchivedExecutionGraph);
                }
                return this.getJobMasterGateway().thenCompose(jobMasterGateway -> jobMasterGateway.requestJob(timeout));
            }
            Preconditions.checkState((this.jobStatus == DispatcherJobStatus.INITIALIZING || this.jobStatus == DispatcherJobStatus.CANCELLING ? 1 : 0) != 0);
            return CompletableFuture.completedFuture(ArchivedExecutionGraph.createFromInitializingJob(this.jobId, this.jobName, this.jobStatus.asJobStatus(), null, this.initializationTimestamp));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInitialized() {
        Object object = this.lock;
        synchronized (object) {
            return this.jobStatus == DispatcherJobStatus.JOB_MANAGER_RUNNER_INITIALIZED;
        }
    }

    public CompletableFuture<JobMasterGateway> getJobMasterGateway() {
        Preconditions.checkState((boolean)this.isInitialized(), (Object)"JobMaster Gateway is not available during initialization");
        return this.jobManagerRunnerFuture.thenCompose(JobManagerRunner::getJobMasterGateway);
    }

    public CompletableFuture<Void> closeAsync() {
        FutureUtils.assertNoException(this.jobManagerRunnerFuture.handle((runner, throwable) -> {
            if (throwable == null) {
                CompletionStage jobManagerRunnerClose = this.jobManagerRunnerFuture.thenCompose(AutoCloseableAsync::closeAsync);
                FutureUtils.forward(jobManagerRunnerClose, this.terminationFuture);
            } else {
                this.terminationFuture.complete(null);
            }
            return null;
        }));
        return this.terminationFuture;
    }

    private static enum DispatcherJobStatus {
        INITIALIZING(JobStatus.INITIALIZING),
        JOB_MANAGER_RUNNER_INITIALIZED(null),
        CANCELLING(JobStatus.CANCELLING);

        @Nullable
        private final JobStatus jobStatus;

        private DispatcherJobStatus(JobStatus jobStatus) {
            this.jobStatus = jobStatus;
        }

        public JobStatus asJobStatus() {
            if (this.jobStatus == null) {
                throw new IllegalStateException("This state is not defined as a 'JobStatus'");
            }
            return this.jobStatus;
        }
    }
}

