/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.metrics;

import org.apache.flink.api.common.JobStatus;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.util.Preconditions;

public class RestartTimeGauge
implements Gauge<Long> {
    public static final String METRIC_NAME = "restartingTime";
    private final ExecutionGraph eg;

    public RestartTimeGauge(ExecutionGraph executionGraph) {
        this.eg = (ExecutionGraph)Preconditions.checkNotNull((Object)executionGraph);
    }

    public Long getValue() {
        JobStatus status = this.eg.getState();
        long restartingTimestamp = this.eg.getStatusTimestamp(JobStatus.RESTARTING);
        if (restartingTimestamp <= 0L) {
            return 0L;
        }
        long switchToRunningTimestamp = this.eg.getStatusTimestamp(JobStatus.RUNNING);
        long lastRestartTime = switchToRunningTimestamp >= restartingTimestamp ? switchToRunningTimestamp - restartingTimestamp : (status.isTerminalState() ? this.eg.getStatusTimestamp(status) - restartingTimestamp : System.currentTimeMillis() - restartingTimestamp);
        return Math.max(lastRestartTime, 0L);
    }
}

