/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.restart;

import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.runtime.executiongraph.restart.NoOrFixedIfCheckpointingEnabledRestartStrategyFactory;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategyFactory;
import org.apache.flink.util.Preconditions;

public final class RestartStrategyResolving {
    public static RestartStrategy resolve(RestartStrategies.RestartStrategyConfiguration clientConfiguration, RestartStrategyFactory serverStrategyFactory, boolean isCheckpointingEnabled) {
        Preconditions.checkNotNull((Object)serverStrategyFactory);
        RestartStrategy clientSideRestartStrategy = RestartStrategyFactory.createRestartStrategy(clientConfiguration);
        if (clientSideRestartStrategy != null) {
            return clientSideRestartStrategy;
        }
        if (serverStrategyFactory instanceof NoOrFixedIfCheckpointingEnabledRestartStrategyFactory) {
            return ((NoOrFixedIfCheckpointingEnabledRestartStrategyFactory)serverStrategyFactory).createRestartStrategy(isCheckpointingEnabled);
        }
        return serverStrategyFactory.createRestartStrategy();
    }

    private RestartStrategyResolving() {
    }
}

