/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.net.ProtocolException;
import org.apache.flink.runtime.io.network.netty.ByteBufUtils;
import org.apache.flink.runtime.io.network.netty.NettyMessage;
import org.apache.flink.runtime.io.network.netty.NettyMessageDecoder;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;

class NonBufferResponseDecoder
extends NettyMessageDecoder {
    private static final int INITIAL_MESSAGE_HEADER_BUFFER_LENGTH = 128;
    private ByteBuf messageBuffer;

    NonBufferResponseDecoder() {
    }

    @Override
    public void onChannelActive(ChannelHandlerContext ctx) {
        this.messageBuffer = ctx.alloc().directBuffer(128);
    }

    @Override
    void onNewMessageReceived(int msgId, int messageLength) {
        super.onNewMessageReceived(msgId, messageLength);
        this.messageBuffer.clear();
        this.ensureBufferCapacity();
    }

    @Override
    public NettyMessageDecoder.DecodingResult onChannelRead(ByteBuf data) throws Exception {
        ByteBuf fullFrameHeaderBuf = ByteBufUtils.accumulate(this.messageBuffer, data, this.messageLength, this.messageBuffer.readableBytes());
        if (fullFrameHeaderBuf == null) {
            return NettyMessageDecoder.DecodingResult.NOT_FINISHED;
        }
        switch (this.msgId) {
            case 1: {
                return NettyMessageDecoder.DecodingResult.fullMessage(NettyMessage.ErrorResponse.readFrom(fullFrameHeaderBuf));
            }
        }
        throw new ProtocolException("Received unknown message from producer: " + this.msgId);
    }

    private void ensureBufferCapacity() {
        if (this.messageBuffer.capacity() < this.messageLength) {
            this.messageBuffer.capacity(this.messageLength);
        }
    }

    @Override
    public void close() {
        this.messageBuffer.release();
    }
}

