/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.scheduler;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationConstraintDesc;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationGroup;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.Preconditions;

public class CoLocationGroupDesc {
    private final AbstractID id;
    private final List<JobVertexID> vertices;

    private CoLocationGroupDesc(AbstractID id, List<JobVertexID> vertices) {
        this.id = (AbstractID)Preconditions.checkNotNull((Object)id);
        this.vertices = (List)Preconditions.checkNotNull(vertices);
    }

    public AbstractID getId() {
        return this.id;
    }

    public List<JobVertexID> getVertices() {
        return Collections.unmodifiableList(this.vertices);
    }

    public CoLocationConstraintDesc getLocationConstraint(int index) {
        return new CoLocationConstraintDesc(this.id, index);
    }

    public static CoLocationGroupDesc from(CoLocationGroup group) {
        return new CoLocationGroupDesc(group.getId(), group.getVertices().stream().map(JobVertex::getID).collect(Collectors.toList()));
    }

    @VisibleForTesting
    public static CoLocationGroupDesc from(JobVertexID ... ids) {
        return new CoLocationGroupDesc(new AbstractID(), Arrays.asList(ids));
    }
}

