/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.scheduler;

import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.instance.SlotSharingGroupId;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationConstraint;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.util.Preconditions;

public class ScheduledUnit {
    private final ExecutionVertexID executionVertexId;
    private final SlotSharingGroupId slotSharingGroupId;
    @Nullable
    private final CoLocationConstraint coLocationConstraint;

    @VisibleForTesting
    public ScheduledUnit(Execution task) {
        this(task, new SlotSharingGroupId());
    }

    public ScheduledUnit(Execution task, SlotSharingGroupId slotSharingGroupId) {
        this(task, slotSharingGroupId, null);
    }

    public ScheduledUnit(Execution task, SlotSharingGroupId slotSharingGroupId, @Nullable CoLocationConstraint coLocationConstraint) {
        this(((Execution)Preconditions.checkNotNull((Object)task)).getVertex().getID(), slotSharingGroupId, coLocationConstraint);
    }

    @VisibleForTesting
    public ScheduledUnit(JobVertexID jobVertexId, SlotSharingGroupId slotSharingGroupId, @Nullable CoLocationConstraint coLocationConstraint) {
        this(new ExecutionVertexID(jobVertexId, 0), slotSharingGroupId, coLocationConstraint);
    }

    public ScheduledUnit(ExecutionVertexID executionVertexId, SlotSharingGroupId slotSharingGroupId, @Nullable CoLocationConstraint coLocationConstraint) {
        this.executionVertexId = (ExecutionVertexID)Preconditions.checkNotNull((Object)executionVertexId);
        this.slotSharingGroupId = slotSharingGroupId;
        this.coLocationConstraint = coLocationConstraint;
    }

    public JobVertexID getJobVertexId() {
        return this.executionVertexId.getJobVertexId();
    }

    public int getSubtaskIndex() {
        return this.executionVertexId.getSubtaskIndex();
    }

    public SlotSharingGroupId getSlotSharingGroupId() {
        return this.slotSharingGroupId;
    }

    @Nullable
    public CoLocationConstraint getCoLocationConstraint() {
        return this.coLocationConstraint;
    }

    public String toString() {
        return "{task=" + this.executionVertexId + ", sharingUnit=" + (Object)((Object)this.slotSharingGroupId) + ", locationConstraint=" + this.coLocationConstraint + '}';
    }
}

