/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElectionDriver;
import org.apache.flink.runtime.leaderelection.LeaderElectionDriverFactory;
import org.apache.flink.runtime.leaderelection.LeaderElectionEventHandler;
import org.apache.flink.runtime.leaderelection.LeaderElectionException;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLeaderElectionService
implements LeaderElectionService,
LeaderElectionEventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLeaderElectionService.class);
    private final Object lock = new Object();
    private final LeaderElectionDriverFactory leaderElectionDriverFactory;
    private volatile LeaderContender leaderContender;
    @GuardedBy(value="lock")
    private volatile UUID issuedLeaderSessionID;
    @GuardedBy(value="lock")
    private volatile UUID confirmedLeaderSessionID;
    @GuardedBy(value="lock")
    private volatile String confirmedLeaderAddress;
    @GuardedBy(value="lock")
    private volatile boolean running;
    private LeaderElectionDriver leaderElectionDriver;

    public DefaultLeaderElectionService(LeaderElectionDriverFactory leaderElectionDriverFactory) {
        this.leaderElectionDriverFactory = (LeaderElectionDriverFactory)Preconditions.checkNotNull((Object)leaderElectionDriverFactory);
        this.leaderContender = null;
        this.issuedLeaderSessionID = null;
        this.confirmedLeaderSessionID = null;
        this.confirmedLeaderAddress = null;
        this.leaderElectionDriver = null;
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start(LeaderContender contender) throws Exception {
        Preconditions.checkNotNull((Object)contender, (String)"Contender must not be null.");
        Preconditions.checkState((this.leaderContender == null ? 1 : 0) != 0, (Object)"Contender was already set.");
        Object object = this.lock;
        synchronized (object) {
            this.leaderContender = contender;
            this.leaderElectionDriver = this.leaderElectionDriverFactory.createLeaderElectionDriver(this, new LeaderElectionFatalErrorHandler(), this.leaderContender.getDescription());
            LOG.info("Starting DefaultLeaderElectionService with {}.", (Object)this.leaderElectionDriver);
            this.running = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stop() throws Exception {
        LOG.info("Stopping DefaultLeaderElectionService.");
        Object object = this.lock;
        synchronized (object) {
            if (!this.running) {
                return;
            }
            this.running = false;
            this.clearConfirmedLeaderInformation();
        }
        this.leaderElectionDriver.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void confirmLeadership(UUID leaderSessionID, String leaderAddress) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Confirm leader session ID {} for leader {}.", (Object)leaderSessionID, (Object)leaderAddress);
        }
        Preconditions.checkNotNull((Object)leaderSessionID);
        Object object = this.lock;
        synchronized (object) {
            if (this.hasLeadership(leaderSessionID)) {
                if (this.running) {
                    this.confirmLeaderInformation(leaderSessionID, leaderAddress);
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("Ignoring the leader session Id {} confirmation, since the LeaderElectionService has already been stopped.", (Object)leaderSessionID);
                }
            } else if (!leaderSessionID.equals(this.issuedLeaderSessionID)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Receive an old confirmation call of leader session ID {}, current issued session ID is {}", (Object)leaderSessionID, (Object)this.issuedLeaderSessionID);
                }
            } else {
                LOG.warn("The leader session ID {} was confirmed even though the corresponding JobManager was not elected as the leader.", (Object)leaderSessionID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasLeadership(@Nonnull UUID leaderSessionId) {
        Object object = this.lock;
        synchronized (object) {
            if (this.running) {
                return this.leaderElectionDriver.hasLeadership() && leaderSessionId.equals(this.issuedLeaderSessionID);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("hasLeadership is called after the service is stopped, returning false.");
            }
            return false;
        }
    }

    @Nullable
    @VisibleForTesting
    public UUID getLeaderSessionID() {
        return this.confirmedLeaderSessionID;
    }

    @GuardedBy(value="lock")
    private void confirmLeaderInformation(UUID leaderSessionID, String leaderAddress) {
        this.confirmedLeaderSessionID = leaderSessionID;
        this.confirmedLeaderAddress = leaderAddress;
        this.leaderElectionDriver.writeLeaderInformation(LeaderInformation.known(this.confirmedLeaderSessionID, this.confirmedLeaderAddress));
    }

    @GuardedBy(value="lock")
    private void clearConfirmedLeaderInformation() {
        this.confirmedLeaderSessionID = null;
        this.confirmedLeaderAddress = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public void onGrantLeadership() {
        Object object = this.lock;
        synchronized (object) {
            if (this.running) {
                this.issuedLeaderSessionID = UUID.randomUUID();
                this.clearConfirmedLeaderInformation();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Grant leadership to contender {} with session ID {}.", (Object)this.leaderContender.getDescription(), (Object)this.issuedLeaderSessionID);
                }
                this.leaderContender.grantLeadership(this.issuedLeaderSessionID);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring the grant leadership notification since the {} has already been closed.", (Object)this.leaderElectionDriver);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public void onRevokeLeadership() {
        Object object = this.lock;
        synchronized (object) {
            if (this.running) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Revoke leadership of {} ({}@{}).", new Object[]{this.leaderContender.getDescription(), this.confirmedLeaderSessionID, this.confirmedLeaderAddress});
                }
                this.issuedLeaderSessionID = null;
                this.clearConfirmedLeaderInformation();
                this.leaderContender.revokeLeadership();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Clearing the leader information on {}.", (Object)this.leaderElectionDriver);
                }
                this.leaderElectionDriver.writeLeaderInformation(LeaderInformation.empty());
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring the revoke leadership notification since the {} has already been closed.", (Object)this.leaderElectionDriver);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public void onLeaderInformationChange(LeaderInformation leaderInformation) {
        Object object = this.lock;
        synchronized (object) {
            if (this.running) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Leader node changed while {} is the leader with session ID {}.", (Object)this.leaderContender.getDescription(), (Object)this.confirmedLeaderSessionID);
                }
                if (this.confirmedLeaderSessionID != null) {
                    LeaderInformation confirmedLeaderInfo = LeaderInformation.known(this.confirmedLeaderSessionID, this.confirmedLeaderAddress);
                    if (leaderInformation.isEmpty()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Writing leader information by {} since the external storage is empty.", (Object)this.leaderContender.getDescription());
                        }
                        this.leaderElectionDriver.writeLeaderInformation(confirmedLeaderInfo);
                    } else if (!leaderInformation.equals(confirmedLeaderInfo)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Correcting leader information by {}.", (Object)this.leaderContender.getDescription());
                        }
                        this.leaderElectionDriver.writeLeaderInformation(confirmedLeaderInfo);
                    }
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring change notification since the {} has already been closed.", (Object)this.leaderElectionDriver);
            }
        }
    }

    private class LeaderElectionFatalErrorHandler
    implements FatalErrorHandler {
        private LeaderElectionFatalErrorHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFatalError(Throwable throwable) {
            Object object = DefaultLeaderElectionService.this.lock;
            synchronized (object) {
                if (!DefaultLeaderElectionService.this.running) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Ignoring error notification since the service has been stopped.");
                    }
                    return;
                }
                if (throwable instanceof LeaderElectionException) {
                    DefaultLeaderElectionService.this.leaderContender.handleError((Exception)((Object)((LeaderElectionException)((Object)throwable))));
                } else {
                    DefaultLeaderElectionService.this.leaderContender.handleError((Exception)((Object)new LeaderElectionException(throwable)));
                }
            }
        }
    }
}

