/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.query;

import java.util.Objects;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.util.Preconditions;

public class KvStateInfo<K, N, V> {
    private final TypeSerializer<K> keySerializer;
    private final TypeSerializer<N> namespaceSerializer;
    private final TypeSerializer<V> stateValueSerializer;

    public KvStateInfo(TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, TypeSerializer<V> stateValueSerializer) {
        this.keySerializer = (TypeSerializer)Preconditions.checkNotNull(keySerializer);
        this.namespaceSerializer = (TypeSerializer)Preconditions.checkNotNull(namespaceSerializer);
        this.stateValueSerializer = (TypeSerializer)Preconditions.checkNotNull(stateValueSerializer);
    }

    public TypeSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public TypeSerializer<N> getNamespaceSerializer() {
        return this.namespaceSerializer;
    }

    public TypeSerializer<V> getStateValueSerializer() {
        return this.stateValueSerializer;
    }

    public KvStateInfo<K, N, V> duplicate() {
        TypeSerializer dupKeySerializer = this.keySerializer.duplicate();
        TypeSerializer dupNamespaceSerializer = this.namespaceSerializer.duplicate();
        TypeSerializer dupSVSerializer = this.stateValueSerializer.duplicate();
        if (dupKeySerializer == this.keySerializer && dupNamespaceSerializer == this.namespaceSerializer && dupSVSerializer == this.stateValueSerializer) {
            return this;
        }
        return new KvStateInfo<K, N, V>(dupKeySerializer, dupNamespaceSerializer, dupSVSerializer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KvStateInfo stateInfo = (KvStateInfo)o;
        return Objects.equals(this.keySerializer, stateInfo.keySerializer) && Objects.equals(this.namespaceSerializer, stateInfo.namespaceSerializer) && Objects.equals(this.stateValueSerializer, stateInfo.stateValueSerializer);
    }

    public int hashCode() {
        return Objects.hash(this.keySerializer, this.namespaceSerializer, this.stateValueSerializer);
    }
}

